/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PublicApi
public class DataFetcherResult<T> {
    private final T data;
    private final List<GraphQLError> errors;
    private final Object localContext;
    private final boolean mapRelativeErrors;

    @Internal
    @Deprecated
    public DataFetcherResult(T data, List<GraphQLError> errors) {
        this(data, errors, null, false);
    }

    private DataFetcherResult(T data, List<GraphQLError> errors, Object localContext, boolean mapRelativeErrors) {
        this.data = data;
        this.errors = Collections.unmodifiableList(Assert.assertNotNull(errors));
        this.localContext = localContext;
        this.mapRelativeErrors = mapRelativeErrors;
    }

    public T getData() {
        return this.data;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public boolean isMapRelativeErrors() {
        return this.mapRelativeErrors;
    }

    public static <T> Builder<T> newResult() {
        return new Builder();
    }

    public static class Builder<T> {
        private T data;
        private Object localContext;
        private final List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private boolean mapRelativeErrors = false;

        public Builder(T data) {
            this.data = data;
        }

        public Builder() {
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public Builder<T> errors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder<T> error(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder<T> mapRelativeErrors(boolean mapRelativeErrors) {
            this.mapRelativeErrors = mapRelativeErrors;
            return this;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public Builder<T> localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public DataFetcherResult<T> build() {
            return new DataFetcherResult(this.data, this.errors, this.localContext, this.mapRelativeErrors);
        }
    }
}

