/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.util;

import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.AngleUnit;
import manifold.science.measures.ChargeUnit;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.FrequencyUnit;
import manifold.science.measures.HeatCapacityUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.TemperatureUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.measures.VolumeUnit;

public interface UnitConstants {
    public static final LengthUnit mum = LengthUnit.Micro;
    public static final LengthUnit mm = LengthUnit.Milli;
    public static final LengthUnit cm = LengthUnit.Centi;
    public static final LengthUnit m = LengthUnit.Meter;
    public static final LengthUnit km = LengthUnit.Kilometer;
    public static final LengthUnit in = LengthUnit.Inch;
    public static final LengthUnit ft = LengthUnit.Foot;
    public static final LengthUnit yd = LengthUnit.Yard;
    public static final LengthUnit mi = LengthUnit.Mile;
    public static final TimeUnit ns = TimeUnit.Nano;
    public static final TimeUnit mus = TimeUnit.Micro;
    public static final TimeUnit ms = TimeUnit.Milli;
    public static final TimeUnit s = TimeUnit.Second;
    public static final TimeUnit min = TimeUnit.Minute;
    public static final TimeUnit hr = TimeUnit.Hour;
    public static final TimeUnit day = TimeUnit.Day;
    public static final TimeUnit wk = TimeUnit.Week;
    public static final TimeUnit mo = TimeUnit.Month;
    public static final TimeUnit yr = TimeUnit.Year;
    public static final TimeUnit tmo = TimeUnit.TrMonth;
    public static final TimeUnit tyr = TimeUnit.TrYear;
    public static final MassUnit amu = MassUnit.AtomicMass;
    public static final MassUnit mug = MassUnit.Micro;
    public static final MassUnit mg = MassUnit.Milli;
    public static final MassUnit g = MassUnit.Gram;
    public static final MassUnit kg = MassUnit.Kilogram;
    public static final MassUnit ct = MassUnit.Carat;
    public static final MassUnit dr = MassUnit.Dram;
    public static final MassUnit gr = MassUnit.Grain;
    public static final MassUnit Nt = MassUnit.Newton;
    public static final MassUnit oz = MassUnit.Ounce;
    public static final MassUnit ozt = MassUnit.TroyOunce;
    public static final MassUnit lb = MassUnit.Pound;
    public static final MassUnit slug = MassUnit.Slug;
    public static final MassUnit st = MassUnit.Stone;
    public static final MassUnit sht = MassUnit.Ton;
    public static final MassUnit lt = MassUnit.TonUK;
    public static final MassUnit tonne = MassUnit.Tonne;
    public static final MassUnit Mo = MassUnit.Solar;
    public static final VolumeUnit L = VolumeUnit.LITER;
    public static final VolumeUnit mL = VolumeUnit.MILLI_LITER;
    public static final VolumeUnit fl_oz = VolumeUnit.FLUID_OZ;
    public static final VolumeUnit gal = VolumeUnit.GALLON;
    public static final VolumeUnit qt = VolumeUnit.QUART;
    public static final VolumeUnit pt = VolumeUnit.PINT;
    public static final VolumeUnit cup = VolumeUnit.CUP;
    public static final VolumeUnit tbsp = VolumeUnit.TABLE_SPOON;
    public static final VolumeUnit tsp = VolumeUnit.TEA_SPOON;
    public static final AngleUnit cyc = AngleUnit.Turn;
    public static final AngleUnit rad = AngleUnit.Radian;
    public static final AngleUnit mrad = AngleUnit.Milli;
    public static final AngleUnit nrad = AngleUnit.Nano;
    public static final AngleUnit arcsec = AngleUnit.ArcSecond;
    public static final AngleUnit mas = AngleUnit.MilliArcSecond;
    public static final AngleUnit grad = AngleUnit.Gradian;
    public static final AngleUnit quad = AngleUnit.Quadrant;
    public static final AngleUnit moa = AngleUnit.MOA;
    public static final AngleUnit deg = AngleUnit.Degree;
    public static final TemperatureUnit dK = TemperatureUnit.Kelvin;
    public static final TemperatureUnit dC = TemperatureUnit.Celsius;
    public static final TemperatureUnit dF = TemperatureUnit.Fahrenheit;
    public static final VelocityUnit mph = mi.div(hr);
    public static final AccelerationUnit ag = AccelerationUnit.GRAVITY;
    public static final MomentumUnit Ns = m.div(s).postfixBind(kg);
    public static final ForceUnit N = m.div(s).postfixBind(kg).div(s);
    public static final ForceUnit dyn = cm.div(s).postfixBind(g).div(s);
    public static final ForceUnit lbf = ft.div(s).postfixBind(slug).div(s);
    public static final EnergyUnit joule;
    public static final EnergyUnit J;
    public static final EnergyUnit erg;
    public static final EnergyUnit kcal;
    public static final PowerUnit watt;
    public static final PowerUnit W;
    public static final HeatCapacityUnit C;
    public static final FrequencyUnit Hz;
    public static final FrequencyUnit kHz;
    public static final FrequencyUnit MHz;
    public static final FrequencyUnit GHz;
    public static final FrequencyUnit rpm;
    public static final ChargeUnit coulomb;
    public static final CurrentUnit amp;

    static {
        J = joule = m.postfixBind(N);
        erg = cm.postfixBind(dyn);
        kcal = EnergyUnit.kcal;
        W = watt = J.div(s);
        C = J.div(dK);
        Hz = cyc.div(s);
        kHz = cyc.div(ms);
        MHz = cyc.div(mus);
        GHz = cyc.div(ns);
        rpm = cyc.div(min);
        coulomb = ChargeUnit.Coulomb;
        amp = coulomb.div(s);
    }
}

