/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Acceleration;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.Area;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.Density;
import manifold.science.measures.DensityUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Momentum;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.Pressure;
import manifold.science.measures.PressureUnit;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.measures.Volume;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.Rational;

public final class Mass
extends AbstractMeasure<MassUnit, Mass> {
    public Mass(Rational value, MassUnit unit, MassUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Mass(Rational value, MassUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public MassUnit getBaseUnit() {
        return MassUnit.BASE;
    }

    @Override
    public Mass make(Rational value, MassUnit unit, MassUnit displayUnit) {
        return new Mass(value, unit, displayUnit);
    }

    @Override
    public Mass make(Rational value, MassUnit unit) {
        return new Mass(value, unit);
    }

    public Force times(Acceleration a) {
        return new Force(this.toBaseNumber().times(a.toBaseNumber()), ForceUnit.BASE, ForceUnit.get((MassUnit)this.getDisplayUnit(), (AccelerationUnit)a.getDisplayUnit()));
    }

    public Momentum times(Velocity v) {
        return new Momentum(this.toBaseNumber().times(v.toBaseNumber()), MomentumUnit.BASE, MomentumUnit.get((MassUnit)this.getDisplayUnit(), (VelocityUnit)v.getDisplayUnit()));
    }

    public Pressure div(Area area) {
        return new Pressure(this.toBaseNumber().div(area.toBaseNumber()), PressureUnit.BASE, PressureUnit.get((MassUnit)this.getDisplayUnit(), (AreaUnit)area.getDisplayUnit()));
    }

    public Area div(Pressure p) {
        return new Area(this.toBaseNumber().div(p.toBaseNumber()), AreaUnit.BASE, ((PressureUnit)p.getDisplayUnit()).getAreaUnit());
    }

    public Density div(Volume volume) {
        return new Density(this.toBaseNumber().div(volume.toBaseNumber()), DensityUnit.BASE, DensityUnit.get((MassUnit)this.getDisplayUnit(), (VolumeUnit)volume.getDisplayUnit()));
    }

    public Volume div(Density d) {
        return new Volume(this.toBaseNumber().div(d.toBaseNumber()), VolumeUnit.BASE, ((DensityUnit)d.getDisplayUnit()).getVolumeUnit());
    }
}

