/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Area;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.measures.VelocityUnit;
import manifold.science.measures.Volume;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.Rational;

public final class Length
extends AbstractMeasure<LengthUnit, Length> {
    public Length(Rational value, LengthUnit unit, LengthUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Length(Rational value, LengthUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public LengthUnit getBaseUnit() {
        return LengthUnit.BASE;
    }

    @Override
    public Length make(Rational value, LengthUnit unit, LengthUnit displayUnit) {
        return new Length(value, unit, displayUnit);
    }

    @Override
    public Length make(Rational value, LengthUnit unit) {
        return new Length(value, unit, unit);
    }

    public Velocity div(Time t) {
        return new Velocity(this.toBaseNumber().div(t.toBaseNumber()), VelocityUnit.BASE, VelocityUnit.get((LengthUnit)this.getDisplayUnit(), (TimeUnit)t.getDisplayUnit()));
    }

    public Time div(Velocity v) {
        return new Time(this.toBaseNumber().div(v.toBaseNumber()), TimeUnit.BASE, ((VelocityUnit)v.getDisplayUnit()).getTimeUnit());
    }

    public Area times(Length len) {
        return new Area(this.toBaseNumber().times(len.toBaseNumber()), AreaUnit.BASE, AreaUnit.get((LengthUnit)this.getDisplayUnit(), (LengthUnit)len.getDisplayUnit()));
    }

    public Volume times(Area area) {
        return new Volume(this.toBaseNumber().times(area.toBaseNumber()), VolumeUnit.BASE, VolumeUnit.get((LengthUnit)this.getDisplayUnit(), (AreaUnit)area.getDisplayUnit()));
    }

    public Energy times(Force force) {
        return new Energy(this.toBaseNumber().times(force.toBaseNumber()), EnergyUnit.BASE, EnergyUnit.get((ForceUnit)force.getDisplayUnit(), (LengthUnit)this.getDisplayUnit()));
    }
}

