/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt;

import java.util.Iterator;
import java.util.Map;
import manifold.ext.rt.api.IBindingsBacked;
import manifold.ext.rt.api.IListBacked;
import manifold.json.rt.api.IJsonParser;
import manifold.rt.api.ScriptException;
import manifold.rt.api.util.ManEscapeUtil;
import manifold.rt.api.util.Pair;
import manifold.util.concurrent.LocklessLazyVar;

public class Json {
    private static String _parser = System.getProperty("manifold.json.parser");
    private static final LocklessLazyVar<IJsonParser> PARSER = new LocklessLazyVar<IJsonParser>(){

        @Override
        protected IJsonParser init() {
            String fqn = Json.getParserName();
            return fqn == null ? IJsonParser.getDefaultParser() : this.makeParser(fqn);
        }

        private IJsonParser makeParser(String fqn) {
            try {
                return (IJsonParser)Class.forName(fqn).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String getParserName() {
        return _parser;
    }

    public static void setParserName(String fqn) {
        _parser = fqn;
        PARSER.clear();
    }

    public static String toJson(Map thisMap) {
        StringBuilder sb = new StringBuilder();
        Json.toJson(thisMap, sb, 0);
        return sb.toString();
    }

    public static void toJson(Map thisMap, StringBuilder sb, int indent) {
        int iKey = 0;
        if (Json.isNewLine(sb)) {
            Json.indent(sb, indent);
        }
        sb.append("{\n");
        if (thisMap.size() > 0) {
            for (Object key : thisMap.keySet()) {
                Json.indent(sb, indent + 2);
                sb.append('\"').append(key).append('\"').append(": ");
                Object value = thisMap.get(key);
                value = Json.toBindings(value);
                if (value instanceof Map) {
                    Json.toJson((Map)value, sb, indent + 2);
                } else if (value instanceof Iterable) {
                    Json.listToJson(sb, indent + 2, (Iterable)value);
                } else {
                    Json.appendValue(sb, value);
                }
                Json.appendCommaNewLine(sb, iKey < thisMap.size() - 1);
                ++iKey;
            }
        }
        Json.indent(sb, indent);
        sb.append("}");
    }

    public static Object toBindings(Object value) {
        if (value instanceof IBindingsBacked) {
            value = ((IBindingsBacked)((Object)value)).getBindings();
        } else if (value instanceof IListBacked) {
            value = ((IListBacked)value).getList();
        }
        return value;
    }

    public static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public static StringBuilder appendValue(StringBuilder sb, Object comp) {
        if (comp instanceof String) {
            sb.append('\"');
            sb.append(ManEscapeUtil.escapeForJavaStringLiteral((String)comp));
            sb.append('\"');
        } else if (comp instanceof Integer || comp instanceof Long || comp instanceof Double || comp instanceof Float || comp instanceof Short || comp instanceof Character || comp instanceof Byte || comp instanceof Boolean) {
            sb.append(comp);
        } else if (comp == null) {
            sb.append("null");
        } else {
            throw new IllegalStateException("Unsupported expando type: " + comp.getClass());
        }
        return sb;
    }

    public static String toJson(Object value) {
        StringBuilder target = new StringBuilder();
        Json.toJson(target, 0, value);
        return target.toString();
    }

    public static void toJson(StringBuilder target, int margin, Object value) {
        if ((value = Json.toBindings(value)) instanceof Pair) {
            value = ((Pair)value).getSecond();
        }
        if ((value = Json.toBindings(value)) instanceof Map) {
            Json.toJson((Map)value, target, margin);
        } else if (value instanceof Iterable) {
            Json.listToJson(target, margin, (Iterable)value);
        } else {
            Json.appendValue(target, value);
        }
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder sb, int indent, Iterable value) {
        sb.append('[');
        int i = 0;
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            Object comp = iter.next();
            if (i == 0) {
                sb.append("\n");
            }
            if ((comp = Json.toBindings(comp)) instanceof Map) {
                Json.toJson((Map)comp, sb, indent + 2);
            } else if (comp instanceof Iterable) {
                Json.listToJson(sb, indent + 2, (Iterable)comp);
            } else {
                Json.indent(sb, indent + 2);
                Json.appendValue(sb, comp);
            }
            Json.appendCommaNewLine(sb, iter.hasNext());
            ++i;
        }
        Json.indent(sb, indent);
        sb.append("]");
    }

    public static String listToJson(Iterable list) {
        StringBuilder sb = new StringBuilder();
        Json.listToJson(sb, 0, list);
        return sb.toString();
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    public static Object fromJson(String json) {
        return Json.fromJson(json, false, false);
    }

    public static Object fromJson(String json, boolean withBigNumbers, boolean withTokens) {
        try {
            return PARSER.get().parseJson(json, withBigNumbers, withTokens);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }
}

