/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.js.JavascriptModel;
import manifold.js.JavascriptProgram;
import manifold.js.rt.JsRuntime;
import manifold.js.rt.parser.tree.template.JSTNode;
import manifold.js.rt.parser.tree.template.RawStringNode;
import manifold.rt.api.DisableStringLiteralTemplates;
import manifold.rt.api.util.ManEscapeUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptTemplate {
    static SrcClass genClass(JavascriptModel model, String fqn, JSTNode jstNode) {
        String url;
        SrcClass clazz = (SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).addImport(JsRuntime.class);
        IFile file = JavascriptProgram.loadSrcForName(model, fqn, "js");
        try {
            url = file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String source = ResourceFileTypeManifold.getContent(file);
        source = ManEscapeUtil.escapeForJavaStringLiteral(source);
        clazz.addField(((SrcField)((SrcField)new SrcField("TEMPLATE_NODE", JSTNode.class).addAnnotation(new SrcAnnotationExpression(DisableStringLiteralTemplates.class))).modifiers(24L)).initializer(JsRuntime.class.getSimpleName() + ".initNode(\"" + fqn + "\",\"" + source + "\",\"" + url + "\")"));
        clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(24L)).initializer(JsRuntime.class.getSimpleName() + ".initEngine(TEMPLATE_NODE)"));
        Object srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name("renderToString")).modifiers(9L)).returns(String.class);
        List<SrcParameter> srcParameters = JavascriptProgram.makeSrcParameters(jstNode, srcMethod);
        ((AbstractSrcMethod)srcMethod).body("return " + JavascriptTemplate.class.getTypeName() + ".renderToStringImpl(SCOPE, TEMPLATE_NODE" + JavascriptProgram.generateArgList(srcParameters) + ");");
        clazz.addMethod((AbstractSrcMethod)srcMethod);
        return clazz;
    }

    public static String renderToStringImpl(ScriptableObject scope, JSTNode templateNode, Object ... args) {
        try {
            List rawStrings;
            Object[] argsWithStrings = Arrays.copyOf(args, args.length + 1);
            argsWithStrings[argsWithStrings.length - 1] = rawStrings = templateNode.getChildren(RawStringNode.class).stream().map(node -> node.genCode()).collect(Collectors.toList());
            Function renderToString = (Function)scope.get("renderToString", (Scriptable)scope);
            return (String)renderToString.call(Context.getCurrentContext(), scope, scope, argsWithStrings);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

