/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ICompilerComponent;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.internal.javac.CompiledTypeProcessor;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class TypeProcessor
extends CompiledTypeProcessor {
    private final Set<Object> _drivers = new ConcurrentHashSet<Object>();
    private SortedSet<ICompilerComponent> _compilerComponents;

    TypeProcessor(IManifoldHost host, BasicJavacTask javacTask) {
        super(host, javacTask);
        this.loadCompilerComponents(javacTask);
    }

    private void loadCompilerComponents(BasicJavacTask javacTask) {
        this._compilerComponents = new TreeSet<ICompilerComponent>(Comparator.comparing(c -> c.getClass().getTypeName()));
        ServiceUtil.loadRegisteredServices(this._compilerComponents, ICompilerComponent.class, this.getClass().getClassLoader());
        this._compilerComponents.forEach(cc -> cc.init(javacTask, this));
    }

    public Collection<ICompilerComponent> getCompilerComponents() {
        return this._compilerComponents;
    }

    @Override
    public void process(TypeElement element, IssueReporter<JavaFileObject> issueReporter) {
        if (IDynamicJdk.isInitializing()) {
            return;
        }
        for (ITypeManifold sp : this.getHost().getSingleModule().getTypeManifolds()) {
            if (!(sp instanceof ITypeProcessor)) continue;
            try {
                ((ITypeProcessor)((Object)sp)).process(element, this, issueReporter);
            }
            catch (Throwable e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                issueReporter.reportError("Fatal error processing with Manifold type processor: " + sp.getClass().getName() + "\non type: " + element.getQualifiedName() + "\nPlease report the error with the accompanying stack trace.\n" + stackTrace);
                throw e;
            }
        }
    }

    public void addDrivers(Set<Object> drivers) {
        this._drivers.addAll(drivers);
    }

    public Set<Object> getDrivers() {
        return this._drivers;
    }

    public void addTaskListener(TaskListener listener) {
        this.getJavacTask().removeTaskListener(this);
        this.getJavacTask().addTaskListener(listener);
        this.getJavacTask().addTaskListener(this);
    }
}

