/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.RichDiagnosticFormatter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.fs.def.FileFragmentImpl;
import manifold.api.type.ContributorKind;
import manifold.api.type.ICompilerComponent;
import manifold.api.type.ITypeManifold;
import manifold.api.util.IssueMsg;
import manifold.api.util.JavacDiagnostic;
import manifold.api.util.JavacUtil;
import manifold.internal.host.JavacManifoldHost;
import manifold.internal.javac.ArrayTypeExtender;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.ManClassWriter;
import manifold.internal.javac.ManParserFactory;
import manifold.internal.javac.ManResolve;
import manifold.internal.javac.ManTransTypes;
import manifold.internal.javac.ManTypes;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.internal.javac.ParseProcessor;
import manifold.internal.javac.TypeProcessor;
import manifold.internal.runtime.Bootstrap;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.StreamUtil;
import manifold.util.JreUtil;
import manifold.util.NecessaryEvilUtil;
import manifold.util.ReflectUtil;

public class JavacPlugin
implements Plugin,
TaskListener {
    public static final String ARG_DYNAMIC = "dynamic";
    public static final String ARG_NO_BOOTSTRAP = "no-bootstrap";
    public static final String[] ARGS = new String[]{"no-bootstrap", "dynamic"};
    private static final String MANIFOLD_SOURCE = "manifold.source";
    private static final String MANIFOLD_SOURCE_MAPPING = "manifold.source.";
    private static final String OTHER_SOURCE_FILES = "other.source.files";
    private static final String OTHER_SOURCE_LIST = "other.source.list";
    private static Class<?> CLASSFINDER_CLASS = null;
    private static Class<?> MODULES_CLASS = null;
    private static Class<?> MODULEFINDER_CLASS = null;
    private static JavacPlugin INSTANCE;
    private JavacManifoldHost _host;
    private Context _ctx;
    private JavaFileManager _fileManager;
    private BasicJavacTask _javacTask;
    private Set<Pair<String, JavaFileObject>> _javaInputFiles;
    private Map<String, String> _otherSourceMappings;
    private List<String> _otherInputFiles;
    private TypeProcessor _typeProcessor;
    private IssueReporter _issueReporter;
    private ManifoldJavaFileManager _manFileManager;
    private boolean _initialized;
    private Map<Context, Set<Symbol>> _seenModules;
    private Map<String, Boolean> _argPresent;
    private ArrayList<FileFragmentResource> _fileFragmentResources;
    private Set<String> _javaSourcePath;
    private List<String> _manifoldSourcePath;
    private String _bootclasspath;
    private boolean _isIncremental;
    private static final String RESOURCE_ROOTS = "//## ResourceRoots:";

    public static JavacPlugin instance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "Manifold";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        INSTANCE = this;
        NecessaryEvilUtil.bypassJava9Security();
        this._javacTask = (BasicJavacTask)task;
        JavacProcessingEnvironment jpe = JavacProcessingEnvironment.instance(this._javacTask.getContext());
        this.processArgs(jpe, args);
        if (JreUtil.isJava16orLater()) {
            NecessaryEvilUtil.openModule(this.getContext(), "jdk.compiler");
        }
        this._host = new JavacManifoldHost();
        this._fileFragmentResources = new ArrayList();
        this._javaSourcePath = Collections.emptySet();
        this.assignBootclasspath();
        this.hijackJavacFileManager();
        this.overrideJavacToolEnter();
        task.addTaskListener(this);
    }

    private void overrideJavacToolEnter() {
        String JavadocTool_class = JreUtil.isJava8() ? "com.sun.tools.javadoc.JavadocTool" : "jdk.javadoc.internal.tool.JavadocTool";
        JavaCompiler javadocTool = (JavaCompiler)ReflectUtil.method(JavadocTool_class, "instance", Context.class).invokeStatic(this.getContext());
        if (javadocTool != null && javadocTool.getClass().getSimpleName().equals("JavadocTool")) {
            Object manJavadocEnter = ReflectUtil.method("manifold.internal.javac.ManJavadocEnter_" + (JreUtil.isJava8() ? 8 : 9), "instance", Context.class).invokeStatic(this.getContext());
            ReflectUtil.field(javadocTool, "javadocEnter").set(manJavadocEnter);
        }
    }

    private void assignBootclasspath() {
        try {
            String[] args = (String[])ReflectUtil.field(this._javacTask, "args").get();
            boolean found = false;
            for (String arg : args) {
                if (arg != null && arg.equalsIgnoreCase("-bootclasspath")) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                this._bootclasspath = arg;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processArgs(JavacProcessingEnvironment jpe, String[] args) {
        this._argPresent = new HashMap<String, Boolean>();
        Arrays.stream(ARGS).forEach(arg -> this._argPresent.put((String)arg, this.testForArg((String)arg, args)));
        this.notifyOfInvalidArgs(args, jpe);
    }

    public JavacManifoldHost getHost() {
        return this._host;
    }

    private void notifyOfInvalidArgs(String[] args, JavacProcessingEnvironment jpe) {
        for (String arg : args) {
            if (!Arrays.stream(ARGS).noneMatch(validArg -> validArg.equals(arg))) continue;
            jpe.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unrecognized Manifold plugin argument '" + arg + "'");
        }
    }

    protected boolean testForArg(String name, String[] args) {
        boolean isPresent = this.isArgPresent(name, args);
        if (!isPresent) {
            try {
                String[] rawArgs = (String[])ReflectUtil.field(this._javacTask, "args").get();
                isPresent = Arrays.stream(rawArgs).anyMatch(arg -> arg.contains("-Xplugin:") && arg.contains("Manifold") && arg.contains(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isPresent;
    }

    private boolean isArgPresent(String name, String[] args) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (arg == null || !arg.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Context getContext() {
        return this._javacTask.getContext();
    }

    public JavaFileManager getJavaFileManager() {
        return this._fileManager;
    }

    public ManifoldJavaFileManager getManifoldFileManager() {
        return this._manFileManager;
    }

    public BasicJavacTask getJavacTask() {
        return this._javacTask;
    }

    public Set<Pair<String, JavaFileObject>> getJavaInputFiles() {
        return this._javaInputFiles;
    }

    public Map<String, String> getOtherSourceMappings() {
        return this._otherSourceMappings;
    }

    public List<String> getOtherInputFiles() {
        return this._otherInputFiles;
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.getContext());
    }

    public JavacElements getJavacElements() {
        return JavacElements.instance(this.getContext());
    }

    public TypeProcessor getTypeProcessor() {
        return this._typeProcessor;
    }

    public IssueReporter getIssueReporter() {
        return this._issueReporter;
    }

    public Set<String> getJavaSourcePath() {
        return this._javaSourcePath;
    }

    public String getBootclasspath() {
        return this._bootclasspath;
    }

    private void hijackJavacFileManager() {
        if (!(this._fileManager instanceof ManifoldJavaFileManager) && this._manFileManager == null) {
            this._ctx = this._javacTask.getContext();
            this._fileManager = this.getContext().get(JavaFileManager.class);
            this._javaInputFiles = new HashSet<Pair<String, JavaFileObject>>();
            this._manifoldSourcePath = this.fetchManifoldSource();
            this._otherInputFiles = this.fetchOtherInputFiles();
            this._otherSourceMappings = this.fetchManifoldSourceMappings();
            this._typeProcessor = new TypeProcessor(this.getHost(), this._javacTask);
            this._issueReporter = new IssueReporter(this._javacTask::getContext);
            this._seenModules = new HashMap<Context, Set<Symbol>>();
            this.injectManFileManager();
        }
    }

    private void tailorJavaCompiler(TaskEvent te) {
        CompilationUnitTree compilationUnit = te.getCompilationUnit();
        if (!(compilationUnit instanceof JCTree.JCCompilationUnit)) {
            return;
        }
        JavaCompiler compiler = JavaCompiler.instance(this.getContext());
        compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.max(compiler.shouldStopPolicyIfNoError, CompileStates.CompileState.FLOW);
        ReflectUtil.method("manifold.internal.javac.ManLog_" + (JreUtil.isJava8() ? 8 : 9), "instance", Context.class).invokeStatic(this.getContext());
        ManClassWriter.instance(this.getContext());
        ReflectUtil.method("manifold.internal.javac.ManCheck_" + (JreUtil.isJava11orLater() ? 11 : 8), "instance", Context.class).invokeStatic(this.getContext());
        if (!this.isExtensionsEnabled()) {
            return;
        }
        Attr manAttr = (Attr)ReflectUtil.method("manifold.internal.javac.ManAttr_" + (JreUtil.isJava8() ? 8 : 9), "instance", Context.class).invokeStatic(this.getContext());
        ManResolve.instance(this._ctx);
        ManTransTypes.instance(this._ctx);
        ManTypes.instance(this._ctx);
        ((Log)ReflectUtil.field(manAttr, "log").get()).setDiagnosticFormatter(RichDiagnosticFormatter.instance(this._ctx));
        if (!JreUtil.isJava8()) {
            Symbol module = (Symbol)ReflectUtil.field(compilationUnit, "modle").get();
            if (module == null) {
                return;
            }
            Set modules = this._seenModules.computeIfAbsent(this.getContext(), k -> new LinkedHashSet());
            if (modules.contains(module)) {
                return;
            }
            modules.add(module);
            NecessaryEvilUtil.openModule(this.getContext(), "jdk.compiler");
            if (JavacUtil.getSourceNumber() > 8) {
                ReflectUtil.method("manifold.internal.javac.ManClassFinder_9", "instance", Context.class).invokeStatic(this.getContext());
            }
        }
        this.notifyCompilerComponents();
    }

    private void notifyCompilerComponents() {
        for (ICompilerComponent cc : JavacPlugin.instance().getTypeProcessor().getCompilerComponents()) {
            cc.tailorCompiler();
        }
    }

    public boolean isExtensionsEnabled() {
        try {
            Class.forName("manifold.ext.rt.api.Extension");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void injectManFileManager() {
        this._fileManager = this.getContext().get(JavaFileManager.class);
        this._manFileManager = new ManifoldJavaFileManager(this.getHost(), this._fileManager, this.getContext(), true);
        this.getContext().put(JavaFileManager.class, (JavaFileManager)null);
        this.getContext().put(JavaFileManager.class, this._manFileManager);
        try {
            Object moduleFinder;
            Object modules;
            Object classFinder;
            if (JreUtil.isJava8()) {
                ReflectUtil.field(ClassReader.instance(this.getContext()), "fileManager").set(this._manFileManager);
            } else {
                classFinder = ReflectUtil.method(CLASSFINDER_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(classFinder, "fileManager").set(this._manFileManager);
                ReflectUtil.field(classFinder, "preferSource").set(true);
                modules = ReflectUtil.method(MODULES_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(modules, "fileManager").set(this._manFileManager);
                moduleFinder = ReflectUtil.method(MODULEFINDER_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(moduleFinder, "fileManager").set(this._manFileManager);
            }
            try {
                classFinder = ReflectUtil.method(CLASSFINDER_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(classFinder, "fileManager").set(this._manFileManager);
                modules = ReflectUtil.method(MODULES_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(modules, "fileManager").set(this._manFileManager);
                moduleFinder = ReflectUtil.method(MODULEFINDER_CLASS, "instance", Context.class).invokeStatic(this.getContext());
                ReflectUtil.field(moduleFinder, "fileManager").set(this._manFileManager);
            }
            catch (Throwable classFinder2) {
                // empty catch block
            }
            ReflectUtil.field(ClassWriter.instance(this.getContext()), "fileManager").set(this._manFileManager);
            ReflectUtil.field(Enter.instance(this.getContext()), "fileManager").set(this._manFileManager);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> deriveOutputPath() {
        HashSet<String> paths = new HashSet<String>();
        String outputPath = this.deriveClassOutputPath();
        String path = outputPath.replace(File.separatorChar, '/');
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith("/java/main")) {
            String javaPath = path.substring(0, path.lastIndexOf("/main"));
            File javaDir = new File(javaPath);
            for (File file : javaDir.listFiles()) {
                if (!file.isDirectory()) continue;
                paths.add(file.getAbsolutePath());
            }
            if ((path = path.substring(0, path.lastIndexOf("/java/main"))).endsWith("/classes")) {
                String resources = path.substring(0, path.lastIndexOf("/classes"));
                File resourcesDir = new File(resources = resources + "/resources/main");
                if (resourcesDir.isDirectory()) {
                    paths.add(resourcesDir.getAbsolutePath());
                }
            }
        }
        if (paths.isEmpty()) {
            paths.add(outputPath);
        }
        return new ArrayList<String>(paths);
    }

    private String deriveClassOutputPath() {
        try {
            String ping = "__dummy__";
            JavaFileObject classFile = this._javacTask.getContext().get(JavaFileManager.class).getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, ping, JavaFileObject.Kind.CLASS, null);
            if (!this.isPhysicalFile(classFile)) {
                return "";
            }
            File dummyFile = new File(classFile.toUri());
            String path = dummyFile.getAbsolutePath();
            path = path.substring(0, path.length() - (File.separatorChar + ping + ".class").length());
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> deriveClasspath() {
        if (JreUtil.isJava9Modular_compiler(this.getContext())) {
            ArrayList<String> pathsFromModules = new ArrayList<String>();
            Object modulesUtil = ReflectUtil.method("com.sun.tools.javac.comp.Modules", "instance", Context.class).invokeStatic(this.getContext());
            for (Symbol m : (Iterable)ReflectUtil.method(modulesUtil, "allModules", new Class[0]).invoke(new Object[0])) {
                Collection paths;
                Object classLocation = ReflectUtil.field(m, "classLocation").get();
                if (classLocation == null) continue;
                try {
                    paths = (Collection)ReflectUtil.method(classLocation, "getPaths", new Class[0]).invoke(new Object[0]);
                }
                catch (Exception e) {
                    continue;
                }
                for (Path p : paths) {
                    URI uri = p.toUri();
                    String scheme = uri.getScheme();
                    if (!scheme.equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("jar")) continue;
                    try {
                        pathsFromModules.add(new File(uri).getAbsolutePath());
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.println(iae.getMessage());
                    }
                }
            }
            return pathsFromModules;
        }
        ClassLoader cl = this._javacTask.getContext().get(JavaFileManager.class).getClassLoader(StandardLocation.CLASS_PATH);
        URL[] classpathUrls = this.getURLs(cl);
        List<String> paths = Arrays.stream(classpathUrls).map(url -> {
            try {
                return new File(url.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return this.removeBadPaths(paths);
    }

    private URL[] getURLs(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            return ((URLClassLoader)cl).getURLs();
        }
        ReflectUtil.LiveFieldRef myUrls = ReflectUtil.WithNull.field(cl, "myUrls");
        if (myUrls != null) {
            Iterable urls = (Iterable)myUrls.get();
            return (URL[])StreamSupport.stream(urls.spliterator(), false).toArray(URL[]::new);
        }
        throw new UnsupportedOperationException("Unhandled ClassLoader type: " + cl.getClass().getTypeName());
    }

    private List<String> removeBadPaths(List<String> paths) {
        ArrayList<String> actualPaths = new ArrayList<String>();
        block0: for (String path : paths) {
            for (String p : paths) {
                String unmodifiedPath = path;
                if (path.endsWith(File.separator + '.')) {
                    path = path.substring(0, path.length() - 2);
                }
                if (p.equals(unmodifiedPath) || !p.startsWith(path)) continue;
                continue block0;
            }
            actualPaths.add(path);
        }
        return actualPaths;
    }

    private Set<String> deriveSourcePath() {
        HashSet<String> sourcePath = new HashSet<String>();
        this.deriveSourcePath(this._javaInputFiles, sourcePath);
        this._javaSourcePath = new HashSet<String>(sourcePath);
        this.deriveAdditionalSourcePath(this._otherInputFiles, sourcePath);
        this.maybeAddResourcePath(this._javaInputFiles, sourcePath);
        sourcePath.addAll(this._manifoldSourcePath);
        return sourcePath;
    }

    private void deriveAdditionalSourcePath(List<String> inputFiles, Set<String> sourcePath) {
        block0: for (String inputFile : inputFiles) {
            for (String sp : sourcePath) {
                if (!inputFile.startsWith(sp + File.separatorChar)) continue;
                continue block0;
            }
            String pkg = this.extractPackageName(inputFile);
            if (pkg != null) {
                int iDot = inputFile.lastIndexOf(46);
                String ext = iDot > 0 ? inputFile.substring(iDot) : "";
                String fqn = pkg + '.' + new File(inputFile).getName();
                fqn = fqn.substring(0, fqn.length() - ext.length());
                String path = this.derivePath(fqn, inputFile);
                sourcePath.add(path);
                continue;
            }
            this.getIssueReporter().report(new JavacDiagnostic(null, Diagnostic.Kind.WARNING, 0L, 0L, 0L, IssueMsg.MSG_COULD_NOT_FIND_TYPE_FOR_FILE.get(inputFile)));
        }
    }

    private void maybeAddResourcePath(Set<Pair<String, JavaFileObject>> javaInputFiles, Set<String> sourcePath) {
        String resourcePath = null;
        for (String path : sourcePath) {
            int i = path.lastIndexOf("/".replace('/', File.separatorChar));
            if (i < 0) continue;
            resourcePath = path.substring(0, i) + "/resources".replace('/', File.separatorChar);
            break;
        }
        if (resourcePath != null && new File(resourcePath).isDirectory()) {
            sourcePath.add(resourcePath);
        }
        this.deriveResourcePath(javaInputFiles, sourcePath);
    }

    private void deriveSourcePath(Set<Pair<String, JavaFileObject>> inputFiles, Set<String> sourcePath) {
        block0: for (Pair<String, JavaFileObject> inputFile : inputFiles) {
            if (!this.isPhysicalFile(inputFile.getSecond())) continue;
            for (String sp : sourcePath) {
                if (!inputFile.getSecond().getName().startsWith(sp + File.separatorChar)) continue;
                continue block0;
            }
            String type = inputFile.getFirst();
            if (type != null) {
                String path = this.derivePath(type, inputFile.getSecond().getName());
                if (path == null) continue;
                sourcePath.add(path);
                continue;
            }
            this.getIssueReporter().report(new JavacDiagnostic(null, Diagnostic.Kind.WARNING, 0L, 0L, 0L, IssueMsg.MSG_COULD_NOT_FIND_TYPE_FOR_FILE.get(inputFile)));
        }
    }

    private void deriveResourcePath(Set<Pair<String, JavaFileObject>> inputFiles, Set<String> resourcePath) {
        for (Pair<String, JavaFileObject> inputFile : inputFiles) {
            File file;
            String filename;
            JavaFileObject fo = inputFile.getSecond();
            if (!this.isPhysicalFile(fo) || !(filename = fo.getName()).contains("_Manifold_Temp_Main_") || !(file = new File(filename)).isFile()) continue;
            this.addResourcePaths(file, resourcePath);
        }
    }

    private void addResourcePaths(File file, Set<String> resourcePath) {
        try {
            String content = StreamUtil.getContent(new FileReader(file));
            int index = content.indexOf(RESOURCE_ROOTS);
            if (index >= 0) {
                int iEol = content.indexOf(10, index);
                String paths = content.substring(index + RESOURCE_ROOTS.length(), iEol);
                paths = paths.trim();
                StringTokenizer tokenizer = new StringTokenizer(paths, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    if (!new File(path).isDirectory()) continue;
                    resourcePath.add(path);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isPhysicalFile(JavaFileObject inputFile) {
        URI uri = inputFile.toUri();
        return uri != null && uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("file");
    }

    private String derivePath(String type, String sourceFile) {
        int iDot = (sourceFile = new File(sourceFile).getAbsolutePath()).lastIndexOf(46);
        String ext = iDot > 0 ? sourceFile.substring(iDot) : "";
        String pathRelativeFile = type.replace('.', File.separatorChar) + ext;
        assert (sourceFile.endsWith(pathRelativeFile));
        int typeIndex = sourceFile.indexOf(pathRelativeFile);
        return typeIndex > 0 ? sourceFile.substring(0, typeIndex - 1) : null;
    }

    private List<String> fetchManifoldSource() {
        Map<String, String> options = JavacProcessingEnvironment.instance(this.getContext()).getOptions();
        String manifoldSourceProperty = this.getManifoldSourceProperty(options);
        List<String> dirs = Collections.emptyList();
        if (manifoldSourceProperty != null && !manifoldSourceProperty.isEmpty()) {
            dirs = Arrays.asList(manifoldSourceProperty.split(" "));
        }
        return dirs;
    }

    private List<String> fetchOtherInputFiles() {
        Map<String, String> options = JavacProcessingEnvironment.instance(this.getContext()).getOptions();
        String otherSourceFiles = this.getOtherSourceFilesProperty(options);
        String otherSourceList = this.getOtherSourceListProperty(options);
        if (otherSourceFiles != null && otherSourceList != null) {
            throw new IllegalArgumentException(String.format("Properties %s and %s may not be set simultaneously; please choose one or the other.", OTHER_SOURCE_FILES, OTHER_SOURCE_LIST));
        }
        List<String> files = Collections.emptyList();
        if (otherSourceFiles != null && !otherSourceFiles.isEmpty()) {
            files = Arrays.asList(otherSourceFiles.split(" "));
        } else if (otherSourceList != null && !otherSourceList.isEmpty()) {
            try {
                files = Files.readAllLines(new File(otherSourceList).toPath()).stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Unable to read source list from %s", otherSourceList), e);
            }
        }
        return files;
    }

    private Map<String, String> fetchManifoldSourceMappings() {
        HashMap<String, String> sourceMappings = new HashMap<String, String>();
        Map<String, String> options = JavacProcessingEnvironment.instance(this.getContext()).getOptions();
        for (Map.Entry<String, String> option : options.entrySet()) {
            String key = option.getKey();
            if (!key.startsWith(MANIFOLD_SOURCE_MAPPING)) continue;
            String fqnOrExt = key.substring(MANIFOLD_SOURCE_MAPPING.length());
            sourceMappings.put(fqnOrExt, option.getValue());
        }
        return sourceMappings;
    }

    private String getManifoldSourceProperty(Map<String, String> options) {
        String manifoldSourceFiles = options.get(MANIFOLD_SOURCE);
        if (manifoldSourceFiles == null) {
            manifoldSourceFiles = System.getProperty(MANIFOLD_SOURCE);
        }
        return manifoldSourceFiles;
    }

    private String getOtherSourceFilesProperty(Map<String, String> options) {
        String otherSourceFiles = options.get(OTHER_SOURCE_FILES);
        if (otherSourceFiles == null) {
            otherSourceFiles = System.getProperty(OTHER_SOURCE_FILES);
        }
        return otherSourceFiles;
    }

    private String getOtherSourceListProperty(Map<String, String> options) {
        String otherSourceList = options.get(OTHER_SOURCE_LIST);
        if (otherSourceList == null) {
            otherSourceList = System.getProperty(OTHER_SOURCE_LIST);
        }
        return otherSourceList;
    }

    public void initialize(TaskEvent e) {
        if (!this._initialized) {
            this._initialized = true;
            NecessaryEvilUtil.bypassJava9Security();
            this.getHost().initialize(this.deriveSourcePath(), this.deriveClasspath(), this.deriveOutputPath());
            Bootstrap.init();
            this.tailorJavaCompiler(e);
        } else if (this._javacTask.getContext() != this._ctx) {
            this._ctx = this._javacTask.getContext();
            this.tailorJavaCompiler(e);
            this.injectManFileManager();
        }
    }

    @Override
    public void started(TaskEvent e) {
        switch (e.getKind()) {
            case PARSE: {
                ManParserFactory parserFactory = ManParserFactory.instance(this._javacTask.getContext());
                parserFactory.setTaskEvent(e);
                ReflectUtil.field(JavaCompiler.instance(this._javacTask.getContext()), "parserFactory").set(parserFactory);
                break;
            }
            case ENTER: {
                this.initialize(e);
                this.addFileFragments(e);
                break;
            }
            case ANALYZE: {
                this.initialize(e);
                this.extendArrayType(e);
            }
        }
    }

    public void extendArrayType(TaskEvent e) {
        try {
            ArrayTypeExtender.extend(this.getContext(), e.getCompilationUnit());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void finished(TaskEvent e) {
        switch (e.getKind()) {
            case PARSE: {
                this.addInputFile(e);
                this.processParse(e);
                break;
            }
            case ENTER: {
                this.process(e);
            }
        }
    }

    private void addInputFile(TaskEvent e) {
        if (!this._initialized) {
            CompilationUnitTree compilationUnit = e.getCompilationUnit();
            ExpressionTree pkg = compilationUnit.getPackageName();
            String packageQualifier = pkg == null ? "" : pkg.toString() + '.';
            for (Tree tree : compilationUnit.getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                this._javaInputFiles.add(new Pair<String, JavaFileObject>(packageQualifier + ((JCTree.JCClassDecl)tree).getSimpleName(), compilationUnit.getSourceFile()));
            }
        }
    }

    private String extractPackageName(String file) {
        try {
            int iEol;
            String source = StreamUtil.getContent(new FileReader(file));
            int iPkg = source.indexOf("package");
            if (iPkg >= 0 && (iEol = source.indexOf(10, iPkg)) > iPkg) {
                String pkg = source.substring(iPkg + "package".length(), iEol).trim();
                StringTokenizer tokenizer = new StringTokenizer(pkg, ".");
                while (tokenizer.hasMoreTokens()) {
                    String part = tokenizer.nextToken();
                    if (ManClassUtil.isJavaIdentifier(part)) continue;
                    return null;
                }
                return pkg;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void process(TaskEvent e) {
        HashSet<String> typesToProcess = new HashSet<String>();
        ExpressionTree pkg = e.getCompilationUnit().getPackageName();
        String packageQualifier = pkg == null ? "" : pkg.toString() + '.';
        for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            typesToProcess.add(packageQualifier + ((JCTree.JCClassDecl)tree).getSimpleName());
            this.insertBootstrap((JCTree.JCClassDecl)tree);
        }
        this._typeProcessor.addTypesToProcess(typesToProcess);
    }

    private void processParse(TaskEvent e) {
        for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
            if (!(tree instanceof JCTree.JCClassDecl)) continue;
            ((JCTree.JCClassDecl)tree).accept(new ParseProcessor(this));
        }
    }

    private void insertBootstrap(JCTree.JCClassDecl tree) {
        TreeTranslator visitor = (TreeTranslator)ReflectUtil.constructor("manifold.internal.javac.BootstrapInserter", JavacPlugin.class).newInstance(this);
        tree.accept(visitor);
    }

    public boolean isStaticCompile() {
        return this._argPresent.get(ARG_DYNAMIC) == false;
    }

    public boolean isNoBootstrapping() {
        return this._argPresent.get(ARG_NO_BOOTSTRAP);
    }

    public void registerType(JavaFileObject sourceFile, int offset, String name, String ext, HostKind hostKind, String content) {
        this._fileFragmentResources.add(new FileFragmentResource(sourceFile, offset, name, ext, hostKind, content));
    }

    private void addFileFragments(TaskEvent e) {
        Iterator<FileFragmentResource> iterator = this._fileFragmentResources.iterator();
        while (iterator.hasNext()) {
            FileFragmentResource fragment = iterator.next();
            if (!fragment.embed(e)) continue;
            iterator.remove();
        }
    }

    public boolean isIncremental() {
        return this._isIncremental || String.valueOf(true).equals(System.getProperty("manifold.compiler.incremental"));
    }

    public void setIncremental() {
        this._isIncremental = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadJavacParserClass() {
        ClassLoader classLoader = JavacParser.class.getClassLoader();
        Object object = ReflectUtil.method(classLoader, "getClassLoadingLock", String.class).invoke("com.sun.tools.javac.parser.ManJavacParser");
        synchronized (object) {
            if (null == ReflectUtil.method(classLoader, "findLoadedClass", String.class).invoke("com.sun.tools.javac.parser.ManJavacParser")) {
                InputStream is1 = JavacPlugin.class.getClassLoader().getResourceAsStream("manifold/internal/javac/ManJavacParser.clazz");
                try {
                    byte[] content = StreamUtil.getContent(is1);
                    ReflectUtil.method(classLoader, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).invoke("com.sun.tools.javac.parser.ManJavacParser", content, 0, content.length);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static {
        try {
            NecessaryEvilUtil.bypassJava9Security();
            CLASSFINDER_CLASS = Class.forName("com.sun.tools.javac.code.ClassFinder", false, ClassReader.class.getClassLoader());
            MODULES_CLASS = Class.forName("com.sun.tools.javac.comp.Modules", false, ClassReader.class.getClassLoader());
            MODULEFINDER_CLASS = Class.forName("com.sun.tools.javac.code.ModuleFinder", false, ClassReader.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JavacPlugin.loadJavacParserClass();
    }

    private class FileFragmentResource {
        private final JavaFileObject _sourceFile;
        private final int _offset;
        private final String _name;
        private final String _ext;
        private final HostKind _hostKind;
        private final String _content;

        private FileFragmentResource(JavaFileObject sourceFile, int offset, String name, String ext, HostKind hostKind, String content) {
            this._sourceFile = sourceFile;
            this._offset = offset;
            this._name = name;
            this._ext = ext;
            this._hostKind = hostKind;
            this._content = content;
        }

        private boolean embed(TaskEvent e) {
            IFile file;
            JavaFileObject sourceFile = e.getSourceFile();
            if (!sourceFile.equals(this._sourceFile)) {
                return false;
            }
            try {
                file = JavacPlugin.this.getHost().getFileSystem().getIFile(sourceFile.toUri().toURL());
            }
            catch (Exception ex) {
                return false;
            }
            ExpressionTree pkg = e.getCompilationUnit().getPackageName();
            if (pkg == null) {
                return false;
            }
            FileFragmentImpl fragment = new FileFragmentImpl(this._name, this._ext, this._hostKind, file, this._offset, this._content.length(), this._content);
            JavacManifoldHost host = JavacPlugin.instance().getHost();
            Set<ITypeManifold> tms = host.getSingleModule().findTypeManifoldsFor(fragment, t -> t.getContributorKind() != ContributorKind.Supplemental);
            ITypeManifold tm = tms.stream().findFirst().orElse(null);
            if (tm == null) {
                return true;
            }
            host.getSingleModule().getPathCache();
            String fqn = PathCache.qualifyName(pkg.toString(), this._name);
            host.createdType(fragment, new String[]{fqn});
            return true;
        }
    }
}

