/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.api.range;

import manifold.collections.api.range.Range;

public abstract class AbstractRange<E extends Comparable<E>, ME extends AbstractRange<E, ME>>
implements Range<E, ME> {
    private final E _left;
    private final E _right;
    private final boolean _leftClosed;
    private final boolean _rightClosed;
    private final boolean _reversed;

    public AbstractRange(E left, E right) {
        this(left, right, true, true, false);
    }

    public AbstractRange(E left, E right, boolean leftClosed, boolean rightClosed, boolean reverse) {
        this.checkArgs(left, right);
        this._reversed = reverse;
        if (reverse) {
            this._left = right;
            this._right = left;
            this._leftClosed = rightClosed;
            this._rightClosed = leftClosed;
        } else {
            this._left = left;
            this._right = right;
            this._leftClosed = leftClosed;
            this._rightClosed = rightClosed;
        }
        if (this._left.compareTo(this._right) > 0) {
            throw new IllegalArgumentException("The logical left endpoint is greater than the logical right endpoint: [" + left + ", " + right + "]");
        }
    }

    private void checkArgs(E left, E right) {
        if (left == null) {
            throw new IllegalArgumentException("Non-null value expected for left endpoint.");
        }
        if (right == null) {
            throw new IllegalArgumentException("Non-null value expected for right endpoint.");
        }
    }

    @Override
    public E getLeftEndpoint() {
        return this._left;
    }

    @Override
    public E getRightEndpoint() {
        return this._right;
    }

    @Override
    public boolean isLeftClosed() {
        return this._leftClosed;
    }

    @Override
    public boolean isRightClosed() {
        return this._rightClosed;
    }

    @Override
    public boolean contains(E e) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(e) <= 0 : this.getLeftEndpoint().compareTo(e) < 0) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(e) >= 0 : this.getRightEndpoint().compareTo(e) > 0);
    }

    @Override
    public boolean contains(ME range) {
        return (this.isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractRange)range).getLeftEndpoint()) <= 0 : (((AbstractRange)range).isLeftClosed() ? this.getLeftEndpoint().compareTo(((AbstractRange)range).getLeftEndpoint()) < 0 : this.getLeftEndpoint().compareTo(((AbstractRange)range).getLeftEndpoint()) <= 0)) && (this.isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractRange)range).getRightEndpoint()) >= 0 : (((AbstractRange)range).isRightClosed() ? this.getRightEndpoint().compareTo(((AbstractRange)range).getRightEndpoint()) > 0 : this.getRightEndpoint().compareTo(((AbstractRange)range).getRightEndpoint()) >= 0));
    }

    @Override
    public boolean isReversed() {
        return this._reversed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRange)) {
            return false;
        }
        AbstractRange that = (AbstractRange)o;
        if (this.isLeftClosed() != that.isLeftClosed()) {
            return false;
        }
        if (this.isReversed() != that.isReversed()) {
            return false;
        }
        if (this.isRightClosed() != that.isRightClosed()) {
            return false;
        }
        if (!this.getLeftEndpoint().equals(that.getLeftEndpoint())) {
            return false;
        }
        return this.getRightEndpoint().equals(that.getRightEndpoint());
    }

    public int hashCode() {
        int result = this.getLeftEndpoint().hashCode();
        result = 31 * result + this.getRightEndpoint().hashCode();
        result = 31 * result + (this.isLeftClosed() ? 1 : 0);
        result = 31 * result + (this.isRightClosed() ? 1 : 0);
        result = 31 * result + (this.isReversed() ? 1 : 0);
        return result;
    }

    public String toString() {
        if (this.isReversed()) {
            return this.getRightEndpoint() + (this.isRightClosed() ? "" : "|") + ".." + (this.isLeftClosed() ? "" : "|") + this.getLeftEndpoint();
        }
        return this.getLeftEndpoint() + (this.isLeftClosed() ? "" : "|") + ".." + (this.isRightClosed() ? "" : "|") + this.getRightEndpoint();
    }
}

