/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcRawExpression;
import manifold.api.gen.SrcType;

public class SrcField
extends SrcAnnotated<SrcField> {
    private SrcType _type;
    private SrcExpression _initializer;
    private boolean _enumConst;

    public SrcField(String name, Class type) {
        this.name(name);
        this.type(type);
    }

    public SrcField(String name, String type) {
        this.name(name);
        this.type(type);
    }

    public SrcField(String name, SrcType type) {
        this.name(name);
        this.type(type);
    }

    public SrcField(AbstractSrcClass srcClass) {
        super(srcClass);
    }

    public SrcField type(SrcType type) {
        this._type = type;
        return this;
    }

    public SrcField type(Class type) {
        this._type = new SrcType(type);
        return this;
    }

    public SrcField type(String type) {
        this._type = new SrcType(type);
        return this;
    }

    public SrcField initializer(SrcExpression expr) {
        this._initializer = expr;
        return this;
    }

    public SrcField initializer(String expr) {
        this._initializer = new SrcRawExpression(expr);
        return this;
    }

    public boolean isEnumConst() {
        return this._enumConst;
    }

    public SrcField enumConst() {
        this._enumConst = true;
        return this;
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        if (this.isEnumConst()) {
            sb.append(this.getSimpleName()).append(",\n");
        } else {
            this.renderModifiers(sb, false, 0);
            this._type.render(sb, 0).append(' ').append(this.getSimpleName());
            if (this._initializer != null) {
                sb.append(" = ");
                this._initializer.render(sb, 0).append(";\n");
            } else {
                sb.append(";\n");
            }
        }
        return sb;
    }
}

