/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import java.util.function.Supplier;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.ResourcePath;
import manifold.internal.javac.HostKind;

public class FileFragmentImpl
implements IFileFragment {
    private final String _name;
    private final String _ext;
    private final HostKind _hostKind;
    private final IFile _enclosingFile;
    private int _offset;
    private Supplier<Integer> _offsetSupplier;
    private final int _length;
    private final String _content;
    private Object _container;

    public FileFragmentImpl(String name, String ext, HostKind hostKind, IFile enclosingFile, int offset, int length, String content) {
        this._name = name;
        this._ext = ext.toLowerCase();
        this._hostKind = hostKind;
        this._enclosingFile = enclosingFile;
        this._offset = offset;
        this._length = length;
        this._content = content;
    }

    public String getContent() {
        return this._content;
    }

    @Override
    public Object getContainer() {
        return this._container;
    }

    @Override
    public void setContainer(Object container) {
        this._container = container;
    }

    @Override
    public HostKind getHostKind() {
        return this._hostKind;
    }

    @Override
    public IFile getEnclosingFile() {
        return this._enclosingFile;
    }

    @Override
    public int getOffset() {
        return this._offsetSupplier != null ? this._offsetSupplier.get() : this._offset;
    }

    @Override
    public void setOffset(Supplier<Integer> offset) {
        this._offsetSupplier = offset;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getContent().getBytes());
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStreamForAppend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getExtension() {
        return this._ext;
    }

    @Override
    public String getBaseName() {
        return this._name;
    }

    @Override
    public IFileSystem getFileSystem() {
        return this.getEnclosingFile().getFileSystem();
    }

    @Override
    public IDirectory getParent() {
        return this._enclosingFile.getParent();
    }

    @Override
    public String getName() {
        return this.getBaseName() + '.' + this.getExtension();
    }

    @Override
    public boolean exists() {
        return this.getEnclosingFile().exists();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toURI() {
        return this.getEnclosingFile().toURI();
    }

    @Override
    public ResourcePath getPath() {
        return ResourcePath.parse(this.getParent().getPath().getPathString() + File.separatorChar + this.getName());
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return this.getEnclosingFile().isChildOf(dir);
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return this.getEnclosingFile().isDescendantOf(dir);
    }

    @Override
    public File toJavaFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isJavaFile() {
        return false;
    }

    @Override
    public boolean isInJar() {
        return this.getEnclosingFile().isInJar();
    }

    @Override
    public boolean create() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFragmentImpl that = (FileFragmentImpl)o;
        return Objects.equals(this._name, that._name) && Objects.equals(this._ext, that._ext) && Objects.equals(this._enclosingFile, that._enclosingFile);
    }

    public int hashCode() {
        return Objects.hash(this._name, this._ext, this._enclosingFile);
    }
}

