/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.Scalars;
import graphql.TrivialDataFetcher;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@PublicApi
public class PropertyDataFetcher<T>
implements DataFetcher<T>,
TrivialDataFetcher<T> {
    private final String propertyName;
    private final Function<Object, Object> function;
    private static final AtomicBoolean USE_SET_ACCESSIBLE = new AtomicBoolean(true);
    private static final ConcurrentMap<String, Method> METHOD_CACHE = new ConcurrentHashMap<String, Method>();
    private static final ConcurrentMap<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();

    public PropertyDataFetcher(String propertyName) {
        this.propertyName = Assert.assertNotNull(propertyName);
        this.function = null;
    }

    private <O> PropertyDataFetcher(Function<O, T> function) {
        this.function = Assert.assertNotNull(function);
        this.propertyName = null;
    }

    public static <T> PropertyDataFetcher<T> fetching(String propertyName) {
        return new PropertyDataFetcher<T>(propertyName);
    }

    public static <T, O> PropertyDataFetcher<T> fetching(Function<O, T> function) {
        return new PropertyDataFetcher<T>(function);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public T get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (this.function != null) {
            return (T)this.function.apply(source);
        }
        if (source instanceof Map) {
            return (T)((Map)source).get(this.propertyName);
        }
        return (T)this.getPropertyViaGetter(source, environment.getFieldType(), environment);
    }

    private Object getPropertyViaGetter(Object object, GraphQLOutputType outputType, DataFetchingEnvironment environment) {
        try {
            return this.getPropertyViaGetterMethod(object, outputType, this::findPubliclyAccessibleMethod, environment);
        }
        catch (NoSuchMethodException ignored) {
            try {
                return this.getPropertyViaGetterMethod(object, outputType, this::findViaSetAccessible, environment);
            }
            catch (NoSuchMethodException ignored2) {
                return this.getPropertyViaFieldAccess(object);
            }
        }
    }

    private Object getPropertyViaGetterMethod(Object object, GraphQLOutputType outputType, MethodFinder methodFinder, DataFetchingEnvironment environment) throws NoSuchMethodException {
        if (this.isBooleanProperty(outputType)) {
            try {
                return this.getPropertyViaGetterUsingPrefix(object, "is", methodFinder, environment);
            }
            catch (NoSuchMethodException e) {
                return this.getPropertyViaGetterUsingPrefix(object, "get", methodFinder, environment);
            }
        }
        return this.getPropertyViaGetterUsingPrefix(object, "get", methodFinder, environment);
    }

    private Object getPropertyViaGetterUsingPrefix(Object object, String prefix, MethodFinder methodFinder, DataFetchingEnvironment environment) throws NoSuchMethodException {
        String getterName = prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        try {
            Method method = methodFinder.apply(object.getClass(), getterName);
            if (this.takesDataFetcherEnvironmentAsOnlyArgument(method)) {
                return method.invoke(object, environment);
            }
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new GraphQLException(e);
        }
    }

    private boolean isBooleanProperty(GraphQLOutputType outputType) {
        if (outputType == Scalars.GraphQLBoolean) {
            return true;
        }
        if (GraphQLTypeUtil.isNonNull(outputType)) {
            return GraphQLTypeUtil.unwrapOne(outputType) == Scalars.GraphQLBoolean;
        }
        return false;
    }

    public static void clearReflectionCache() {
        METHOD_CACHE.clear();
        FIELD_CACHE.clear();
    }

    public static boolean setUseSetAccessible(boolean flag) {
        return USE_SET_ACCESSIBLE.getAndSet(flag);
    }

    private String mkKey(Class clazz, String propertyName) {
        return clazz.getName() + "__" + propertyName;
    }

    private Method findPubliclyAccessibleMethod(Class root, String methodName) throws NoSuchMethodException {
        for (Class currentClass = root; currentClass != null; currentClass = currentClass.getSuperclass()) {
            String key = this.mkKey(currentClass, this.propertyName);
            Method method = (Method)METHOD_CACHE.get(key);
            if (method != null) {
                return method;
            }
            if (!Modifier.isPublic(currentClass.getModifiers())) continue;
            try {
                method = currentClass.getMethod(methodName, DataFetchingEnvironment.class);
                if (Modifier.isPublic(method.getModifiers())) {
                    METHOD_CACHE.putIfAbsent(key, method);
                    return method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            method = currentClass.getMethod(methodName, new Class[0]);
            if (!Modifier.isPublic(method.getModifiers())) continue;
            METHOD_CACHE.putIfAbsent(key, method);
            return method;
        }
        return root.getMethod(methodName, new Class[0]);
    }

    private Method findViaSetAccessible(Class aClass, String methodName) throws NoSuchMethodException {
        if (!USE_SET_ACCESSIBLE.get()) {
            throw new FastNoSuchMethodException(methodName);
        }
        String key = this.mkKey(aClass, this.propertyName);
        Method method = (Method)METHOD_CACHE.get(key);
        if (method != null) {
            return method;
        }
        Method[] declaredMethods = aClass.getDeclaredMethods();
        Optional<Method> m = Arrays.stream(declaredMethods).filter(mth -> methodName.equals(mth.getName())).filter(mth -> this.hasZeroArgs((Method)mth) || this.takesDataFetcherEnvironmentAsOnlyArgument((Method)mth)).sorted(this.mostMethodArgsFirst()).findFirst();
        if (m.isPresent()) {
            try {
                method = m.get();
                method.setAccessible(true);
                METHOD_CACHE.putIfAbsent(key, method);
                return method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        throw new FastNoSuchMethodException(methodName);
    }

    private boolean hasZeroArgs(Method mth) {
        return mth.getParameterCount() == 0;
    }

    private boolean takesDataFetcherEnvironmentAsOnlyArgument(Method mth) {
        return mth.getParameterCount() == 1 && mth.getParameterTypes()[0].equals(DataFetchingEnvironment.class);
    }

    private Comparator<? super Method> mostMethodArgsFirst() {
        return Comparator.comparingInt(Method::getParameterCount).reversed();
    }

    private Object getPropertyViaFieldAccess(Object object) {
        Class<?> aClass = object.getClass();
        String key = this.mkKey(aClass, this.propertyName);
        try {
            Field field = (Field)FIELD_CACHE.get(key);
            if (field == null) {
                field = aClass.getField(this.propertyName);
                FIELD_CACHE.putIfAbsent(key, field);
            }
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            if (!USE_SET_ACCESSIBLE.get()) {
                return null;
            }
            try {
                Field field = aClass.getDeclaredField(this.propertyName);
                field.setAccessible(true);
                FIELD_CACHE.putIfAbsent(key, field);
                return field.get(object);
            }
            catch (NoSuchFieldException | SecurityException ignored2) {
                return null;
            }
            catch (IllegalAccessException e1) {
                throw new GraphQLException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new GraphQLException(e);
        }
    }

    private static class FastNoSuchMethodException
    extends NoSuchMethodException {
        public FastNoSuchMethodException(String methodName) {
            super(methodName);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    @FunctionalInterface
    private static interface MethodFinder {
        public Method apply(Class var1, String var2) throws NoSuchMethodException;
    }
}

