/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader;

import java.util.Collections;
import java.util.Map;
import manifold.shade.org.dataloader.impl.Assertions;

public class BatchLoaderEnvironment {
    private final Object context;
    private final Map<Object, Object> keyContexts;

    private BatchLoaderEnvironment(Object context, Map<Object, Object> keyContexts) {
        this.context = context;
        this.keyContexts = keyContexts;
    }

    public <T> T getContext() {
        return (T)this.context;
    }

    public Map<Object, Object> getKeyContexts() {
        return this.keyContexts;
    }

    public static Builder newBatchLoaderEnvironment() {
        return new Builder();
    }

    public static class Builder {
        private Object context;
        private Map<Object, Object> keyContexts = Collections.emptyMap();

        private Builder() {
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public Builder keyContexts(Map<Object, Object> keyContexts) {
            this.keyContexts = Assertions.nonNull(keyContexts);
            return this;
        }

        public BatchLoaderEnvironment build() {
            return new BatchLoaderEnvironment(this.context, this.keyContexts);
        }
    }
}

