/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import manifold.api.fs.IResource;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModule;
import manifold.api.host.ITypeSystemListener;
import manifold.api.host.RefreshRequest;
import manifold.api.util.SourcePathUtil;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.internal.javac.SrcClassUtil;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.Stack;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class ClassSymbols {
    private static final Map<IModule, ClassSymbols> INSTANCES = new ConcurrentHashMap<IModule, ClassSymbols>();
    private final IModule _module;
    private LocklessLazyVar<BasicJavacTask> _altJavacTask_PlainFileMgr;
    private LocklessLazyVar<BasicJavacTask> _altJavacTask_ManFileMgr;
    private JavacTool _javacTool;
    private volatile StandardJavaFileManager _fm;
    private JavaFileManager _wfm;

    public static ClassSymbols instance(IModule module) {
        ClassSymbols classSymbols = INSTANCES.get(module);
        if (classSymbols == null) {
            classSymbols = new ClassSymbols(module);
            INSTANCES.put(module, classSymbols);
        }
        return classSymbols;
    }

    private ClassSymbols(IModule module) {
        this._module = module;
        this._module.getHost().addTypeSystemListenerAsWeakRef(module, new CacheClearer());
        this._altJavacTask_PlainFileMgr = LocklessLazyVar.make(() -> {
            this.init();
            StringWriter errors = new StringWriter();
            BasicJavacTask task = (BasicJavacTask)this._javacTool.getTask((Writer)errors, (JavaFileManager)this._fm, (DiagnosticListener)null, this.makeJavacArgs(), (Iterable)null, (Iterable)null);
            if (errors.getBuffer().length() > 0) {
                System.err.println(errors.getBuffer());
            }
            return task;
        });
        this._altJavacTask_ManFileMgr = LocklessLazyVar.make(() -> {
            this.init();
            if (this._wfm == null) {
                this._wfm = new ManifoldJavaFileManager(this._module.getHost(), this._fm, null, false);
            }
            StringWriter errors = new StringWriter();
            BasicJavacTask task = (BasicJavacTask)this._javacTool.getTask((Writer)errors, this._wfm, (DiagnosticListener)null, this.makeJavacArgs(), (Iterable)null, (Iterable)null);
            if (this._wfm instanceof ManifoldJavaFileManager) {
                if (JreUtil.isJava9orLater()) {
                    Stack<Object> stack = new Stack<Object>();
                    stack.push(ReflectUtil.field(Symtab.instance(task.getContext()), "noModule").get());
                    task.getContext().put(ManifoldJavaFileManager.MODULE_CTX, stack);
                }
                ((ManifoldJavaFileManager)this._wfm).setContext(task.getContext());
            }
            if (errors.getBuffer().length() > 0) {
                System.err.println(errors.getBuffer());
            }
            return task;
        });
    }

    private List<String> makeJavacArgs() {
        return new ArrayList<String>(){
            {
                String release;
                this.add("-proc:none");
                this.add("-Xprefer:source");
                JavacPlugin javacPlugin = JavacPlugin.instance();
                String string = release = javacPlugin == null ? null : Options.instance(javacPlugin.getContext()).get("--release");
                if ("8".equals(release)) {
                    this.add("--release");
                    this.add("8");
                } else {
                    this.add("-source");
                    this.add("1.8");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this._fm != null) {
            return;
        }
        ClassSymbols classSymbols = this;
        synchronized (classSymbols) {
            if (this._fm != null) {
                return;
            }
            this._javacTool = JavacTool.create();
            StandardJavaFileManager fm = this._javacTool.getStandardFileManager((DiagnosticListener)null, (Locale)null, StandardCharsets.UTF_8);
            try {
                fm.setLocation(StandardLocation.SOURCE_PATH, this._module.getCollectiveSourcePath().stream().map(IResource::toJavaFile).filter(f -> !SourcePathUtil.excludeFromTestPath(f.getAbsolutePath())).collect(Collectors.toList()));
                fm.setLocation(StandardLocation.CLASS_PATH, this._module.getCollectiveJavaClassPath().stream().map(IResource::toJavaFile).filter(f -> !SourcePathUtil.excludeFromTestPath(f.getAbsolutePath())).collect(Collectors.toList()));
                if (JreUtil.isJava8()) {
                    fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.extendBootclasspath(fm.getLocation(StandardLocation.PLATFORM_CLASS_PATH)));
                }
                this._fm = fm;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Iterable<? extends File> extendBootclasspath(Iterable<? extends File> existing) {
        if (JavacPlugin.instance() == null) {
            return existing;
        }
        String bootclasspath = JavacPlugin.instance().getBootclasspath();
        if (bootclasspath == null || bootclasspath.isEmpty()) {
            return existing;
        }
        ArrayList<File> bootcp = new ArrayList<File>();
        existing.forEach(f -> bootcp.add((File)f));
        String[] split = bootclasspath.split(";");
        for (int i = 0; i < split.length; ++i) {
            bootcp.add(i, new File(split[i]));
        }
        return bootcp;
    }

    public BasicJavacTask getJavacTask_PlainFileMgr() {
        return this._altJavacTask_PlainFileMgr.get();
    }

    public BasicJavacTask getJavacTask_ManFileMgr() {
        return this._altJavacTask_ManFileMgr.get();
    }

    public Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(BasicJavacTask javacTask, String fqn) {
        return this.getClassSymbol(javacTask, (TypeProcessor)null, fqn);
    }

    public Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(BasicJavacTask javacTask, JavaFileManager.Location location, String fqn) {
        return this.getClassSymbol(javacTask.getContext(), (Object)location, fqn);
    }

    public Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(BasicJavacTask javacTask, Object moduleSymbol, String fqn) {
        return this.getClassSymbol(javacTask.getContext(), moduleSymbol, fqn);
    }

    public Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(BasicJavacTask javacTask, TypeProcessor tp, String fqn) {
        Context ctx = tp == null ? javacTask.getContext() : tp.getContext();
        JCTree.JCCompilationUnit cu = tp == null ? null : (JCTree.JCCompilationUnit)tp.getCompilationUnit();
        return this.getClassSymbol(ctx, (Object)cu, fqn);
    }

    private Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbol(Context ctx, Object moduleCtx, String fqn) {
        Symbol.ClassSymbol typeElement = IDynamicJdk.instance().getTypeElement(ctx, moduleCtx, fqn);
        if (typeElement == null) {
            return this.getClassSymbolForProducedClass(fqn, new BasicJavacTask[1]);
        }
        JavacTrees trees = JavacTrees.instance(ctx);
        TreePath path = trees.getPath(typeElement);
        if (path != null) {
            return new Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit>(typeElement, (JCTree.JCCompilationUnit)path.getCompilationUnit());
        }
        return new Pair<Symbol.ClassSymbol, Object>(typeElement, null);
    }

    public SrcClass makeSrcClassStub(String fqn) {
        return this.makeSrcClassStub(fqn, null, null);
    }

    public SrcClass makeSrcClassStub(String fqn, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        BasicJavacTask javacTask = this.getJavacTask_PlainFileMgr();
        Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> pair = this.getClassSymbol(javacTask, (JavaFileManager.Location)null, fqn);
        if (pair == null) {
            return null;
        }
        Symbol.ClassSymbol classSymbol = pair.getFirst();
        if (classSymbol == null) {
            return this.makeSrcClassStubFromProducedClass(fqn, location, errorHandler);
        }
        return SrcClassUtil.instance().makeStub(fqn, classSymbol, pair.getSecond(), this.getJavacTask_PlainFileMgr(), this._module, location, errorHandler);
    }

    private SrcClass makeSrcClassStubFromProducedClass(String fqn, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        BasicJavacTask[] task = new BasicJavacTask[1];
        Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> pair = this.getClassSymbolForProducedClass(fqn, task);
        if (pair == null) {
            throw new NullPointerException("Could not find ClassSymbol for: " + fqn);
        }
        Symbol.ClassSymbol classSymbol = pair.getFirst();
        return SrcClassUtil.instance().makeStub(fqn, classSymbol, pair.getSecond(), task[0], this._module, location, errorHandler);
    }

    private Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> getClassSymbolForProducedClass(String fqn, BasicJavacTask[] task) {
        StringWriter errors = new StringWriter();
        task[0] = this.getJavacTask_ManFileMgr();
        Symbol.ClassSymbol e = IDynamicJdk.instance().getTypeElement(task[0].getContext(), null, fqn);
        if (e != null && e.getSimpleName().contentEquals(ManClassUtil.getShortClassName(fqn))) {
            JavacTrees trees = JavacTrees.instance(task[0].getContext());
            TreePath path = trees.getPath(e);
            if (path != null) {
                return new Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit>(e, (JCTree.JCCompilationUnit)path.getCompilationUnit());
            }
            return new Pair<Symbol.ClassSymbol, Object>(e, null);
        }
        StringBuffer errorText = errors.getBuffer();
        if (errorText.length() > 0) {
            throw new RuntimeException("Compile errors:\n" + errorText);
        }
        return null;
    }

    private class CacheClearer
    implements ITypeSystemListener {
        private CacheClearer() {
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
        }

        @Override
        public void refreshed() {
            INSTANCES.remove(ClassSymbols.this._module);
        }
    }
}

