/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.language.Document;
import graphql.parser.ExtendedBailStrategy;
import graphql.parser.GraphqlAntlrToLanguage;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.antlr.GraphqlLexer;
import graphql.parser.antlr.GraphqlParser;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import manifold.shade.org.antlr.v4.runtime.CharStreams;
import manifold.shade.org.antlr.v4.runtime.CodePointCharStream;
import manifold.shade.org.antlr.v4.runtime.CommonTokenStream;
import manifold.shade.org.antlr.v4.runtime.Token;
import manifold.shade.org.antlr.v4.runtime.atn.ParserATNSimulator;
import manifold.shade.org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class Parser {
    public Document parseDocument(String input) throws InvalidSyntaxException {
        return this.parseDocument(input, null);
    }

    public Document parseDocument(String input, String sourceName) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, sourceName).trackData(true).build();
        return this.parseDocument(multiSourceReader);
    }

    public Document parseDocument(Reader reader) throws InvalidSyntaxException {
        CodePointCharStream charStream;
        MultiSourceReader multiSourceReader = reader instanceof MultiSourceReader ? (MultiSourceReader)reader : MultiSourceReader.newMultiSourceReader().reader(reader, null).build();
        try {
            charStream = CharStreams.fromReader(multiSourceReader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        GraphqlLexer lexer = new GraphqlLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        GraphqlParser parser = new GraphqlParser(tokens);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ExtendedBailStrategy bailStrategy = new ExtendedBailStrategy(multiSourceReader);
        parser.setErrorHandler(bailStrategy);
        GraphqlAntlrToLanguage toLanguage = new GraphqlAntlrToLanguage(tokens, multiSourceReader);
        GraphqlParser.DocumentContext documentContext = parser.document();
        Document doc = toLanguage.createDocument(documentContext);
        Token stop = documentContext.getStop();
        List<Token> allTokens = tokens.getTokens();
        if (stop != null && allTokens != null && !allTokens.isEmpty()) {
            boolean sameChannel;
            Token last = allTokens.get(allTokens.size() - 1);
            boolean notEOF = last.getType() != -1;
            boolean lastGreaterThanDocument = last.getTokenIndex() > stop.getTokenIndex();
            boolean bl = sameChannel = last.getChannel() == stop.getChannel();
            if (notEOF && lastGreaterThanDocument && sameChannel) {
                throw bailStrategy.mkMoreTokensException(last);
            }
        }
        return doc;
    }
}

