/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.rt.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import manifold.rt.api.util.StreamUtil;
import manifold.templates.rt.ManifoldTemplates;
import manifold.templates.rt.runtime.ILayout;
import manifold.templates.rt.runtime.WrapAppendable;
import manifold.util.ManExceptionUtil;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class BaseTemplate {
    private ILayout _explicitLayout = null;
    private LocklessLazyVar<String> _templateText = LocklessLazyVar.make(() -> {
        try {
            InputStreamReader reader = new InputStreamReader(this.getTemplateResourceAsStream(), StandardCharsets.UTF_8);
            return StreamUtil.getContent(reader).replace("\r\n", "\n");
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    });

    protected abstract InputStream getTemplateResourceAsStream();

    protected String getTemplateText() {
        return this._templateText.get();
    }

    protected void setLayout(ILayout layout) {
        this._explicitLayout = layout;
    }

    protected ILayout getTemplateLayout() {
        if (this._explicitLayout != null) {
            return this._explicitLayout;
        }
        return ManifoldTemplates.getDefaultLayout(this.getClass().getName());
    }

    protected ILayout getExplicitLayout() {
        return this._explicitLayout;
    }

    protected void beforeRender(Appendable buffer, ILayout override, boolean topLevelTemplate) throws IOException {
        if (topLevelTemplate) {
            ILayout templateLayout = override == null ? this.getTemplateLayout() : override;
            templateLayout.header(buffer);
        }
    }

    protected void afterRender(Appendable buffer, ILayout override, boolean topLevelTemplate, long renderTime) throws IOException {
        if (topLevelTemplate) {
            ILayout templateLayout = override == null ? this.getTemplateLayout() : override;
            templateLayout.footer(buffer);
        }
        if (buffer instanceof WrapAppendable) {
            ((WrapAppendable)buffer).complete();
        }
        ManifoldTemplates.getTracer().trace(this.getClass(), renderTime);
    }

    protected void handleException(Exception e, String fileName, int lineStart, int[] templateLineNumbers) {
        StackTraceElement[] currentStack = e.getStackTrace();
        String templateClassName = this.getClass().getName();
        for (int elementToRemove = 0; elementToRemove < currentStack.length; ++elementToRemove) {
            StackTraceElement curr = currentStack[elementToRemove];
            if (!curr.getClassName().equals(templateClassName)) continue;
            if (curr.getMethodName().equals("renderImpl")) {
                this.handleTemplateException(e, fileName, lineStart, templateLineNumbers, elementToRemove);
                continue;
            }
            if (!curr.getMethodName().equals("footer") && !curr.getMethodName().equals("header")) continue;
            this.handleLayoutException(e, fileName, lineStart, templateLineNumbers, elementToRemove);
        }
    }

    private void handleTemplateException(Exception e, String fileName, int lineStart, int[] templateLineNumbers, int elementToRemove) {
        StackTraceElement b;
        StackTraceElement[] currentStack = e.getStackTrace();
        int lineNumber = currentStack[elementToRemove].getLineNumber();
        int javaLineNum = lineNumber - lineStart;
        String declaringClass = currentStack[elementToRemove + 1].getClassName();
        String methodName = currentStack[elementToRemove + 1].getMethodName();
        currentStack[elementToRemove + 1] = b = new StackTraceElement(declaringClass, methodName, fileName, templateLineNumbers[javaLineNum]);
        System.arraycopy(currentStack, elementToRemove + 1, currentStack, elementToRemove, currentStack.length - 1 - elementToRemove);
        this.throwUnchecked(e, currentStack);
    }

    private void handleLayoutException(Exception e, String fileName, int lineStart, int[] templateLineNumbers, int elementToReplace) {
        StackTraceElement b;
        StackTraceElement[] currentStack = e.getStackTrace();
        int lineNumber = currentStack[elementToReplace].getLineNumber();
        int javaLineNum = lineNumber - lineStart;
        String declaringClass = currentStack[elementToReplace].getClassName();
        String methodName = currentStack[elementToReplace].getMethodName();
        currentStack[elementToReplace] = b = new StackTraceElement(declaringClass, methodName, fileName, templateLineNumbers[javaLineNum]);
        this.throwUnchecked(e, currentStack);
    }

    private void throwUnchecked(Exception e, StackTraceElement[] currentStack) {
        e.setStackTrace(currentStack);
        throw ManExceptionUtil.unchecked(e);
    }

    public String toS(Object o) {
        return o == null ? "" : o.toString();
    }
}

