/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import java.math.BigDecimal;
import java.math.BigInteger;
import manifold.science.util.MetricFactorConstants;
import manifold.science.util.Rational;

public enum MetricScaleUnit {
    y(MetricFactorConstants.YOCTO, "yocto", "y"),
    z(MetricFactorConstants.ZEPTO, "zepto", "z"),
    a(MetricFactorConstants.ATTO, "atto", "a"),
    fe(MetricFactorConstants.FEMTO, "femto", "f"),
    p(MetricFactorConstants.PICO, "pico", "p"),
    n(MetricFactorConstants.NANO, "nano", "n"),
    u(MetricFactorConstants.MICRO, "micro", "u"),
    m(MetricFactorConstants.MILLI, "milli", "m"),
    c(MetricFactorConstants.CENTI, "centi", "c"),
    de(MetricFactorConstants.DECI, "deci", "d"),
    da(MetricFactorConstants.DECA, "Deca", "da"),
    h(MetricFactorConstants.HECTO, "Hecto", "h"),
    k(MetricFactorConstants.KILO, "Kilo", "k"),
    Ki(MetricFactorConstants.KIBI, "Kibi", "Ki"),
    M(MetricFactorConstants.KILO.pow(2), "Mega", "M"),
    Mi(MetricFactorConstants.KIBI.pow(2), "Mebi", "Mi"),
    G(MetricFactorConstants.KILO.pow(3), "Giga", "G"),
    Gi(MetricFactorConstants.KIBI.pow(3), "Gibi", "Gi"),
    T(MetricFactorConstants.KILO.pow(4), "Tera", "T"),
    Ti(MetricFactorConstants.KIBI.pow(4), "Tebi", "Ti"),
    P(MetricFactorConstants.KILO.pow(5), "Peta", "P"),
    Pi(MetricFactorConstants.KIBI.pow(5), "Pebi", "Pi"),
    E(MetricFactorConstants.KILO.pow(6), "Exa", "E"),
    Ei(MetricFactorConstants.KIBI.pow(6), "Exbi", "Ei"),
    Z(MetricFactorConstants.KILO.pow(7), "Zetta", "Z"),
    Zi(MetricFactorConstants.KIBI.pow(7), "Zebi", "Zi"),
    Y(MetricFactorConstants.KILO.pow(8), "Yotta", "Y"),
    Yi(MetricFactorConstants.KIBI.pow(8), "Yobi", "Yi");

    private Rational _amount;
    private String _name;
    private String _symbol;

    private MetricScaleUnit(Rational amount, String name, String symbol) {
        this._amount = amount;
        this._name = name;
        this._symbol = symbol;
    }

    public Rational getAmount() {
        return this._amount;
    }

    public String getUnitName() {
        return this._name;
    }

    public String getUnitSymbol() {
        return this._symbol;
    }

    public Rational postfixBind(String value) {
        return this._amount.times(Rational.get(value));
    }

    public Rational postfixBind(Integer value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(Long value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(Float value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(Double value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(BigInteger value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(BigDecimal value) {
        return this._amount.times(value);
    }

    public Rational postfixBind(Rational value) {
        return this._amount.times(value);
    }
}

