/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import manifold.preprocessor.expression.AndExpression;
import manifold.preprocessor.expression.EmptyExpression;
import manifold.preprocessor.expression.EqualityExpression;
import manifold.preprocessor.expression.Expression;
import manifold.preprocessor.expression.ExpressionTokenType;
import manifold.preprocessor.expression.ExpressionTokenizer;
import manifold.preprocessor.expression.Identifier;
import manifold.preprocessor.expression.NotExpression;
import manifold.preprocessor.expression.OrExpression;
import manifold.preprocessor.expression.ParenthesizedExpression;
import manifold.preprocessor.expression.StringLiteral;

public class ExpressionParser {
    private final CharSequence _buffer;
    private final int _offset;
    private final int _endOffset;
    private ExpressionTokenizer _tokenizer;

    public ExpressionParser(CharSequence buffer, int offset, int endOffset) {
        this._buffer = buffer;
        this._offset = offset;
        this._endOffset = endOffset;
    }

    public Expression parse() {
        this._tokenizer = new ExpressionTokenizer(this._buffer, this._offset, this._endOffset);
        this._tokenizer.advance();
        return this.parseExpression();
    }

    private Expression parseExpression() {
        return this.parseOrExpression();
    }

    private Expression parseOrExpression() {
        int offset = this.skipWhitespace();
        Expression lhs = this.parseAndExpression();
        while (this.match(ExpressionTokenType.Or)) {
            Expression rhs = this.parseAndExpression();
            lhs = new OrExpression(lhs, rhs, offset, rhs.getEndOffset());
        }
        return lhs;
    }

    private Expression parseAndExpression() {
        int offset = this.skipWhitespace();
        Expression lhs = this.parseEqualityExpression();
        while (this.match(ExpressionTokenType.And)) {
            Expression rhs = this.parseEqualityExpression();
            lhs = new AndExpression(lhs, rhs, offset, rhs.getEndOffset());
        }
        return lhs;
    }

    private Expression parseEqualityExpression() {
        int offset = this.skipWhitespace();
        Expression lhs = this.parseUnaryExpression();
        while (true) {
            boolean not = false;
            if (!this.match(ExpressionTokenType.Equals) && !(not = this.match(ExpressionTokenType.NotEquals))) break;
            Expression rhs = this.parseUnaryExpression();
            lhs = new EqualityExpression(lhs, rhs, not, offset, rhs.getEndOffset());
        }
        return lhs;
    }

    private Expression parseUnaryExpression() {
        int offset = this.skipWhitespace();
        if (this.match(ExpressionTokenType.Not)) {
            Expression expr = this.parseExpression();
            return new NotExpression(expr, offset, expr.getEndOffset());
        }
        if (this.match(ExpressionTokenType.OpenParen)) {
            Expression expr = this.parseExpression();
            int endOffset = expr.getEndOffset();
            if (!this.match(ExpressionTokenType.CloseParen, false)) {
                expr.error("')' Expected", this._tokenizer.getTokenStart());
            } else {
                endOffset = this._tokenizer.getTokenEnd();
                this.match(ExpressionTokenType.CloseParen);
            }
            return new ParenthesizedExpression(expr, offset, endOffset);
        }
        if (this.match(ExpressionTokenType.Identifier, false)) {
            int endOffset = this._tokenizer.getTokenEnd();
            String name = this._tokenizer.getTokenText().toString();
            this.match(ExpressionTokenType.Identifier);
            return new Identifier(name, offset, endOffset);
        }
        if (this.match(ExpressionTokenType.StringLiteral, false)) {
            int endOffset = this._tokenizer.getTokenEnd();
            String string = this._tokenizer.getTokenText().toString();
            this.match(ExpressionTokenType.StringLiteral);
            StringLiteral stringLiteral = new StringLiteral(string, offset, endOffset);
            if (string.charAt(string.length() - 1) != '\"') {
                stringLiteral.error("Missing closing quote for string literal", stringLiteral.getEndOffset() - 1);
            }
            return stringLiteral;
        }
        return new EmptyExpression(offset);
    }

    private boolean match(ExpressionTokenType type) {
        return this.match(type, true);
    }

    private boolean match(ExpressionTokenType type, boolean advance) {
        this.skipWhitespace();
        if (this._tokenizer.getTokenType() == type) {
            if (advance) {
                this._tokenizer.advance();
            }
            return true;
        }
        return false;
    }

    private int skipWhitespace() {
        while (this._tokenizer.getTokenType() == ExpressionTokenType.Whitespace) {
            this._tokenizer.advance();
        }
        return this._tokenizer.getTokenStart();
    }
}

