/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.rt.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import manifold.js.rt.parser.Token;
import manifold.js.rt.parser.TokenType;

public class Tokenizer {
    private URL _url;
    private int _bLineNumber;
    private int _bCol;
    private int _bOffset;
    private int _lineNumber;
    private int _col;
    private int _offset;
    private String _content;
    private char _ch;

    public Tokenizer(String source, String url) {
        this.init(source, url);
    }

    private void init(String content, String url) {
        this._content = content.replace("\r\n", "\n");
        this._lineNumber = 1;
        this._col = 0;
        this._offset = -1;
        try {
            this._url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.nextChar();
    }

    URL getUrl() {
        return this._url;
    }

    Token nextNonWhiteSpace() {
        Token tok = this.next();
        while (tok.getType() == TokenType.WHITESPACE) {
            tok = this.next();
        }
        return tok;
    }

    public Token next() {
        Token ret;
        this.updatePosition();
        if (Character.isWhitespace(this._ch)) {
            ret = this.consumeWhitespace();
        } else if (this._ch == '\'' || this._ch == '\"') {
            ret = this.consumeString();
        } else if (this._ch == '`') {
            ret = this.consumeTemplateString();
        } else if (TokenType.startsIdentifier(this._ch)) {
            ret = this.consumeWord();
        } else if (this._ch == '.') {
            ret = TokenType.isDigit(this.peek()) ? this.consumeNumber() : this.consumePunctuation();
        } else if (TokenType.isDigit(this._ch)) {
            ret = this.consumeNumber();
        } else if (TokenType.isPunctuation(this._ch)) {
            ret = this.consumePunctuation();
        } else if (this._ch == '/') {
            switch (this.peek()) {
                case '*': {
                    ret = this.consumeMultilineComment();
                    break;
                }
                case '/': {
                    ret = this.consumeSingleLineComment();
                    break;
                }
                default: {
                    ret = this.consumeOperator();
                    break;
                }
            }
        } else if (TokenType.isPartOfOperator(this._ch)) {
            ret = this.consumeOperator();
        } else if (this.reachedEOF()) {
            ret = this.newToken(TokenType.EOF, "EOF");
        } else {
            ret = this.errToken(String.valueOf(this._ch), "unknown char");
            this.nextChar();
        }
        if (ret.getType() == TokenType.COMMENT) {
            return this.next();
        }
        return ret;
    }

    private Token consumeNumber() {
        boolean isDec = true;
        boolean isBin = false;
        boolean isHex = false;
        boolean isOctal = false;
        boolean isImpliedOctal = false;
        boolean hasDecPoint = false;
        StringBuilder val = new StringBuilder();
        if (this._ch == '0') {
            isDec = false;
            if ("oOxXbB".indexOf(this.peek()) >= 0) {
                val.append(this._ch);
                this.nextChar();
                if (this._ch == 'b' || this._ch == 'B') {
                    isBin = true;
                } else if (this._ch == 'x' || this._ch == 'X') {
                    isHex = true;
                } else if (this._ch == 'o' || this._ch == 'O') {
                    isOctal = true;
                }
                val.append(this._ch);
                this.nextChar();
            } else {
                isImpliedOctal = true;
            }
        }
        while ((!isDec || !hasDecPoint || this._ch != '.') && (isDec && (TokenType.isDigit(this._ch) || this._ch == '.') || isHex && TokenType.isHexCh(this._ch) || (isOctal || isImpliedOctal) && TokenType.isOctal(this._ch)) || isBin && TokenType.isBinary(this._ch)) {
            if (this._ch == '.') {
                hasDecPoint = true;
            }
            val.append(this._ch);
            this.nextChar();
            if (isDec && (this._ch == 'e' || this._ch == 'E')) {
                return this.consumeExponent(val);
            }
            if (!isImpliedOctal || this._ch != '8' && this._ch != '9') continue;
            isDec = true;
            isImpliedOctal = false;
        }
        if ((isHex || isBin || isOctal) && val.length() <= 2) {
            return this.errToken(val.toString(), "illegal number token");
        }
        return this.newToken(TokenType.NUMBER, val.toString());
    }

    private Token consumeExponent(StringBuilder val) {
        val.append(this._ch);
        this.nextChar();
        if (this._ch == '+' || this._ch == '-') {
            val.append(this._ch);
            this.nextChar();
        }
        while (TokenType.isDigit(this._ch)) {
            val.append(this._ch);
            this.nextChar();
        }
        return this.newToken(TokenType.NUMBER, val.toString());
    }

    private Token consumeWord() {
        StringBuilder val = new StringBuilder();
        while (TokenType.partOfIdentifier(this._ch)) {
            val.append(this._ch);
            this.nextChar();
        }
        String strVal = val.toString();
        if (TokenType.isKeyword(strVal)) {
            return this.newToken(TokenType.KEYWORD, strVal);
        }
        if (TokenType.isNull(strVal)) {
            return this.newToken(TokenType.NULL, strVal);
        }
        if (TokenType.isBoolean(strVal)) {
            return this.newToken(TokenType.BOOLEAN, strVal);
        }
        if (TokenType.isClass(strVal)) {
            return this.newToken(TokenType.CLASS, strVal);
        }
        return this.newToken(TokenType.IDENTIFIER, strVal);
    }

    private Token consumeString() {
        char enterQuote = this._ch;
        String errorMsg = null;
        StringBuilder val = new StringBuilder(String.valueOf(this._ch));
        this.nextChar();
        while (this._ch != enterQuote) {
            if (this.reachedEOF()) {
                return this.errToken(val.toString(), "unterminated string");
            }
            if (TokenType.isLineTerminator(this._ch)) {
                errorMsg = "newline character in string";
            }
            val.append(this._ch);
            if (this._ch == '\\') {
                errorMsg = this.consumeEscapeSequence(val);
                continue;
            }
            this.nextChar();
        }
        val.append(this._ch);
        this.nextChar();
        if (errorMsg != null) {
            return this.errToken(val.toString(), errorMsg);
        }
        return this.newToken(TokenType.STRING, val.toString());
    }

    private Token consumeTemplateString() {
        this.nextChar();
        StringBuilder val = new StringBuilder();
        while (this._ch != '`') {
            if (this.reachedEOF()) {
                return this.errToken(val.toString(), "unterminated string template");
            }
            val.append(this._ch);
            this.nextChar();
        }
        this.nextChar();
        return this.newToken(TokenType.TEMPLATESTRING, val.toString());
    }

    private String consumeEscapeSequence(StringBuilder val) {
        this.nextChar();
        switch (this._ch) {
            case 'u': {
                return this.consumeUnicodeEscapeSequence(val);
            }
            case 'x': {
                return this.consumeHexEscapeSequence(val);
            }
        }
        val.append(this._ch);
        this.nextChar();
        return null;
    }

    private String consumeUnicodeEscapeSequence(StringBuilder val) {
        long MAX_UNICODE_NUM = 0x10FFFFL;
        val.append(this._ch);
        this.nextChar();
        if (this._ch == '{') {
            val.append(this._ch);
            this.nextChar();
            StringBuilder num = new StringBuilder();
            while (this._ch != '}') {
                if (!TokenType.isHexCh(this._ch)) {
                    return "non-hex character in unicode escape";
                }
                num.append(this._ch);
                val.append(this._ch);
                this.nextChar();
            }
            val.append(this._ch);
            this.nextChar();
            if (Long.parseLong(num.toString(), 16) > 0x10FFFFL) {
                return "undefined Unicode point";
            }
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            if (!TokenType.isHexCh(this._ch)) {
                return "non-hex character in unicode escape";
            }
            val.append(this._ch);
            this.nextChar();
        }
        return null;
    }

    private String consumeHexEscapeSequence(StringBuilder val) {
        val.append(this._ch);
        this.nextChar();
        for (int i = 0; i < 2; ++i) {
            if (!TokenType.isHexCh(this._ch)) {
                return "non-hex character in hex escape";
            }
            val.append(this._ch);
            this.nextChar();
        }
        return null;
    }

    private Token consumePunctuation() {
        Token tok = this.newToken(TokenType.PUNCTUATION, String.valueOf(this._ch));
        this.nextChar();
        return tok;
    }

    private Token consumeOperator() {
        StringBuilder val = new StringBuilder();
        while (TokenType.isPartOfOperator(this._ch) && TokenType.isOperator(val.toString() + this._ch)) {
            val.append(this._ch);
            this.nextChar();
        }
        return this.newToken(TokenType.OPERATOR, val.toString());
    }

    private Token consumeMultilineComment() {
        StringBuilder val = new StringBuilder("/*");
        this.nextChar();
        this.nextChar();
        while (this._ch != '/' || val.charAt(val.length() - 1) != '*') {
            val.append(this._ch);
            if (this.reachedEOF()) {
                return this.newToken(TokenType.ERROR, "unterminated multiline comment");
            }
            this.nextChar();
        }
        val.append(this._ch);
        this.nextChar();
        return this.newToken(TokenType.COMMENT, val.toString());
    }

    private Token consumeSingleLineComment() {
        StringBuilder val = new StringBuilder("//");
        this.nextChar();
        this.nextChar();
        while (this._ch != '\n' && this._ch != '\r' && !this.reachedEOF()) {
            val.append(this._ch);
            this.nextChar();
        }
        return this.newToken(TokenType.COMMENT, val.toString());
    }

    private Token consumeWhitespace() {
        StringBuilder val = new StringBuilder();
        while (Character.isWhitespace(this._ch)) {
            val.append(this._ch);
            this.nextChar();
        }
        return this.newToken(TokenType.WHITESPACE, val.toString());
    }

    char peek() {
        int next = 1 + this._offset;
        return next >= this._content.length() ? (char)'\u0000' : this._content.charAt(next);
    }

    void nextChar() {
        if (this._offset + 1 >= this._content.length()) {
            this._offset = this._content.length();
            this._ch = (char)65535;
            return;
        }
        this._ch = this._content.charAt(++this._offset);
        ++this._col;
        if (this._ch == '\n') {
            this._col = 0;
            ++this._lineNumber;
        }
    }

    private void updatePosition() {
        this._bCol = this._col;
        this._bLineNumber = this._lineNumber;
        this._bOffset = this._offset;
    }

    char currChar() {
        return this._ch;
    }

    Token newToken(TokenType type, String val) {
        return new Token(type, val, this._bLineNumber, this._bCol, this._bOffset);
    }

    private Token errToken(String val, String errorMsg) {
        return new Token(TokenType.ERROR, val, errorMsg);
    }

    boolean reachedEOF() {
        return this._ch == '\uffff';
    }

    public List<Token> tokenize() {
        LinkedList<Token> tokens = new LinkedList<Token>();
        Token token = this.next();
        while (token.getType() != TokenType.EOF) {
            tokens.add(token);
            token = this.next();
        }
        return tokens;
    }
}

