/*
 * Decompiled with CFR 0.152.
 */
package manifold.js;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.api.type.SourcePosition;
import manifold.js.JavascriptModel;
import manifold.js.JavascriptProgram;
import manifold.js.rt.JsRuntime;
import manifold.js.rt.parser.tree.ClassFunctionNode;
import manifold.js.rt.parser.tree.ClassNode;
import manifold.js.rt.parser.tree.ConstructorNode;
import manifold.js.rt.parser.tree.ParameterNode;
import manifold.js.rt.parser.tree.ProgramNode;
import manifold.js.rt.parser.tree.PropertyNode;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.ManEscapeUtil;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptClass {
    private static ThreadLocal<Long> uid = new ThreadLocal();

    static SrcClass genClass(String fqn, JavascriptModel model, ProgramNode programNode, IFile file) {
        ClassNode classNode = programNode.getFirstChild(ClassNode.class);
        SrcClass clazz = (SrcClass)((SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.Class).imports(JsRuntime.class)).imports(SourcePosition.class);
        clazz.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)programNode.getUrl().toString()).addArgument("feature", String.class, (Object)ManClassUtil.getShortClassName(fqn)).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(classNode.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(classNode.getEnd().getOffset() - classNode.getStart().getOffset())));
        String superClass = classNode.getSuperClass();
        if (superClass != null) {
            clazz.superClass(superClass);
        }
        clazz.addField(((SrcField)new SrcField("SCOPE", ScriptableObject.class).modifiers(74L)).initializer("null"));
        clazz.addField(((SrcField)new SrcField("UID", Long.TYPE).modifiers(74L)).initializer("0L"));
        clazz.addField(new SrcField("_context", ScriptableObject.class));
        JavascriptClass.addConstructor(clazz, classNode, file);
        JavascriptClass.addUtilityMethods(clazz, model, classNode, fqn);
        JavascriptClass.addMethods(fqn, clazz, classNode, file);
        JavascriptClass.addProperties(fqn, clazz, classNode, file);
        return clazz;
    }

    private static void addConstructor(SrcClass clazz, ClassNode classNode, IFile file) {
        List<SrcParameter> srcParameters;
        ConstructorNode constructor = classNode.getFirstChild(ConstructorNode.class);
        SrcConstructor ctor = (SrcConstructor)((SrcConstructor)new SrcConstructor().name(classNode.getName())).modifiers(1L);
        if (constructor != null) {
            srcParameters = JavascriptProgram.makeSrcParameters(constructor, ctor);
            ctor.addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)"constructor").addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(constructor.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(constructor.getEnd().getOffset() - constructor.getStart().getOffset())));
        } else {
            srcParameters = Collections.emptyList();
        }
        ctor.body("_context = " + JsRuntime.class.getSimpleName() + ".initInstance(getScope(), \"" + classNode.getName() + "\"" + JavascriptProgram.generateArgList(srcParameters) + ");");
        clazz.addConstructor(ctor);
    }

    private static void addUtilityMethods(SrcClass clazz, JavascriptModel model, ClassNode classNode, String fqn) {
        String url;
        long uid = JavascriptClass.incUid();
        IFile file = JavascriptProgram.loadSrcForName(model, fqn, "js");
        try {
            url = file.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String content = ResourceFileTypeManifold.getContent(file);
        content = ManEscapeUtil.escapeForJavaStringLiteral(content);
        SrcMethod m = (SrcMethod)((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("getScope")).modifiers(10L)).returns(ScriptableObject.class)).body("if(" + uid + "L != UID) {\n      synchronized(" + classNode.getName() + ".class) {\n        if(" + uid + "L != UID) {\n          UID = " + uid + "L;\n          SCOPE = " + JsRuntime.class.getSimpleName() + ".init(\"" + fqn + "\", \"" + content + "\", \"" + url + "\");\n        }\n      }\n    }\n    return SCOPE;");
        clazz.addMethod(m);
    }

    private static long incUid() {
        Long id = uid.get();
        if (id == null) {
            id = 1L;
            uid.set(id);
        }
        id = id + 1L;
        uid.set(id);
        return id;
    }

    private static void addMethods(String fqn, SrcClass clazz, ClassNode classNode, IFile file) {
        for (ClassFunctionNode node : classNode.getChildren(ClassFunctionNode.class)) {
            Object srcMethod = ((SrcMethod)((SrcMethod)new SrcMethod().name(node.getName())).modifiers(1 | (node.isStatic() ? 8 : 0))).returns(node.getReturnType());
            ((SrcAnnotated)srcMethod).addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            ParameterNode parameters = node.getFirstChild(ParameterNode.class);
            for (SrcParameter srcParameter : JavascriptClass.toParamList(parameters)) {
                ((SrcAnnotated)srcMethod).addParam(srcParameter);
            }
            if (node.isStatic()) {
                ((AbstractSrcMethod)srcMethod).body("return " + JsRuntime.class.getSimpleName() + ".invokeStatic(getScope(), \"" + ManClassUtil.getShortClassName(fqn) + "\", \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(JavascriptClass.toParamList(parameters)) + ");");
            } else {
                ((AbstractSrcMethod)srcMethod).body("return " + JsRuntime.class.getSimpleName() + ".invoke(_context, \"" + node.getName() + "\"" + JavascriptProgram.generateArgList(JavascriptClass.toParamList(parameters)) + ");");
            }
            clazz.addMethod((AbstractSrcMethod)srcMethod);
        }
    }

    public static List<SrcParameter> toParamList(ParameterNode parameters) {
        ArrayList<String> params = parameters.getParams();
        ArrayList<SrcParameter> parameterInfoBuilders = new ArrayList<SrcParameter>(params.size());
        for (int i = 0; i < params.size(); ++i) {
            parameterInfoBuilders.add(new SrcParameter(params.get(i), parameters.getTypes().get(i)));
        }
        return parameterInfoBuilders;
    }

    private static void addProperties(String fqn, SrcClass clazz, ClassNode classNode, IFile file) {
        for (PropertyNode node : classNode.getChildren(PropertyNode.class)) {
            String name = node.getName();
            String capitalizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
            if (node.isSetter()) {
                Object setter = ((SrcMethod)((SrcMethod)((SrcMethod)new SrcMethod().name("set" + capitalizedName)).modifiers(1 | (node.isStatic() ? 8 : 0))).addParam("val", Object.class)).returns("void");
                ((SrcAnnotated)setter).addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, JavascriptClass.absoluteOffset(node.getStart().getOffset(), file)).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
                if (node.isStatic()) {
                    ((AbstractSrcMethod)setter).body(JsRuntime.class.getSimpleName() + ".setStaticProp(getScope(), \"" + ManClassUtil.getShortClassName(fqn) + "\", \"" + name + "\", val);");
                } else {
                    ((AbstractSrcMethod)setter).body(JsRuntime.class.getSimpleName() + ".setProp(_context, \"" + name + "\", val);");
                }
                clazz.addMethod((AbstractSrcMethod)setter);
                continue;
            }
            Object getter = ((SrcMethod)((SrcMethod)new SrcMethod().name("get" + capitalizedName)).modifiers(1 | (node.isStatic() ? 8 : 0))).returns(node.getReturnType());
            ((SrcAnnotated)getter).addAnnotation(new SrcAnnotationExpression(SourcePosition.class).addArgument("url", String.class, (Object)classNode.getProgramNode().getUrl().toString()).addArgument("feature", String.class, (Object)node.getName()).addArgument("offset", Integer.TYPE, (Object)node.getStart().getOffset()).addArgument("length", Integer.TYPE, (Object)(node.getEnd().getOffset() - node.getStart().getOffset())));
            if (node.isStatic()) {
                ((AbstractSrcMethod)getter).body("return " + JsRuntime.class.getSimpleName() + ".getStaticProp(getScope(), \"" + ManClassUtil.getShortClassName(fqn) + "\", \"" + name + "\");");
            } else {
                ((AbstractSrcMethod)getter).body("return " + JsRuntime.class.getSimpleName() + ".getProp(_context, \"" + name + "\");");
            }
            clazz.addMethod((AbstractSrcMethod)getter);
        }
    }

    private static Object absoluteOffset(int offset, IFile file) {
        if (file instanceof IFileFragment) {
            offset += ((IFileFragment)file).getOffset();
        }
        return offset;
    }
}

