/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.gen.AbstractSrcClass;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcMethod;
import manifold.api.gen.SrcParameter;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.internal.javac.ClassSymbols;
import manifold.rt.api.util.ManEscapeUtil;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class SrcClassUtil {
    private static final SrcClassUtil INSTANCE = new SrcClassUtil();

    private SrcClassUtil() {
    }

    public static SrcClassUtil instance() {
        return INSTANCE;
    }

    public SrcClass makeStub(String fqn, Symbol.ClassSymbol classSymbol, CompilationUnitTree compilationUnit, BasicJavacTask javacTask, IModule module, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        return this.makeStub(fqn, classSymbol, compilationUnit, javacTask, module, location, errorHandler, true);
    }

    public SrcClass makeStub(String fqn, Symbol.ClassSymbol classSymbol, CompilationUnitTree compilationUnit, BasicJavacTask javacTask, IModule module, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler, boolean withMembers) {
        return this.makeSrcClass(fqn, null, classSymbol, compilationUnit, javacTask, module, location, errorHandler, withMembers);
    }

    private SrcClass makeSrcClass(String fqn, SrcClass enclosing, Symbol.ClassSymbol classSymbol, CompilationUnitTree compilationUnit, BasicJavacTask javacTask, IModule module, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler, boolean withMembers) {
        SrcClass srcClass = enclosing == null ? (SrcClass)new SrcClass(fqn, AbstractSrcClass.Kind.from(classSymbol.getKind()), location, module, errorHandler).modifiers(classSymbol.getModifiers()) : (SrcClass)new SrcClass(fqn, enclosing, AbstractSrcClass.Kind.from(classSymbol.getKind())).modifiers(classSymbol.getModifiers());
        if (classSymbol.getEnclosingElement() instanceof Symbol.PackageSymbol && compilationUnit != null) {
            for (ImportTree importTree : compilationUnit.getImports()) {
                if (importTree.isStatic()) {
                    srcClass.addStaticImport(importTree.getQualifiedIdentifier().toString());
                    continue;
                }
                srcClass.addImport(importTree.getQualifiedIdentifier().toString());
            }
        }
        this.addAnnotations(srcClass, classSymbol);
        for (Symbol.TypeVariableSymbol typeVariableSymbol : classSymbol.getTypeParameters()) {
            srcClass.addTypeVar(this.makeTypeVarType(typeVariableSymbol));
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType)) {
            srcClass.superClass(this.makeNestedType(superclass));
        }
        for (Type iface : classSymbol.getInterfaces()) {
            srcClass.addInterface(this.makeNestedType(iface));
        }
        if (withMembers) {
            java.util.List list = classSymbol.getEnclosedElements();
            for (Symbol sym : list) {
                if (sym instanceof Symbol.ClassSymbol) {
                    this.addInnerClass(module, srcClass, sym, javacTask);
                    continue;
                }
                if (sym instanceof Symbol.VarSymbol) {
                    this.addField(srcClass, (Symbol.VarSymbol)sym);
                    continue;
                }
                if (!(sym instanceof Symbol.MethodSymbol) || this.isEnumMethod(sym)) continue;
                this.addMethod(module, srcClass, (Symbol.MethodSymbol)sym, javacTask);
            }
            this.addDefaultCtorForEnum(classSymbol, srcClass, list);
        }
        return srcClass;
    }

    private void addDefaultCtorForEnum(Symbol.ClassSymbol classSymbol, SrcClass srcClass, java.util.List<Symbol> members) {
        if (!classSymbol.isEnum()) {
            return;
        }
        if (members.stream().noneMatch(e -> e.isConstructor() && e instanceof Symbol.MethodSymbol && ((List)((Symbol.MethodSymbol)e).getParameters()).isEmpty())) {
            SrcMethod srcMethod = new SrcMethod(srcClass, true);
            srcMethod.body(new SrcStatementBlock().addStatement(new SrcRawStatement().rawText("throw new RuntimeException();")));
            srcClass.addMethod(srcMethod);
        }
    }

    private boolean isEnumMethod(Symbol sym) {
        return sym.getEnclosingElement().isEnum() && (sym.toString().equals("values()") || sym.toString().equals("valueOf(java.lang.String)"));
    }

    private SrcType makeNestedType(Type type) {
        SrcType srcType;
        String fqn = type.toString();
        Type enclosingType = type.getEnclosingType();
        if (enclosingType != null && !(enclosingType instanceof NoType) && fqn.length() > enclosingType.toString().length()) {
            String simpleName = fqn.substring(enclosingType.toString().length() + 1);
            srcType = new SrcType(simpleName);
            srcType.setEnclosingType(this.makeNestedType(enclosingType));
        } else {
            srcType = new SrcType(fqn);
        }
        return srcType;
    }

    private void addInnerClass(IModule module, SrcClass srcClass, Symbol sym, BasicJavacTask javacTask) {
        SrcClass innerClass = this.makeSrcClass(sym.getQualifiedName().toString(), srcClass, (Symbol.ClassSymbol)sym, null, javacTask, module, null, null, true);
        srcClass.addInnerClass(innerClass);
    }

    private void addField(SrcClass srcClass, Symbol.VarSymbol sym) {
        SrcField srcField = new SrcField(sym.name.toString(), this.makeSrcType(sym.type, sym, TargetType.FIELD, -1));
        if (sym.isEnum()) {
            srcField.enumConst();
            srcClass.addEnumConst(srcField);
        } else {
            srcField.modifiers(sym.getModifiers());
            if (Modifier.isFinal((int)srcField.getModifiers())) {
                Object constValue = sym.getConstantValue();
                constValue = constValue == null ? this.getValueForType(sym.type) : "(" + sym.type + ")" + this.qualifyConstantValue(constValue);
                srcField.initializer((String)constValue);
            }
            srcClass.addField(srcField);
        }
    }

    private String qualifyConstantValue(Object constValue) {
        String value = String.valueOf(constValue);
        if (constValue instanceof Long) {
            value = value + "L";
        } else if (constValue instanceof Float) {
            value = value + "f";
        } else if (constValue instanceof Double) {
            value = value + "d";
        } else if (constValue instanceof String) {
            value = '\"' + ManEscapeUtil.escapeForJavaStringLiteral(value) + '\"';
        } else if (constValue instanceof Character) {
            value = "'" + ManEscapeUtil.escapeForJava(((Character)constValue).charValue()) + "'";
        }
        return value;
    }

    private void addMethod(IModule module, SrcClass srcClass, Symbol.MethodSymbol method, BasicJavacTask javacTask) {
        String name = method.flatName().toString();
        SrcMethod srcMethod = new SrcMethod(srcClass, name.equals("<init>"));
        this.addAnnotations(srcMethod, method);
        srcMethod.modifiers(method.getModifiers());
        if ((method.flags() & 0x400000000L) != 0L) {
            srcMethod.modifiers(srcMethod.getModifiers() | 0x80L);
        }
        if (name.equals("<clinit>")) {
            return;
        }
        if (!srcMethod.isConstructor()) {
            srcMethod.name(name);
            srcMethod.returns(this.makeSrcType(method.getReturnType(), method, TargetType.METHOD_RETURN, -1));
        }
        for (Symbol.TypeVariableSymbol typeVar : method.getTypeParameters()) {
            srcMethod.addTypeVar(this.makeTypeVarType(typeVar));
        }
        java.util.List parameters = method.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            Symbol.VarSymbol param = (Symbol.VarSymbol)((List)parameters).get(i);
            SrcParameter srcParam = new SrcParameter(param.flatName().toString(), this.makeSrcType(param.type, method, TargetType.METHOD_FORMAL_PARAMETER, i));
            srcMethod.addParam(srcParam);
            this.addAnnotations(srcParam, param);
        }
        java.util.List thrownTypes = method.getThrownTypes();
        for (int i = 0; i < ((List)thrownTypes).size(); ++i) {
            Type throwType = (Type)((List)thrownTypes).get(i);
            srcMethod.addThrowType(this.makeSrcType(throwType, method, TargetType.THROWS, i));
        }
        String bodyStmt = srcMethod.isConstructor() && !srcClass.isEnum() ? this.genSuperCtorCall(module, srcClass, javacTask) : "throw new RuntimeException();";
        srcMethod.body(new SrcStatementBlock().addStatement(new SrcRawStatement().rawText(bodyStmt)));
        srcClass.addMethod(srcMethod);
    }

    private SrcType makeSrcType(Type type, Symbol symbol, TargetType targetType, int index) {
        SrcType srcType;
        java.util.List annotationMirrors = type.getAnnotationMirrors();
        if (annotationMirrors != null && !((List)annotationMirrors).isEmpty()) {
            String unannotatedType = JreUtil.isJava8() ? ReflectUtil.method(type, "unannotatedType", new Class[0]).invoke(new Object[0]).toString() : ReflectUtil.method(type, "cloneWithMetadata", ReflectUtil.type("com.sun.tools.javac.code.TypeMetadata")).invoke(ReflectUtil.field("com.sun.tools.javac.code.TypeMetadata", "EMPTY").getStatic()).toString();
            srcType = new SrcType(unannotatedType);
        } else {
            srcType = new SrcType(this.typeNoAnnotations(type));
        }
        SymbolMetadata metadata = symbol.getMetadata();
        if (metadata == null || metadata.isTypesEmpty()) {
            return srcType;
        }
        List<Attribute.TypeCompound> typeAttributes = metadata.getTypeAttributes();
        if (typeAttributes.isEmpty()) {
            return null;
        }
        java.util.List<Attribute.TypeCompound> targetedTypeAttrs = typeAttributes.stream().filter(attr -> attr.position.type == targetType && this.isTargetIndex(targetType, (Attribute.TypeCompound)attr, index)).collect(Collectors.toList());
        this.annotateType(srcType, targetedTypeAttrs);
        return srcType;
    }

    private String typeNoAnnotations(Type type) {
        if (JreUtil.isJava8()) {
            if (type instanceof Type.ArrayType) {
                return this.typeNoAnnotations(((Type.ArrayType)type).getComponentType().unannotatedType()) + "[]";
            }
            return type.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (type instanceof Type.ClassType) {
            if (type.getEnclosingType().hasTag(TypeTag.CLASS) && ReflectUtil.field(type.tsym.owner, "kind").get() == ReflectUtil.field("com.sun.tools.javac.code.Kinds$Kind", "TYP").getStatic()) {
                sb.append(this.typeNoAnnotations(type.getEnclosingType()));
                sb.append(".");
                sb.append(ReflectUtil.method(type, "className", Symbol.class, Boolean.TYPE).invoke(type.tsym, false));
            } else {
                sb.append(ReflectUtil.method(type, "className", Symbol.class, Boolean.TYPE).invoke(type.tsym, true));
            }
            List<Type> typeArgs = type.getTypeArguments();
            if (typeArgs.nonEmpty()) {
                sb.append('<');
                for (int i = 0; i < typeArgs.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    Type typeArg = typeArgs.get(i);
                    sb.append(this.typeNoAnnotations(typeArg));
                }
                sb.append(">");
            }
        } else if (type instanceof Type.ArrayType) {
            sb.append(this.typeNoAnnotations(((Type.ArrayType)type).getComponentType())).append("[]");
        } else if (type instanceof Type.WildcardType) {
            Type.WildcardType wildcardType = (Type.WildcardType)type;
            BoundKind kind = wildcardType.kind;
            sb.append(kind.toString());
            if (kind != BoundKind.UNBOUND) {
                sb.append(this.typeNoAnnotations(wildcardType.type));
            }
        } else {
            sb.append(type.toString());
        }
        return sb.toString();
    }

    private boolean isTargetIndex(TargetType targetType, Attribute.TypeCompound attr, int index) {
        switch (targetType) {
            case METHOD_FORMAL_PARAMETER: {
                return attr.position.parameter_index == index;
            }
            case THROWS: {
                return attr.position.type_index == index;
            }
        }
        return index < 0;
    }

    private void annotateType(SrcType srcType, java.util.List<Attribute.TypeCompound> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        for (Attribute.TypeCompound attr : attributes) {
            List<Object> attrLocation;
            TypeAnnotationPosition attrPos;
            if (srcType.isArray()) {
                SrcType componentType = srcType.getComponentType();
                this.addAnnotation(componentType, attr);
                continue;
            }
            if (this.isClassType(srcType)) {
                attrPos = attr.position;
                List<Object> list = attrLocation = attrPos == null ? List.nil() : attrPos.location;
                if (attrLocation.isEmpty()) {
                    this.addAnnotation(srcType, attr);
                    continue;
                }
                java.util.List<SrcType> typeArguments = srcType.getTypeParams();
                for (int i = 0; i < typeArguments.size(); ++i) {
                    SrcType typeParam = typeArguments.get(i);
                    if (i != ((TypeAnnotationPosition.TypePathEntry)attrLocation.get((int)0)).arg) continue;
                    List<Object> attrLocationCopy = List.from(attrLocation.subList(1, attrLocation.size()));
                    TypeAnnotationPosition posCopy = SrcClassUtil.getTypeAnnotationPosition(attrLocationCopy);
                    this.annotateType(typeParam, Collections.singletonList(new Attribute.TypeCompound(attr.type, attr.values, posCopy)));
                }
                continue;
            }
            if (!"?".equals(srcType.getName()) || srcType.getBounds().isEmpty()) continue;
            attrPos = attr.position;
            if (attrPos == null) {
                return;
            }
            attrLocation = attrPos.location;
            List<Object> attrLocationCopy = null;
            if (!attrLocation.isEmpty()) {
                attrLocationCopy = List.from(attrLocation.subList(1, attrLocation.size()));
            }
            if (attrLocationCopy == null || attrLocationCopy.isEmpty()) {
                this.addAnnotation(srcType, attr);
                continue;
            }
            TypeAnnotationPosition posCopy = SrcClassUtil.getTypeAnnotationPosition(attrLocationCopy);
            this.annotateType(srcType.getBounds().get(0), Collections.singletonList(new Attribute.TypeCompound(attr.type, attr.values, posCopy)));
        }
    }

    public static TypeAnnotationPosition getTypeAnnotationPosition(List<TypeAnnotationPosition.TypePathEntry> attrLocationCopy) {
        TypeAnnotationPosition posCopy;
        if (JreUtil.isJava8()) {
            posCopy = (TypeAnnotationPosition)ReflectUtil.constructor("com.sun.tools.javac.code.TypeAnnotationPosition", new Class[0]).newInstance(new Object[0]);
            ReflectUtil.field(posCopy, "location").set(attrLocationCopy);
        } else {
            posCopy = (TypeAnnotationPosition)ReflectUtil.method(TypeAnnotationPosition.class, "methodReceiver", List.class).invokeStatic(attrLocationCopy);
        }
        return posCopy;
    }

    private void addAnnotation(SrcType srcType, Attribute.TypeCompound attr) {
        String fqn = attr.type.toString();
        if (fqn.equals("jdk.internal.HotSpotIntrinsicCandidate")) {
            return;
        }
        SrcAnnotationExpression annoExpr = new SrcAnnotationExpression(fqn);
        for (Pair value : attr.values) {
            annoExpr.addArgument(((Symbol.MethodSymbol)value.fst).flatName().toString(), new SrcType(((Attribute)value.snd).type.toString()), ((Attribute)value.snd).getValue());
        }
        srcType.addAnnotation(annoExpr);
    }

    private boolean isClassType(SrcType srcType) {
        return !srcType.isPrimitive() && !srcType.isArray() && !"?".equals(srcType.getName());
    }

    private String genSuperCtorCall(IModule module, SrcClass srcClass, BasicJavacTask javacTask) {
        Symbol.MethodSymbol superCtor;
        SrcType superClass = srcClass.getSuperClass();
        String bodyStmt = superClass == null ? "" : ((superCtor = this.findConstructor(module, superClass.getFqName(), javacTask)) == null ? "" : this.genSuperCtorCall(superCtor));
        return bodyStmt;
    }

    private String genSuperCtorCall(Symbol.MethodSymbol superCtor) {
        StringBuilder sb = new StringBuilder("super(");
        java.util.List parameters = superCtor.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            Symbol.VarSymbol param = (Symbol.VarSymbol)((List)parameters).get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getValueForType(param.type));
        }
        sb.append(");");
        String bodyStmt = sb.toString();
        return bodyStmt;
    }

    private Symbol.MethodSymbol findConstructor(IModule module, String fqn, BasicJavacTask javacTask) {
        manifold.rt.api.util.Pair<Symbol.ClassSymbol, JCTree.JCCompilationUnit> classSymbol = ClassSymbols.instance(module).getClassSymbol(javacTask, fqn);
        Symbol.ClassSymbol cs = classSymbol.getFirst();
        Symbol.MethodSymbol ctor = null;
        for (Symbol sym : cs.getEnclosedElements()) {
            if (!(sym instanceof Symbol.MethodSymbol) || !sym.flatName().toString().equals("<init>") || !Modifier.isPublic((int)(ctor = ctor == null ? (Symbol.MethodSymbol)sym : this.mostAccessible(ctor, (Symbol.MethodSymbol)sym)).flags())) continue;
            return ctor;
        }
        return ctor;
    }

    private Symbol.MethodSymbol mostAccessible(Symbol.MethodSymbol ctor, Symbol.MethodSymbol sym) {
        int ctorMods = (int)ctor.flags();
        int symMods = (int)sym.flags();
        if (Modifier.isPublic(ctorMods)) {
            return ctor;
        }
        if (Modifier.isPublic(symMods)) {
            return sym;
        }
        if (Modifier.isProtected(ctorMods)) {
            return ctor;
        }
        if (Modifier.isProtected(symMods)) {
            return sym;
        }
        if (Modifier.isPrivate(ctorMods)) {
            return Modifier.isPrivate(symMods) ? ctor : sym;
        }
        return ctor;
    }

    private void addAnnotations(SrcAnnotated<?> srcAnnotated, Symbol symbol) {
        for (Attribute.Compound annotationMirror : symbol.getAnnotationMirrors()) {
            String fqn = annotationMirror.getAnnotationType().toString();
            if (fqn.equals("jdk.internal.HotSpotIntrinsicCandidate") || fqn.equals("android.annotation.Nullable") || fqn.equals("android.annotation.NonNull") || fqn.equals("androidx.annotation.RecentlyNullable") || fqn.equals("androidx.annotation.RecentlyNonNull")) continue;
            SrcAnnotationExpression annoExpr = new SrcAnnotationExpression(fqn);
            for (Pair<Symbol.MethodSymbol, Attribute> value : annotationMirror.values) {
                Type t = ((Attribute)value.snd).type;
                SrcType type = new SrcType(t.toString());
                if (t.tsym != null && t.tsym.isEnum()) {
                    type.setEnum(true);
                }
                annoExpr.addArgument(((Symbol.MethodSymbol)value.fst).flatName().toString(), type, ((Attribute)value.snd).getValue());
            }
            srcAnnotated.addAnnotation(annoExpr);
        }
    }

    private SrcType makeTypeVarType(Symbol.TypeVariableSymbol typeVar) {
        StringBuilder sb = new StringBuilder(typeVar.type.toString());
        Type lowerBound = typeVar.type.getLowerBound();
        if (lowerBound != null && !(lowerBound instanceof NullType)) {
            sb.append(" super ").append(lowerBound.toString());
        } else {
            Type upperBound = typeVar.type.getUpperBound();
            if (upperBound != null && !(upperBound instanceof NoType) && !upperBound.toString().equals(Object.class.getName())) {
                sb.append(" extends ").append(upperBound.toString());
            }
        }
        return new SrcType(sb.toString());
    }

    private String getValueForType(Type type) {
        String value;
        block11: {
            block10: {
                if (!type.isPrimitive()) break block10;
                switch (type.getKind()) {
                    case BOOLEAN: {
                        value = "(boolean)Boolean.valueOf(true)";
                        break block11;
                    }
                    case BYTE: {
                        value = "(byte)Byte.valueOf((byte)0)";
                        break block11;
                    }
                    case SHORT: {
                        value = "(short)Short.valueOf((short)0)";
                        break block11;
                    }
                    case INT: {
                        value = "(int)Integer.valueOf(0)";
                        break block11;
                    }
                    case LONG: {
                        value = "(long)Long.valueOf(0)";
                        break block11;
                    }
                    case CHAR: {
                        value = "(char)Character.valueOf((char)0)";
                        break block11;
                    }
                    case FLOAT: {
                        value = "(float)Float.valueOf(0f)";
                        break block11;
                    }
                    case DOUBLE: {
                        value = "(double)Double.valueOf(0d)";
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            String fqn = type.toString();
            value = "(" + fqn + ")null";
        }
        return value;
    }
}

