/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.LambdaToMethod;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RichDiagnosticFormatter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.ManResolve;
import manifold.internal.javac.ManTransTypes;
import manifold.internal.javac.SrcClassUtil;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class ManTypes
extends Types {
    private static final String TYPES_FIELD = "types";
    private static final String SELF_TYPE_NAME = "manifold.ext.rt.api.Self";
    private final Symtab _syms;
    private final Attr _attr;
    private final ManTransTypes _transTypes;
    private int _overrideCount;

    public static Types instance(Context ctx) {
        Types types = (Types)ctx.get(typesKey);
        if (!(types instanceof ManTypes)) {
            ctx.put(typesKey, (Types)null);
            types = new ManTypes(ctx);
        }
        return types;
    }

    private ManTypes(Context ctx) {
        super(ctx);
        this._attr = Attr.instance(ctx);
        this._syms = Symtab.instance(ctx);
        this._transTypes = (ManTransTypes)TransTypes.instance(ctx);
        if (JreUtil.isJava8()) {
            this.reassignEarlyHolders8(ctx);
        } else {
            this.reassignEarlyHolders(ctx);
        }
    }

    private void reassignEarlyHolders8(Context context) {
        ReflectUtil.field(Annotate.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Attr.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Check.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(DeferredAttr.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Flow.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Gen.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Infer.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavaCompiler.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacTrees.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacTypes.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacElements.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(LambdaToMethod.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Lower.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ManResolve.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(MemberEnter.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(RichDiagnosticFormatter.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(TransTypes.instance(context), TYPES_FIELD).set(this);
    }

    private void reassignEarlyHolders(Context context) {
        ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Analyzer"), "instance", Context.class).invokeStatic(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Annotate.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Attr.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Check.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(DeferredAttr.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Flow.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Gen.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Infer.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavaCompiler.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacElements.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacProcessingEnvironment.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacTrees.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(JavacTypes.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(LambdaToMethod.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(Lower.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ManResolve.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(MemberEnter.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Modules"), "instance", Context.class).invokeStatic(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Operators"), "instance", Context.class).invokeStatic(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.jvm.StringConcat"), "instance", Context.class).invokeStatic(context), TYPES_FIELD).set(this);
        ReflectUtil.field(RichDiagnosticFormatter.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(TransTypes.instance(context), TYPES_FIELD).set(this);
        ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.TypeEnter"), "instance", Context.class).invokeStatic(context), TYPES_FIELD).set(this);
        ReflectUtil.field(TreeMaker.instance(context), TYPES_FIELD).set(this);
    }

    @Override
    public Type memberType(Type qualifier, Symbol memberSym) {
        Type memberType = super.memberType(qualifier, memberSym);
        if (memberSym.isStatic() || memberType.tsym.type instanceof Type.ErrorType) {
            return memberType;
        }
        if (this._overrideCount > 0 || this._transTypes.isTranslating()) {
            return memberType;
        }
        JCTree.JCMethodDecl methodDef = ((ManAttr)((Object)this._attr)).peekMethodDef();
        if (this.isSameMethodSym(memberSym, methodDef)) {
            return memberType;
        }
        if (memberSym.getEnclosingElement().type.equals(qualifier)) {
            return memberType;
        }
        java.util.List<TypeAnnotationPosition> selfPos = this.findSelfAnnotationLocation(memberSym);
        if (selfPos != null) {
            if (qualifier instanceof Type.ArrayType && this.isSelfComponentType(memberSym)) {
                qualifier = ((Type.ArrayType)qualifier).getComponentType();
            }
            memberType = this.replaceSelfTypesWithQualifier(qualifier, memberType, selfPos);
        }
        return memberType;
    }

    private boolean isSameMethodSym(Symbol memberSym, JCTree.JCMethodDecl methodDef) {
        return methodDef != null && methodDef.sym != null && this.isSameType(this.erasure(methodDef.sym.type), this.erasure(memberSym.type));
    }

    private java.util.List<TypeAnnotationPosition> findSelfAnnotationLocation(Symbol sym) {
        if (sym == null) {
            return null;
        }
        SymbolMetadata metadata = sym.getMetadata();
        if (metadata == null || metadata.isTypesEmpty()) {
            return null;
        }
        List<Attribute.TypeCompound> typeAttributes = metadata.getTypeAttributes();
        if (typeAttributes.isEmpty()) {
            return null;
        }
        return typeAttributes.stream().filter(attr -> attr.type.toString().equals(SELF_TYPE_NAME)).map((Function<Attribute.TypeCompound, TypeAnnotationPosition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPosition(), (Lcom/sun/tools/javac/code/Attribute$TypeCompound;)Lcom/sun/tools/javac/code/TypeAnnotationPosition;)()).collect(Collectors.toList());
    }

    private boolean isSelfComponentType(Symbol sym) {
        if (sym == null) {
            return false;
        }
        SymbolMetadata metadata = sym.getMetadata();
        if (metadata == null || metadata.isTypesEmpty()) {
            return false;
        }
        List<Attribute.TypeCompound> typeAttributes = metadata.getTypeAttributes();
        if (typeAttributes.isEmpty()) {
            return false;
        }
        return typeAttributes.stream().anyMatch(attr -> attr.type.toString().equals(SELF_TYPE_NAME) && !attr.values.isEmpty() && (Boolean)((Attribute)((Pair)attr.values.head).snd).getValue() != false);
    }

    private Type replaceSelfTypesWithQualifier(Type receiverType, Type type, java.util.List<TypeAnnotationPosition> selfPosList) {
        List<TypeAnnotationPosition.TypePathEntry> selfLocation;
        TypeAnnotationPosition selfPos;
        if (JreUtil.isJava8() && (type.getClass().getTypeName().equals("com.sun.tools.javac.code.Type.AnnotatedType") || type.getClass().getTypeName().equals("com.sun.tools.javac.code.Type$AnnotatedType"))) {
            Type unannotatedType = (Type)ReflectUtil.method(type, "unannotatedType", new Class[0]).invoke(new Object[0]);
            for (Attribute.TypeCompound anno : type.getAnnotationMirrors()) {
                if (!anno.type.toString().equals(SELF_TYPE_NAME)) continue;
                Type newType = unannotatedType instanceof Type.ArrayType ? this.makeArray(unannotatedType, receiverType) : receiverType;
                return newType;
            }
            return this.replaceSelfTypesWithQualifier(receiverType, unannotatedType, selfPosList);
        }
        if (type instanceof Type.ArrayType && (this.hasSelfType(type) || selfPosList != null)) {
            Type componentType = ((Type.ArrayType)type).getComponentType();
            if (componentType instanceof Type.ClassType) {
                return new Type.ArrayType(receiverType, this._syms.arrayClass);
            }
            return new Type.ArrayType(this.replaceSelfTypesWithQualifier(receiverType, componentType, selfPosList), this._syms.arrayClass);
        }
        if (type instanceof Type.ClassType) {
            if (selfPosList.isEmpty()) {
                return type;
            }
            selfPos = selfPosList.remove(0);
            if (selfPos.location == null || selfPos.location.isEmpty()) {
                return receiverType;
            }
            selfLocation = selfPos.location;
            TypeAnnotationPosition.TypePathEntry loc = selfLocation.get(0);
            List<TypeAnnotationPosition.TypePathEntry> selfLocationCopy = List.from(selfLocation.subList(1, selfLocation.size()));
            if (loc == TypeAnnotationPosition.TypePathEntry.INNER_TYPE) {
                return receiverType;
            }
            boolean replaced = false;
            ArrayList<Type> newParams = new ArrayList<Type>();
            List<Type> typeArguments = type.getTypeArguments();
            for (int i = 0; i < typeArguments.size(); ++i) {
                Type typeParam = typeArguments.get(i);
                if (i == loc.arg) {
                    if (selfLocationCopy.isEmpty()) {
                        typeParam = receiverType = this.boxedTypeOrType(receiverType);
                    } else {
                        TypeAnnotationPosition posCopy = SrcClassUtil.getTypeAnnotationPosition(selfLocationCopy);
                        posCopy.location = selfLocationCopy;
                        typeParam = this.replaceSelfTypesWithQualifier(receiverType, typeParam, this.singleMutable(posCopy));
                    }
                    replaced = true;
                }
                newParams.add(typeParam);
            }
            if (replaced) {
                return this.replaceSelfTypesWithQualifier(receiverType, new Type.ClassType(type.getEnclosingType(), List.from(newParams), type.tsym), selfPosList);
            }
        }
        if (type instanceof Type.MethodType || type instanceof Type.ForAll) {
            Type retType;
            Type newRetType;
            if (selfPosList.isEmpty()) {
                return type;
            }
            selfPos = selfPosList.remove(0);
            if (selfPos.type == TargetType.METHOD_FORMAL_PARAMETER) {
                selfLocation = selfPos.location;
                List<TypeAnnotationPosition.TypePathEntry> selfLocationCopy = selfLocation == null || selfLocation.isEmpty() ? null : List.from(selfLocation.subList(0, selfLocation.size()));
                boolean replacedParams = false;
                ArrayList<Type> newParams = new ArrayList<Type>();
                List<Type> paramTypes = type.getParameterTypes();
                for (int i = 0; i < paramTypes.size(); ++i) {
                    Type paramType = paramTypes.get(i);
                    if (i == selfPos.parameter_index) {
                        if (selfLocationCopy == null || selfLocationCopy.isEmpty()) {
                            paramType = receiverType;
                        } else {
                            TypeAnnotationPosition posCopy = SrcClassUtil.getTypeAnnotationPosition(selfLocationCopy);
                            posCopy.location = selfLocationCopy;
                            paramType = this.replaceSelfTypesWithQualifier(receiverType, paramType, this.singleMutable(posCopy));
                        }
                        replacedParams = true;
                    }
                    newParams.add(paramType);
                }
                if (replacedParams) {
                    if (type instanceof Type.ForAll) {
                        return this.replaceSelfTypesWithQualifier(receiverType, new Type.ForAll(((Type.ForAll)type).tvars, (Type)new Type.MethodType(List.from(newParams), type.getReturnType(), type.getThrownTypes(), type.tsym)), selfPosList);
                    }
                    return this.replaceSelfTypesWithQualifier(receiverType, new Type.MethodType(List.from(newParams), type.getReturnType(), type.getThrownTypes(), type.tsym), selfPosList);
                }
            } else if (selfPos.type == TargetType.METHOD_RETURN && (newRetType = this.replaceSelfTypesWithQualifier(receiverType, retType = type.getReturnType(), this.singleMutable(selfPos))) != retType) {
                if (type instanceof Type.ForAll) {
                    return this.replaceSelfTypesWithQualifier(receiverType, new Type.ForAll(((Type.ForAll)type).tvars, (Type)new Type.MethodType(type.getParameterTypes(), newRetType, type.getThrownTypes(), type.tsym)), selfPosList);
                }
                return this.replaceSelfTypesWithQualifier(receiverType, new Type.MethodType(type.getParameterTypes(), newRetType, type.getThrownTypes(), type.tsym), selfPosList);
            }
        }
        if (type instanceof Type.WildcardType) {
            if (selfPosList.isEmpty()) {
                return type;
            }
            selfPos = selfPosList.remove(0);
            List<TypeAnnotationPosition.TypePathEntry> selfLocationCopy = List.from(selfPos.location.subList(1, selfPos.location.size()));
            TypeAnnotationPosition posCopy = SrcClassUtil.getTypeAnnotationPosition(selfLocationCopy);
            posCopy.location = selfLocationCopy;
            Type newType = this.replaceSelfTypesWithQualifier(receiverType, ((Type.WildcardType)type).type, this.singleMutable(posCopy));
            return this.replaceSelfTypesWithQualifier(receiverType, new Type.WildcardType(newType, ((Type.WildcardType)type).kind, this._syms.boundClass), selfPosList);
        }
        return type;
    }

    private java.util.List<TypeAnnotationPosition> singleMutable(TypeAnnotationPosition posCopy) {
        ArrayList<TypeAnnotationPosition> single = new ArrayList<TypeAnnotationPosition>();
        single.add(posCopy);
        return single;
    }

    private boolean hasSelfType(Type type) {
        for (Attribute.TypeCompound anno : type.getAnnotationMirrors()) {
            if (!anno.type.toString().equals(SELF_TYPE_NAME)) continue;
            return true;
        }
        if (type instanceof Type.ArrayType) {
            return this.hasSelfType(((Type.ArrayType)type).getComponentType());
        }
        for (Type typeParam : type.getTypeArguments()) {
            if (!this.hasSelfType(typeParam)) continue;
            return true;
        }
        if (type instanceof Type.IntersectionClassType) {
            for (Type compType : ((Type.IntersectionClassType)type).getComponents()) {
                if (!this.hasSelfType(compType)) continue;
                return true;
            }
        }
        return false;
    }

    private Type makeArray(Type unannotatedType, Type receiverType) {
        if (unannotatedType instanceof Type.ArrayType) {
            return this.makeArray(((Type.ArrayType)unannotatedType).getComponentType(), new Type.ArrayType(receiverType, this._syms.arrayClass));
        }
        return receiverType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol.MethodSymbol implementation(Symbol.MethodSymbol ms, Symbol.TypeSymbol origin, boolean checkResult, Filter<Symbol> implFilter) {
        ++this._overrideCount;
        try {
            Symbol.MethodSymbol methodSymbol = super.implementation(ms, origin, checkResult, implFilter);
            return methodSymbol;
        }
        finally {
            --this._overrideCount;
        }
    }
}

