/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Analyzer;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.comp.TypeEnter;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import manifold.api.type.FragmentValue;
import manifold.api.type.ISelfCompiledFile;
import manifold.internal.javac.FragmentProcessor;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.ManLog_9;
import manifold.internal.javac.ManParserFactory;
import manifold.internal.javac.ManResolve;
import manifold.rt.api.util.Stack;
import manifold.util.ReflectUtil;

public class ManAttr_9
extends Attr
implements ManAttr {
    private final ManLog_9 _manLog;
    private final Symtab _syms;
    private Stack<JCTree.JCFieldAccess> _selects = new Stack();
    private Stack<JCTree.JCAnnotatedType> _annotatedTypes = new Stack();
    private Stack<JCTree.JCMethodDecl> _methodDefs = new Stack();

    public static ManAttr_9 instance(Context ctx) {
        Attr attr = (Attr)ctx.get(attrKey);
        if (!(attr instanceof ManAttr_9)) {
            ctx.put(attrKey, (Attr)null);
            attr = new ManAttr_9(ctx);
        }
        return (ManAttr_9)attr;
    }

    private ManAttr_9(Context ctx) {
        super(ctx);
        this._syms = Symtab.instance(ctx);
        this._manLog = (ManLog_9)ManLog_9.instance(ctx);
        ReflectUtil.field(this, "log").set(this._manLog);
        ReflectUtil.field(this, "rs").set(ManResolve.instance(ctx));
        this.reassignAllEarlyHolders(ctx);
    }

    private void reassignAllEarlyHolders(Context ctx) {
        Object[] earlyAttrHolders;
        for (Object instance : earlyAttrHolders = new Object[]{Modules.instance(ctx), Resolve.instance(ctx), DeferredAttr.instance(ctx), ArgumentAttr.instance(ctx), MemberEnter.instance(ctx), TypeEnter.instance(ctx), Analyzer.instance(ctx), Lower.instance(ctx), TransTypes.instance(ctx), Annotate.instance(ctx), TypeAnnotations.instance(ctx), JavacTrees.instance(ctx), JavaCompiler.instance(ctx)}) {
            ReflectUtil.LiveFieldRef attr = ReflectUtil.WithNull.field(instance, "attr");
            if (attr == null) continue;
            attr.set(this);
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        this._methodDefs.push(tree);
        try {
            super.visitMethodDef(tree);
        }
        finally {
            this._methodDefs.pop();
        }
    }

    @Override
    public JCTree.JCMethodDecl peekMethodDef() {
        return this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this._selects.push(tree);
        try {
            super.visitSelect(tree);
        }
        finally {
            this._selects.pop();
        }
    }

    private boolean shouldCheckSuperType(Type type) {
        return this._shouldCheckSuperType(type, true);
    }

    private boolean _shouldCheckSuperType(Type type, boolean checkSuper) {
        return type instanceof Type.ClassType && type != Type.noType && !(type instanceof Type.ErrorType) && !type.toString().equals(Object.class.getTypeName()) && (!checkSuper || this._shouldCheckSuperType(((Symbol.ClassSymbol)type.tsym).getSuperclass(), false));
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        this._annotatedTypes.push(tree);
        try {
            super.visitAnnotatedType(tree);
        }
        finally {
            this._annotatedTypes.pop();
        }
    }

    @Override
    public JCTree.JCFieldAccess peekSelect() {
        return this._selects.isEmpty() ? null : this._selects.peek();
    }

    @Override
    public JCTree.JCAnnotatedType peekAnnotatedType() {
        return this._annotatedTypes.isEmpty() ? null : this._annotatedTypes.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        if (!(tree.meth instanceof JCTree.JCFieldAccess)) {
            super.visitApply(tree);
            this.patchMethodType(tree);
            return;
        }
        this._manLog.pushSuspendIssues(tree);
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)tree.meth;
        try {
            super.visitApply(tree);
            this.patchMethodType(tree);
            if (fieldAccess.type instanceof Type.ErrorType) {
                if (this.shouldCheckSuperType(fieldAccess.selected.type) && this._manLog.isJailbreakSelect(fieldAccess)) {
                    Type.ClassType oldType = (Type.ClassType)fieldAccess.selected.type;
                    ((JCTree.JCIdent)fieldAccess.selected).sym.type = fieldAccess.selected.type = ((Symbol.ClassSymbol)oldType.tsym).getSuperclass();
                    fieldAccess.type = null;
                    fieldAccess.sym = null;
                    tree.type = null;
                    this.visitApply(tree);
                    ((JCTree.JCIdent)fieldAccess.selected).sym.type = fieldAccess.selected.type = oldType;
                }
            } else {
                this._manLog.recordRecentSuspendedIssuesAndRemoveOthers(tree);
            }
        }
        finally {
            this._manLog.popSuspendIssues(tree);
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        if (!JavacPlugin.instance().isExtensionsEnabled()) {
            super.visitBinary(tree);
            return;
        }
        if (tree.getTag() == JCTree.Tag.APPLY) {
            this.visitBindingExpression(tree);
            ReflectUtil.field(tree, "opcode").set((Object)JCTree.Tag.MUL);
            return;
        }
        ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
        ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
        Type left = (Type)checkNonVoid.invoke(tree.lhs.pos(), attribExpr.invoke(tree.lhs, this.getEnv()));
        Type right = (Type)checkNonVoid.invoke(tree.lhs.pos(), attribExpr.invoke(tree.rhs, this.getEnv()));
        if (this.handleOperatorOverloading(tree, left, right)) {
            return;
        }
        this._visitBinary_Rest(tree, left, right);
    }

    private void _visitBinary_Rest(JCTree.JCBinary tree, Type left, Type right) {
        Operators operators = Operators.instance(JavacPlugin.instance().getContext());
        Symbol.OperatorSymbol operator = tree.operator = (Symbol.OperatorSymbol)ReflectUtil.method(operators, "resolveBinary", JCDiagnostic.DiagnosticPosition.class, JCTree.Tag.class, Type.class, Type.class).invoke(new Object[]{tree.pos(), tree.getTag(), left, right});
        Type owntype = this.types().createErrorType(tree.type);
        if (operator != operators.noOpSymbol && !left.isErroneous() && !right.isErroneous()) {
            Type ctype;
            owntype = operator.type.getReturnType();
            int opc = operator.opcode;
            if (left.constValue() != null && right.constValue() != null && (ctype = (Type)ReflectUtil.method(this.cfolder(), "fold2", Integer.TYPE, Type.class, Type.class).invoke(opc, left, right)) != null) {
                owntype = (Type)ReflectUtil.method(this.cfolder(), "coerce", Type.class, Type.class).invoke(ctype, owntype);
            }
            if (!(opc != 165 && opc != 166 || this.types().isCastable(left, right, new Warner(tree.pos())))) {
                this.getLogger().error(tree.pos(), CompilerProperties.Errors.IncomparableTypes(left, right));
            }
            ReflectUtil.method(this.chk(), "checkDivZero", JCDiagnostic.DiagnosticPosition.class, Symbol.class, Type.class).invoke(tree.rhs.pos(), operator, right);
        }
        this.setResult(tree, owntype);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        if (!JavacPlugin.instance().isExtensionsEnabled()) {
            super.visitUnary(tree);
            return;
        }
        if (this.handleNegationOverloading(tree)) {
            return;
        }
        super.visitUnary(tree);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        if (tree.typetag == TypeTag.CLASS && tree.value.toString().startsWith("[>")) {
            Type type;
            tree.type = type = this.getFragmentValueType(tree);
            ReflectUtil.field(this, "result").set(type);
        } else {
            super.visitLiteral(tree);
        }
    }

    private Type getFragmentValueType(JCTree.JCLiteral tree) {
        try {
            CharSequence source = ManParserFactory.getSource(this.getEnv().toplevel.sourcefile);
            CharSequence chars = source.subSequence(tree.pos().getStartPosition(), tree.pos().getEndPosition(this.getEnv().toplevel.endPositions));
            FragmentProcessor.Fragment fragment = FragmentProcessor.instance().parseFragment(tree.pos().getStartPosition(), chars.toString(), chars.length() > 3 && chars.charAt(1) == '\"' ? HostKind.TEXT_BLOCK_LITERAL : HostKind.DOUBLE_QUOTE_LITERAL);
            if (fragment != null) {
                String fragClass = this.getEnv().toplevel.packge.toString() + '.' + fragment.getName();
                Symbol.ClassSymbol fragSym = IDynamicJdk.instance().getTypeElement(JavacPlugin.instance().getContext(), this.getEnv().toplevel, fragClass);
                for (Attribute.Compound annotation : fragSym.getAnnotationMirrors()) {
                    Type type;
                    if (!annotation.type.toString().equals(FragmentValue.class.getName()) || (type = this.getFragmentValueType(annotation)) == null) continue;
                    return type;
                }
                this.getLogger().rawWarning(tree.pos().getStartPosition(), "No @" + FragmentValue.class.getSimpleName() + " is provided for metatype '" + fragment.getExt() + "'. The resulting value remains a String literal.");
            }
        }
        catch (Exception e) {
            this.getLogger().rawWarning(tree.pos().getStartPosition(), "Error parsing Manifold fragment.\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\n" + (e.getStackTrace().length > 0 ? e.getStackTrace()[0].toString() : ""));
        }
        return this._syms.stringType.constType(tree.value);
    }

    private Type getFragmentValueType(Attribute.Compound attribute) {
        Symbol.ClassSymbol fragValueSym;
        String type = null;
        for (Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (!((Name)argName).toString().equals("type")) continue;
            type = (String)((Attribute)pair.snd).getValue();
        }
        if (type != null && (fragValueSym = IDynamicJdk.instance().getTypeElement(JavacPlugin.instance().getContext(), this.getEnv().toplevel, type)) != null) {
            return fragValueSym.type;
        }
        return null;
    }

    @Override
    public void attribClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        String fqn;
        ISelfCompiledFile sourcefile;
        if (c.sourcefile instanceof ISelfCompiledFile && (sourcefile = (ISelfCompiledFile)((Object)c.sourcefile)).isSelfCompile(fqn = c.getQualifiedName().toString())) {
            sourcefile.parse(fqn);
        }
        super.attribClass(pos, c);
    }
}

