/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import manifold.internal.javac.AbstractBinder;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacBinder;
import manifold.internal.javac.OverloadOperatorSymbol;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public interface ManAttr {
    public static final boolean JAILBREAK_PRIVATE_FROM_SUPERS = true;
    public static final String COMPARE_TO = "compareTo";
    public static final String COMPARE_TO_USING = "compareToUsing";
    public static final String UNARY_MINUS = "unaryMinus";
    public static final Map<JCTree.Tag, String> BINARY_OP_TO_NAME = new HashMap<JCTree.Tag, String>(){
        {
            this.put(JCTree.Tag.PLUS, "plus");
            this.put(JCTree.Tag.MINUS, "minus");
            this.put(JCTree.Tag.MUL, "times");
            this.put(JCTree.Tag.DIV, "div");
            this.put(JCTree.Tag.MOD, "rem");
        }
    };

    public JCTree.JCMethodDecl peekMethodDef();

    public JCTree.JCFieldAccess peekSelect();

    public JCTree.JCAnnotatedType peekAnnotatedType();

    default public Env getEnv() {
        return (Env)ReflectUtil.field(this, "env").get();
    }

    default public Log getLogger() {
        return (Log)ReflectUtil.field(this, "log").get();
    }

    default public Check chk() {
        return (Check)ReflectUtil.field(this, "chk").get();
    }

    default public Resolve rs() {
        return (Resolve)ReflectUtil.field(this, "rs").get();
    }

    default public Types types() {
        return (Types)ReflectUtil.field(this, "types").get();
    }

    default public Object cfolder() {
        return ReflectUtil.field(this, "cfolder").get();
    }

    default public Symtab syms() {
        return (Symtab)ReflectUtil.field(this, "syms").get();
    }

    default public void patchMethodType(JCTree.JCMethodInvocation tree) {
        if (tree.meth.type == null) {
            Symbol sym;
            if (tree.meth instanceof JCTree.JCIdent) {
                Symbol sym2 = ((JCTree.JCIdent)tree.meth).sym;
                if (sym2 != null) {
                    tree.meth.type = sym2.type;
                }
            } else if (tree.meth instanceof JCTree.JCFieldAccess && (sym = ((JCTree.JCFieldAccess)tree.meth).sym) != null) {
                tree.meth.type = sym.type;
            }
        }
    }

    default public boolean handleOperatorOverloading(JCTree.JCBinary tree, Type left, Type right) {
        boolean swapped = false;
        Symbol.MethodSymbol overloadOperator = ManAttr.resolveOperatorMethod(this.types(), tree.getTag(), left, right);
        if (overloadOperator == null && ManAttr.isCommutative(tree.getTag())) {
            overloadOperator = ManAttr.resolveOperatorMethod(this.types(), tree.getTag(), right, left);
            swapped = true;
        }
        if (overloadOperator != null) {
            if (overloadOperator.name.toString().equals(COMPARE_TO)) {
                Type.MethodType typePoseWithBooleanReturn = new Type.MethodType(overloadOperator.type.getParameterTypes(), this.syms().booleanType, overloadOperator.type.getThrownTypes(), this.syms().methodClass);
                overloadOperator = new OverloadOperatorSymbol(overloadOperator, typePoseWithBooleanReturn, swapped);
            } else {
                overloadOperator = new OverloadOperatorSymbol(overloadOperator, swapped);
            }
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)overloadOperator);
            Type owntype = overloadOperator.type.isErroneous() ? overloadOperator.type : (swapped ? this.types().memberType(right, overloadOperator).getReturnType() : this.types().memberType(left, overloadOperator).getReturnType());
            this.setResult(tree, owntype);
            return true;
        }
        return false;
    }

    default public boolean handleNegationOverloading(JCTree.JCUnary tree) {
        if (tree.getTag() != JCTree.Tag.NEG) {
            return false;
        }
        ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
        ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
        Type expr = (Type)checkNonVoid.invoke(tree.arg.pos(), attribExpr.invoke(tree.arg, this.getEnv()));
        Symbol.MethodSymbol overloadOperator = ManAttr.resolveNegationMethod(this.types(), tree.getTag(), expr);
        if (overloadOperator != null) {
            overloadOperator = new OverloadOperatorSymbol(overloadOperator, false);
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)overloadOperator);
            Type owntype = overloadOperator.type.isErroneous() ? overloadOperator.type : this.types().memberType(expr, overloadOperator).getReturnType();
            this.setResult(tree, owntype);
            return true;
        }
        return false;
    }

    default public void visitBindingExpression(JCTree.JCBinary tree) {
        Type owntype;
        if (IDynamicJdk.instance().getOperator(tree) == null) {
            JCTree.JCBinary newTree = (JCTree.JCBinary)new JavacBinder(this.types()).bind(this.getBindingOperands(tree, new ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>>()));
            if (newTree == null) {
                this.getLogger().error(tree.lhs.pos, "proc.messager", "No reaction defined for types '" + tree.lhs.type + "' and '" + tree.rhs.type + "'");
                return;
            }
            ReflectUtil.field(tree, "opcode").set(ReflectUtil.field(newTree, "opcode").get());
            tree.lhs = newTree.lhs;
            tree.rhs = newTree.rhs;
            tree.type = newTree.type;
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)IDynamicJdk.instance().getOperator(newTree));
            owntype = newTree.type;
        } else {
            Symbol operator = IDynamicJdk.instance().getOperator(tree);
            owntype = operator.type.isErroneous() ? operator.type : operator.type.getReturnType();
        }
        this.setResult(tree, owntype);
    }

    default public void setResult(JCTree.JCExpression tree, Type owntype) {
        if (JreUtil.isJava8()) {
            Object VAL = ReflectUtil.field("com.sun.tools.javac.code.Kinds", "VAL").getStatic();
            ReflectUtil.field(this, "result").set(ReflectUtil.method(this, "check", JCTree.class, Type.class, Integer.TYPE, ReflectUtil.type(Attr.class.getTypeName() + "$ResultInfo")).invoke(tree, owntype, VAL, ReflectUtil.field(this, "resultInfo").get()));
        } else {
            Class<?> kindSelectorClass = ReflectUtil.type("com.sun.tools.javac.code.Kinds$KindSelector");
            Object VAL = ReflectUtil.field(kindSelectorClass, "VAL").getStatic();
            ReflectUtil.field(this, "result").set(ReflectUtil.method(this, "check", JCTree.class, Type.class, kindSelectorClass, ReflectUtil.type(Attr.class.getTypeName() + "$ResultInfo")).invoke(tree, owntype, VAL, ReflectUtil.field(this, "resultInfo").get()));
        }
    }

    default public ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>> getBindingOperands(JCTree.JCExpression tree, ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>> operands) {
        if (tree instanceof JCTree.JCBinary && tree.getTag() == JCTree.Tag.APPLY) {
            this.getBindingOperands(((JCTree.JCBinary)tree).lhs, operands);
            this.getBindingOperands(((JCTree.JCBinary)tree).rhs, operands);
        } else if (tree instanceof JCTree.JCBinary) {
            JCTree.JCBinary binExpr = (JCTree.JCBinary)tree;
            JCTree.Tag opcode = (JCTree.Tag)((Object)ReflectUtil.field(tree, "opcode").get());
            this.getBindingOperands(binExpr.lhs, operands);
            int index = operands.size();
            this.getBindingOperands(binExpr.rhs, operands);
            AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> rhsNode = operands.get(index);
            rhsNode._operatorLeft = opcode;
        } else {
            ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
            ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
            checkNonVoid.invoke(tree.pos(), attribExpr.invoke(tree, this.getEnv()));
            operands.add(new AbstractBinder.Node(tree));
        }
        return operands;
    }

    public static Symbol.MethodSymbol resolveNegationMethod(Types types, JCTree.Tag tag, Type expr) {
        if (expr instanceof Type.TypeVar) {
            expr = types.erasure(expr);
        }
        if (!(expr.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return ManAttr.getMethodSymbol(types, expr, null, UNARY_MINUS, (Symbol.ClassSymbol)expr.tsym, 0);
    }

    public static Symbol.MethodSymbol resolveOperatorMethod(Types types, JCTree.Tag tag, Type left, Type right) {
        String opName = BINARY_OP_TO_NAME.get((Object)tag);
        if (opName == null) {
            if (ManAttr.isComparableOperator(tag)) {
                opName = COMPARE_TO_USING;
            } else {
                return null;
            }
        }
        if (left instanceof Type.TypeVar) {
            left = types.erasure(left);
        }
        if (!(left.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        int paramCount = opName.equals(COMPARE_TO_USING) ? 2 : 1;
        Symbol.MethodSymbol methodSymbol = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)left.tsym, paramCount);
        if (methodSymbol == null && paramCount == 2 && !left.isPrimitive() && ManAttr.isRelationalOperator(tag)) {
            methodSymbol = ManAttr.getMethodSymbol(types, left, right, COMPARE_TO, (Symbol.ClassSymbol)left.tsym, 1);
        }
        return methodSymbol;
    }

    public static Symbol.MethodSymbol getMethodSymbol(Types types, Type left, Type right, String opName, Symbol.ClassSymbol sym, int paramCount) {
        Symbol.MethodSymbol methodSymbol = ManAttr.getMethodSymbol(types, left, right, opName, sym, paramCount, (t1, t2) -> types.isSameType((Type)t1, (Type)t2));
        if (methodSymbol != null) {
            return methodSymbol;
        }
        return ManAttr.getMethodSymbol(types, left, right, opName, sym, paramCount, (t1, t2) -> types.isAssignable((Type)t1, (Type)t2) || ManAttr.isAssignableWithGenerics(types, t1, t2));
    }

    public static boolean isAssignableWithGenerics(Types types, Type t1, Type t2) {
        if (t2 instanceof Type.TypeVar) {
            Type parameterizedParamType = types.asSuper(t1, t2.getUpperBound().tsym);
            return parameterizedParamType != null;
        }
        return false;
    }

    public static Symbol.MethodSymbol getMethodSymbol(Types types, Type left, Type right, String opName, Symbol.ClassSymbol sym, int paramCount, BiPredicate<Type, Type> matcher) {
        Symbol.MethodSymbol m;
        if (sym == null) {
            return null;
        }
        for (Symbol member : IDynamicJdk.instance().getMembers(sym, (Filter<Symbol>)((Filter)e -> e instanceof Symbol.MethodSymbol))) {
            Symbol.MethodSymbol m2 = (Symbol.MethodSymbol)member;
            if (ManAttr.isSynthetic(m2) || m2.params().size() != paramCount || !opName.equals(((Name)m2.getSimpleName()).toString())) continue;
            if (paramCount == 0) {
                return m2;
            }
            Type parameterizedMethod = types.memberType(left, m2);
            while (parameterizedMethod instanceof Type.ForAll) {
                parameterizedMethod = parameterizedMethod.asMethodType();
            }
            if (!matcher.test(right, parameterizedMethod.getParameterTypes().get(0))) continue;
            return m2;
        }
        Type superclass = sym.getSuperclass();
        if (superclass != null && (m = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)superclass.tsym, paramCount, matcher)) != null) {
            return m;
        }
        for (Type iface : sym.getInterfaces()) {
            Symbol.MethodSymbol m3 = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)iface.tsym, paramCount, matcher);
            if (m3 == null) continue;
            return m3;
        }
        return null;
    }

    public static boolean isSynthetic(Symbol.MethodSymbol m) {
        return (m.flags() & 0x1000L) != 0L || (m.flags() & 0x80000000L) != 0L;
    }

    public static boolean isComparableOperator(JCTree.Tag tag) {
        return tag == JCTree.Tag.EQ || tag == JCTree.Tag.NE || tag == JCTree.Tag.LT || tag == JCTree.Tag.LE || tag == JCTree.Tag.GT || tag == JCTree.Tag.GE;
    }

    public static boolean isRelationalOperator(JCTree.Tag tag) {
        return tag == JCTree.Tag.LT || tag == JCTree.Tag.LE || tag == JCTree.Tag.GT || tag == JCTree.Tag.GE;
    }

    public static boolean isCommutative(JCTree.Tag tag) {
        return tag == JCTree.Tag.PLUS || tag == JCTree.Tag.MUL || tag == JCTree.Tag.BITOR || tag == JCTree.Tag.BITXOR || tag == JCTree.Tag.BITAND || tag == JCTree.Tag.EQ || tag == JCTree.Tag.NE;
    }
}

