/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import manifold.internal.javac.AbstractBinder;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.OverloadOperatorSymbol;
import manifold.rt.api.util.Pair;

class JavacBinder
extends AbstractBinder<Symbol.MethodSymbol, JCTree.JCBinary, JCTree.JCExpression, JCTree.Tag> {
    private final Map<Pair<Type, Type>, Symbol.MethodSymbol> _mapReactions = new HashMap<Pair<Type, Type>, Symbol.MethodSymbol>();
    private final Types _types;
    private final TreeMaker _make;

    JavacBinder(Types types) {
        this._types = types;
        this._make = JavacPlugin.instance().getTreeMaker();
    }

    @Override
    protected Symbol.MethodSymbol findBinderMethod(AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> left, AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> right) {
        Type lhs = ((JCTree.JCExpression)left._expr).type;
        Type rhs = ((JCTree.JCExpression)right._expr).type;
        Pair<Type, Type> pair = Pair.make(lhs, rhs);
        if (right._operatorLeft == null && this._mapReactions.containsKey(pair)) {
            return this._mapReactions.get(pair);
        }
        Symbol.MethodSymbol reaction = this.getReaction(lhs, rhs, (JCTree.Tag)((Object)right._operatorLeft));
        if (right._operatorLeft == null) {
            this._mapReactions.put(pair, reaction);
        }
        return reaction;
    }

    private Symbol.MethodSymbol getReaction(Type lhs, Type rhs, JCTree.Tag operator) {
        if (operator != null) {
            return this.resolveOperatorMethod(lhs, rhs, operator);
        }
        Symbol.MethodSymbol binder = this.resolveBinderMethod("prefixBind", lhs, rhs);
        if (binder == null) {
            binder = this.resolveBinderMethod("postfixBind", rhs, lhs);
        }
        return binder;
    }

    private Symbol.MethodSymbol resolveOperatorMethod(Type left, Type right, JCTree.Tag operator) {
        boolean swapped = false;
        Symbol.MethodSymbol overloadOperator = ManAttr.resolveOperatorMethod(this._types, operator, left, right);
        if (overloadOperator == null && ManAttr.isCommutative(operator)) {
            overloadOperator = ManAttr.resolveOperatorMethod(this._types, operator, right, left);
            swapped = true;
        }
        if (overloadOperator != null) {
            return new OverloadOperatorSymbol(overloadOperator, swapped);
        }
        return null;
    }

    private Symbol.MethodSymbol resolveBinderMethod(String name, Type left, Type right) {
        if (!(left.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return ManAttr.getMethodSymbol(this._types, left, right, name, (Symbol.ClassSymbol)left.tsym, 1);
    }

    @Override
    protected AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> makeBinaryExpression(AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> left, AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> right, Symbol.MethodSymbol binderMethod) {
        JCTree.JCBinary binary = this._make.Binary(right._operatorLeft == null ? JCTree.Tag.MUL : (JCTree.Tag)((Object)right._operatorLeft), (JCTree.JCExpression)left._expr, (JCTree.JCExpression)right._expr);
        binary.pos = ((JCTree.JCExpression)left._expr).pos;
        boolean rightToLeft = binderMethod instanceof OverloadOperatorSymbol && ((OverloadOperatorSymbol)binderMethod).isSwapped() || binderMethod.name.toString().equals("postfixBind");
        IDynamicJdk.instance().setOperator(binary, new OverloadOperatorSymbol(binderMethod, rightToLeft));
        binary.type = rightToLeft ? this.memberType(((JCTree.JCExpression)right._expr).type, ((JCTree.JCExpression)left._expr).type, binderMethod) : this.memberType(((JCTree.JCExpression)left._expr).type, ((JCTree.JCExpression)right._expr).type, binderMethod);
        return new AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>(binary, (JCTree.Tag)((Object)left._operatorLeft));
    }

    private Type memberType(Type receiverType, Type argType, Symbol.MethodSymbol binderMethod) {
        Type mt = this._types.memberType(receiverType, binderMethod);
        if (mt instanceof Type.ForAll) {
            return this.resolveGenericReturnType(argType, (Type.ForAll)mt);
        }
        return mt.getReturnType();
    }

    private Type resolveGenericReturnType(Type argType, Type.ForAll forAll) {
        Type.MethodType mt = forAll.asMethodType();
        Type paramType = (Type)((List)mt.getParameterTypes()).get(0);
        paramType = paramType instanceof Type.TypeVar ? paramType.getUpperBound() : paramType;
        Type parameterizedParamType = this._types.asSuper(argType, paramType.tsym);
        HashMap<Type.TypeVar, Type> map = new HashMap<Type.TypeVar, Type>();
        this.fetchTypeVars(paramType, parameterizedParamType, map);
        return this._types.subst(mt.getReturnType(), List.from(map.keySet()), List.from(map.keySet().stream().map(k -> (Type)map.get(k)).collect(Collectors.toList())));
    }

    private void fetchTypeVars(Type t, Type pt, Map<Type.TypeVar, Type> map) {
        new TypeVarFether(map).visit(t, pt);
    }

    class TypeVarFether
    extends Types.SimpleVisitor<Void, Type> {
        private final Map<Type.TypeVar, Type> _map;

        TypeVarFether(Map<Type.TypeVar, Type> map) {
            this._map = map;
        }

        @Override
        public Void visitType(Type t, Type pt) {
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType t, Type pt) {
            if (JavacBinder.this._types.isSameType(t, pt)) {
                return null;
            }
            List<Type> pt_params = pt.getTypeArguments();
            java.util.List t_params = t.getTypeArguments();
            for (int i = 0; i < ((List)t_params).size() && i < pt_params.size(); ++i) {
                JavacBinder.this.fetchTypeVars((Type)((List)t_params).get(i), pt_params.get(i), this._map);
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, Type pt) {
            if (pt instanceof Type.ArrayType) {
                JavacBinder.this.fetchTypeVars(t.getComponentType(), ((Type.ArrayType)pt).getComponentType(), this._map);
            }
            return null;
        }

        @Override
        public Void visitTypeVar(Type.TypeVar t, Type pt) {
            this._map.put(t, pt);
            return null;
        }
    }
}

