/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SDLDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SourceLocation;
import graphql.language.TypeDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.JavacDiagnostic;
import manifold.graphql.type.GqlIssueContainer;
import manifold.graphql.type.GqlManifold;
import manifold.graphql.type.GqlParentType;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.shade.org.antlr.v4.runtime.RecognitionException;
import manifold.shade.org.antlr.v4.runtime.misc.ParseCancellationException;

public class GqlModel
extends AbstractSingleFileModel {
    private final GqlManifold _gqlManifold;
    private GqlParentType _type;
    private SchemaDefinition _schemaDefinition;
    private TypeDefinitionRegistry _typeRegistry;
    private Map<String, OperationDefinition> _operations;
    private Map<String, FragmentDefinition> _fragments;
    private GqlIssueContainer _issues;

    public GqlModel(GqlManifold gqlManifold, String fqn, Set<IFile> files) {
        super(gqlManifold.getModule().getHost(), fqn, files);
        this._gqlManifold = gqlManifold;
        this._issues = null;
        this._fragments = Collections.emptyMap();
        this._operations = Collections.emptyMap();
        this.init();
    }

    private void init() {
        this.parse();
        this._type = new GqlParentType(this.getFqn(), this._schemaDefinition, this._typeRegistry, this._operations, this._fragments, this.getFile(), this._gqlManifold);
    }

    private void parse() {
        try (InputStream stream = this.getFile().openInputStream();){
            this.parse(new InputStreamReader(stream, StandardCharsets.UTF_8));
        }
        catch (InvalidSyntaxException ise) {
            this._issues = new GqlIssueContainer(Collections.singletonList(this.toGraphQLError(ise)), this.getFile());
            this._typeRegistry = new TypeDefinitionRegistry();
        }
        catch (ParseCancellationException pce) {
            this.handleParseException(pce);
            this._typeRegistry = new TypeDefinitionRegistry();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void parse(Reader schemaInput) throws ParseCancellationException {
        Parser parser = new Parser();
        Document document = parser.parseDocument(schemaInput);
        this.buildRegistry(document);
    }

    private void buildRegistry(Document document) {
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        List<Definition> definitions = document.getDefinitions();
        LinkedHashMap<String, OperationDefinition> operations = new LinkedHashMap<String, OperationDefinition>();
        LinkedHashMap<String, FragmentDefinition> fragments = new LinkedHashMap<String, FragmentDefinition>();
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        for (Definition definition : definitions) {
            if (definition instanceof SchemaDefinition) {
                this._schemaDefinition = (SchemaDefinition)definition;
                continue;
            }
            if (definition instanceof SDLDefinition) {
                typeRegistry.add((SDLDefinition)definition).ifPresent(errors::add);
                if (!(definition instanceof ScalarTypeDefinition)) continue;
                typeRegistry.scalars().put(((ScalarTypeDefinition)definition).getName(), (ScalarTypeDefinition)definition);
                continue;
            }
            if (definition instanceof OperationDefinition) {
                operations.put(((OperationDefinition)definition).getName(), (OperationDefinition)definition);
                continue;
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            fragments.put(((FragmentDefinition)definition).getName(), (FragmentDefinition)definition);
        }
        this._issues = new GqlIssueContainer(errors, this.getFile());
        this._typeRegistry = typeRegistry;
        this._operations = operations;
        this._fragments = fragments;
    }

    private void handleParseException(ParseCancellationException e) throws RuntimeException {
        this._issues = new GqlIssueContainer(Collections.singletonList(GqlModel.toInvalidSyntaxError(e)), this.getFile());
    }

    private GraphQLError toGraphQLError(final InvalidSyntaxException ise) {
        return new GraphQLError(){

            @Override
            public String getMessage() {
                return ise.getMessage();
            }

            @Override
            public List<SourceLocation> getLocations() {
                return Collections.singletonList(ise.getLocation());
            }

            @Override
            public ErrorClassification getErrorType() {
                return ErrorType.InvalidSyntax;
            }
        };
    }

    private static InvalidSyntaxError toInvalidSyntaxError(Exception parseException) {
        String msg = parseException.getMessage();
        SourceLocation sourceLocation = null;
        if (parseException.getCause() instanceof RecognitionException) {
            RecognitionException recognitionException = (RecognitionException)parseException.getCause();
            msg = recognitionException.getMessage();
            sourceLocation = new SourceLocation(recognitionException.getOffendingToken().getLine(), recognitionException.getOffendingToken().getCharPositionInLine());
        }
        return new InvalidSyntaxError(sourceLocation, msg);
    }

    GqlParentType getType() {
        return this._type;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    TypeDefinition getTypeDefinition(String simpleName) {
        return this._typeRegistry.getType(simpleName).orElse(null);
    }

    ScalarTypeDefinition getScalarTypeDefinition(String simpleName) {
        return this._typeRegistry.scalars().get(simpleName);
    }

    SchemaDefinition getSchemaDefinition() {
        return this._schemaDefinition;
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        List<IIssue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : issues) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report(new JavacDiagnostic(file, kind, issue.getStartOffset(), issue.getLine(), issue.getColumn(), issue.getMessage()));
        }
    }

    private List<IIssue> getIssues() {
        ArrayList<IIssue> allIssues = new ArrayList<IIssue>();
        if (this._issues != null) {
            allIssues.addAll(this._issues.getIssues());
        }
        return allIssues;
    }
}

