/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import graphql.language.Definition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.TypeDefinition;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.type.JavaTypeManifold;
import manifold.graphql.type.GqlModel;
import manifold.graphql.type.GqlParentType;

public class GqlManifold
extends JavaTypeManifold<GqlModel> {
    public static final List<String> EXTS = Arrays.asList("graphql", "graphqls", "gql");

    @Override
    public void init(IModule module) {
        this.init(module, (fqn, files) -> new GqlModel(this, (String)fqn, (Set<IFile>)files));
    }

    @Override
    public boolean handlesFileExtension(String fileExtension) {
        return EXTS.contains(fileExtension);
    }

    @Override
    public boolean isInnerType(String topLevel, String relativeInner) {
        GqlParentType type;
        GqlModel model = (GqlModel)this.getModel(topLevel);
        GqlParentType gqlParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        Definition typeDef = null;
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            String innerName = tokenizer.nextToken();
            if ((typeDef = typeDef == null ? type.getChild(innerName) : this.getChildDefinition(typeDef, innerName)) != null) continue;
            return innerName.equals("Builder") && !tokenizer.hasMoreTokens();
        }
        return typeDef != null;
    }

    private Definition getChildDefinition(Definition def, String name) {
        for (Node child : def.getNamedChildren().getChildren(name)) {
            if (!(child instanceof TypeDefinition) && !(child instanceof OperationDefinition)) continue;
            return (Definition)child;
        }
        return null;
    }

    TypeDefinition findTypeDefinition(String simpleName) {
        return this.getAllTypeNames().stream().map(fqn -> {
            GqlModel model = (GqlModel)this.getModel((String)fqn);
            return model == null ? null : model.getTypeDefinition(simpleName);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    ScalarTypeDefinition findScalarTypeDefinition(String simpleName) {
        return this.getAllTypeNames().stream().map(fqn -> {
            GqlModel model = (GqlModel)this.getModel((String)fqn);
            return model == null ? null : model.getScalarTypeDefinition(simpleName);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    SchemaDefinition findSchemaDefinition() {
        return this.getAllTypeNames().stream().map(fqn -> {
            GqlModel model = (GqlModel)this.getModel((String)fqn);
            return model == null ? null : model.getSchemaDefinition();
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, GqlModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        model.report(errorHandler);
        model.getType().render(sb, location, this.getModule(), errorHandler);
        return sb.toString();
    }
}

