/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.rt.api;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Collection;
import java.util.HashSet;
import manifold.json.rt.api.IJsonFormatTypeCoercer;
import manifold.rt.api.util.ManStringUtil;

public class GqlScalars {
    public static Collection<GraphQLScalarType> transformFormatTypeResolvers() {
        HashSet<GraphQLScalarType> scalars = new HashSet<GraphQLScalarType>();
        for (IJsonFormatTypeCoercer formatCoercer : IJsonFormatTypeCoercer.get()) {
            formatCoercer.getFormats().forEach((format, type) -> scalars.add(GraphQLScalarType.newScalar().name(ManStringUtil.toPascalCase(format)).description("Support values of type: " + type.getTypeName()).coercing(GqlScalars.makeCoercer(type, formatCoercer)).build()));
        }
        return scalars;
    }

    private static Coercing makeCoercer(final Class<?> javaType, final IJsonFormatTypeCoercer formatCoercer) {
        return new Coercing(){

            public Object parseValue(Object input) throws CoercingParseValueException {
                try {
                    return formatCoercer.coerce(input, javaType);
                }
                catch (Exception e) {
                    throw new CoercingParseValueException(e);
                }
            }

            public Object serialize(Object dataFetcherResult) throws CoercingSerializeException {
                return dataFetcherResult;
            }

            public Object parseLiteral(Object input) throws CoercingParseLiteralException {
                if (input instanceof StringValue && !((StringValue)input).isEqualTo(null)) {
                    return this.parseValue(((StringValue)input).getValue());
                }
                throw new CoercingParseLiteralException("Empty 'StringValue' provided.");
            }
        };
    }
}

