/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IModule;
import manifold.api.host.RefreshRequest;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.api.type.JavaTypeManifold;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.ext.ExtCodeGen;
import manifold.ext.ExtensionTransformer;
import manifold.ext.IExtensionClassProducer;
import manifold.ext.Model;
import manifold.ext.rt.api.Extension;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.util.StreamUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class ExtensionManifold
extends JavaTypeManifold<Model>
implements ITypeProcessor {
    public static final String EXTENSIONS_PACKAGE = "extensions";
    private static final Set<String> FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("java", "class"));

    @Override
    public void init(IModule module) {
        this.init(module, (fqn, files) -> new Model((String)fqn, (Set<IFile>)files, this));
    }

    @Override
    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    @Override
    public ContributorKind getContributorKind() {
        return ContributorKind.Supplemental;
    }

    @Override
    protected ResourceFileTypeManifold.CacheClearer createCacheClearer() {
        return new ExtensionCacheHandler();
    }

    @Override
    public String getTypeNameForFile(String fqn, IFile file) {
        String extendedType;
        int iDot;
        int iExt;
        if (fqn.length() > EXTENSIONS_PACKAGE.length() + 2 && (iExt = fqn.indexOf("extensions.")) >= 0 && (iDot = (extendedType = fqn.substring(iExt + EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) > 0) {
            return extendedType.substring(0, iDot);
        }
        return null;
    }

    @Override
    public boolean handlesFile(IFile file) {
        Set<String> fqns = this.getModule().getPathCache().getFqnForFile(file);
        if (fqns == null) {
            return false;
        }
        for (String fqn : fqns) {
            String extendedType;
            int iDot;
            int iExt;
            if (fqn.length() <= EXTENSIONS_PACKAGE.length() + 2 || (iExt = fqn.indexOf("extensions.")) < 0 || (iDot = (extendedType = fqn.substring(iExt + EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) <= 0) continue;
            try {
                if (file.getExtension().equalsIgnoreCase("java")) {
                    String content = StreamUtil.getContent(new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
                    return content.contains("@Extension") && content.contains(Extension.class.getPackage().getName());
                }
                String content = StreamUtil.getContent(new InputStreamReader(file.openInputStream(), StandardCharsets.UTF_8));
                return content.contains(Extension.class.getName().replace('.', '/'));
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    @Override
    protected Map<String, LocklessLazyVar<Model>> getPeripheralTypes() {
        HashMap<String, LocklessLazyVar<Model>> map = new HashMap<String, LocklessLazyVar<Model>>();
        for (ITypeManifold tm : this.getModule().getTypeManifolds()) {
            if (!(tm instanceof IExtensionClassProducer)) continue;
            for (String extended : ((IExtensionClassProducer)tm).getExtendedTypes()) {
                map.put(extended, LocklessLazyVar.make(() -> new Model(extended, Collections.emptySet(), this)));
            }
        }
        return map;
    }

    @Override
    public boolean isInnerType(String topLevel, String relativeInner) {
        return this.isType(topLevel) && (this.isInnerToPrimaryManifold(topLevel, relativeInner) || !this.isPrimaryManifold(topLevel) && this.isInnerToJavaClass(topLevel, relativeInner));
    }

    private boolean isInnerToPrimaryManifold(String topLevel, String relativeInner) {
        Set<ITypeManifold> tms = this.getModule().findTypeManifoldsFor(topLevel, tm -> tm.getContributorKind() == ContributorKind.Primary && tm instanceof ResourceFileTypeManifold && ((ResourceFileTypeManifold)tm).isInnerType(topLevel, relativeInner));
        return !tms.isEmpty();
    }

    private boolean isPrimaryManifold(String topLevel) {
        Set<ITypeManifold> tms = this.getModule().findTypeManifoldsFor(topLevel, tm -> tm.getContributorKind() == ContributorKind.Primary);
        return !tms.isEmpty();
    }

    private boolean isInnerToJavaClass(String topLevel, String relativeInner) {
        try {
            Class<?> cls = Class.forName(topLevel, false, this.getModule().getHost().getActualClassLoader());
            for (Class<?> inner : cls.getDeclaredClasses()) {
                if (!this.isInnerClass(inner, relativeInner)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isInnerClass(Class<?> cls, String relativeInner) {
        String remainder;
        String name;
        int iDot = relativeInner.indexOf(46);
        if (iDot > 0) {
            name = relativeInner.substring(0, iDot);
            remainder = relativeInner.substring(iDot + 1);
        } else {
            name = relativeInner;
            remainder = null;
        }
        if (cls.getSimpleName().equals(name)) {
            if (remainder != null) {
                for (Class<?> m : cls.getDeclaredClasses()) {
                    if (!this.isInnerClass(m, remainder)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String contribute(JavaFileManager.Location location, String topLevelFqn, boolean genStubs, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        return new ExtCodeGen(location, model, topLevelFqn, genStubs, existing).make(location, errorHandler);
    }

    @Override
    public void process(TypeElement typeElement, TypeProcessor typeProcessor, IssueReporter<JavaFileObject> issueReporter) {
        if (typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.ENUM || typeElement.getKind() == ElementKind.INTERFACE) {
            ExtensionTransformer visitor = new ExtensionTransformer(this, typeProcessor);
            typeProcessor.getTree().accept(visitor);
        }
    }

    private class ExtensionCacheHandler
    extends ResourceFileTypeManifold.CacheClearer {
        private ExtensionCacheHandler() {
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            IModule refreshModule = request.module;
            if (refreshModule != null && refreshModule != ExtensionManifold.this.getModule()) {
                return;
            }
            super.refreshedTypes(request);
            if (request.file == null) {
                return;
            }
            for (ITypeManifold tm2 : ExtensionManifold.this.getModule().findTypeManifoldsFor(request.file, tm -> tm instanceof IExtensionClassProducer)) {
                for (String extended : ((IExtensionClassProducer)tm2).getExtendedTypesForFile(request.file)) {
                    this.refreshedType(extended, request);
                }
            }
        }

        private void refreshedType(String extended, RefreshRequest request) {
            switch (request.kind) {
                case CREATION: {
                    this.createdType(Collections.emptySet(), extended);
                    break;
                }
                case MODIFICATION: {
                    this.modifiedType(Collections.emptySet(), extended);
                    break;
                }
                case DELETION: {
                    this.deletedType(Collections.emptySet(), extended);
                }
            }
        }
    }
}

