/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.util.ManIdentifierUtil;
import manifold.api.util.cache.FqnCache;

class Model
extends AbstractSingleFileModel {
    private FqnCache<String> _cache;

    public Model(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.buildCache(fqn, this.getFile());
    }

    public Model(IManifoldHost host, String fqn, FqnCache<String> cache) {
        super(host, fqn, Collections.emptySet());
        this._cache = cache;
    }

    public FqnCache<String> getCache() {
        return this._cache;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.buildCache(this.getFqn(), file);
    }

    private void buildCache(String fqn, IFile file) {
        try (InputStream propertiesStream = file.openInputStream();){
            Properties properties = new Properties();
            properties.load(propertiesStream);
            FqnCache<String> cache = new FqnCache<String>(fqn, true, ManIdentifierUtil::makeIdentifier);
            for (String key : properties.stringPropertyNames()) {
                cache.add(key, properties.getProperty(key));
            }
            this._cache = cache;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

