/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.JsonIssue;
import manifold.api.json.codegen.DynamicType;
import manifold.api.json.codegen.ErrantType;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonBasicType;
import manifold.api.json.codegen.JsonListType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.json.codegen.schema.ArrayTransformer;
import manifold.api.json.codegen.schema.IllegalSchemaTypeName;
import manifold.api.json.codegen.schema.JsonEnumType;
import manifold.api.json.codegen.schema.JsonFormatType;
import manifold.api.json.codegen.schema.JsonSchemaTransformerSession;
import manifold.api.json.codegen.schema.JsonSchemaType;
import manifold.api.json.codegen.schema.JsonUnionType;
import manifold.api.json.codegen.schema.LazyRefJsonType;
import manifold.api.json.codegen.schema.ObjectTransformer;
import manifold.api.json.codegen.schema.Type;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.api.util.DebugLogUtil;
import manifold.api.util.ManIdentifierUtil;
import manifold.api.util.cache.FqnCache;
import manifold.internal.javac.IIssue;
import manifold.json.rt.Json;
import manifold.json.rt.api.IJsonFormatTypeCoercer;
import manifold.json.rt.parser.Token;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;
import manifold.rt.api.util.StreamUtil;

public class JsonSchemaTransformer {
    private static final String JSCH_SCHEMA = "$schema";
    static final String JSCH_TYPE = "type";
    private static final String JSCH_NAME = "name";
    private static final String JSCH_ID = "$id";
    private static final String JSCH_ID_OLD = "id";
    private static final String JSCH_REF = "$ref";
    private static final String JSCH_ENUM = "enum";
    private static final String JSCH_CONST = "const";
    private static final String JSCH_ALL_OF = "allOf";
    private static final String JSCH_ONE_OF = "oneOf";
    private static final String JSCH_ANY_OF = "anyOf";
    static final String JSCH_ITEMS = "items";
    static final String JSCH_REQUIRED = "required";
    public static final String JSCH_DEFINITIONS = "definitions";
    private static final String JSCH_DEFS = "$defs";
    static final String JSCH_PROPERTIES = "properties";
    private static final String JSCH_FORMAT = "format";
    static final String JSCH_ADDITIONNAL_PROPERTIES = "additionalProperties";
    static final String JSCH_PATTERN_PROPERTIES = "patternProperties";
    static final String JSCH_DEFAULT = "default";
    static final String JSCH_NULLABLE = "nullable";
    static final String JSCH_READONLY = "readOnly";
    static final String JSCH_WRITEONLY = "writeOnly";
    private final IManifoldHost _host;
    private FqnCache<IJsonType> _typeByFqn;
    private Map<String, IJsonType> _typeById;

    private JsonSchemaTransformer(IManifoldHost host) {
        this._host = host;
        this._typeByFqn = new FqnCache("doc", true, ManIdentifierUtil::makeIdentifier);
        this._typeById = new HashMap<String, IJsonType>();
    }

    public static boolean isSchema(Bindings bindings) {
        return bindings.get(JSCH_SCHEMA) != null || bindings.get(JSCH_ID) != null || JsonSchemaTransformer.typeMatches(bindings, Type.Object) || JsonSchemaTransformer.typeMatches(bindings, Type.Array) || bindings.get(JSCH_PROPERTIES) != null;
    }

    private static boolean typeMatches(Bindings bindings, Type testType) {
        Object type = bindings.get(JSCH_TYPE);
        if (type == null) {
            return false;
        }
        String typeName = type instanceof Pair ? (String)((Pair)type).getSecond() : (String)type;
        return typeName != null && typeName.equals(testType.getName());
    }

    public static IJsonType transform(IManifoldHost host, String name, Object jsonValue) {
        return JsonSchemaTransformer.transform(host, name, null, jsonValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IJsonType transform(IManifoldHost host, String name, IFile source, Object jsonValue) {
        if (!(jsonValue instanceof Bindings) || !JsonSchemaTransformer.isSchema((Bindings)jsonValue)) {
            ErrantType errant = new ErrantType(source, name);
            errant.addIssue(new JsonIssue(IIssue.Kind.Error, null, "The Json object from '$source' does not contain a '$schema' element."));
            return errant;
        }
        JsonSchemaTransformer transformer = new JsonSchemaTransformer(host);
        JsonSchemaTransformerSession session = JsonSchemaTransformerSession.instance();
        session.pushTransformer(transformer);
        try {
            Bindings bindings = (Bindings)jsonValue;
            name = name == null || name.isEmpty() ? JsonSchemaTransformer.getJSchema_Name(bindings) : name;
            IJsonType cachedType = JsonSchemaTransformer.findTopLevelCachedType(name, source, bindings);
            if (cachedType != null && !(cachedType instanceof ErrantType)) {
                IJsonType iJsonType = cachedType;
                return iJsonType;
            }
            IJsonType type = transformer.transformType(null, source, name, bindings, null);
            if (type instanceof JsonSchemaType) {
                JsonSchemaTransformer.checkSynthetic((JsonSchemaType)type, jsonValue);
                if (cachedType != null) {
                    JsonSchemaTransformer.moveIssuesFromErrantType((JsonSchemaType)type, (ErrantType)cachedType);
                }
            }
            IJsonType iJsonType = type;
            return iJsonType;
        }
        finally {
            session.popTransformer(transformer);
        }
    }

    private static void checkSynthetic(JsonSchemaType type, Object jsonObj) {
        Object value;
        if (jsonObj instanceof Bindings && (value = ((Bindings)jsonObj).get("synthetic")) instanceof Boolean) {
            type.setSyntheticSchema((Boolean)value);
        }
    }

    private static IJsonType findTopLevelCachedType(String name, IFile source, Bindings docObj) {
        Pair<IJsonType, JsonSchemaTransformer> pair;
        if (source != null && (pair = JsonSchemaTransformerSession.instance().getCachedBaseType(source)) != null) {
            return pair.getFirst();
        }
        return null;
    }

    private static String getJSchema_Name(Bindings docObj) {
        Object value = docObj.get(JSCH_NAME);
        String name = value instanceof Pair ? (String)((Pair)value).getSecond() : (String)value;
        return name;
    }

    private static Object getJSchema_Id(Bindings docObj) {
        Object value = docObj.get(JSCH_ID);
        if (value == null) {
            value = docObj.get(JSCH_ID_OLD);
        }
        return value;
    }

    private static Bindings getJSchema_Definitions(Bindings docObj) {
        Object value = docObj.get(JSCH_DEFINITIONS);
        if (value == null) {
            value = docObj.get(JSCH_DEFS);
        }
        return JsonSchemaTransformer.getBindings(value);
    }

    private static Bindings getBindings(Object value) {
        if (value instanceof Pair) {
            value = ((Pair)value).getSecond();
        }
        return value instanceof Bindings ? (Bindings)value : null;
    }

    private static Bindings getJSchema_Properties(Bindings docObj) {
        Object value = docObj.get(JSCH_PROPERTIES);
        return JsonSchemaTransformer.getBindings(value);
    }

    private static List getJSchema_Enum(Bindings docObj) {
        return JsonSchemaTransformer.getList(docObj.get(JSCH_ENUM));
    }

    private static List getJSchema_Const(Bindings docObj) {
        return JsonSchemaTransformer.getList(docObj.get(JSCH_CONST));
    }

    private static List getJSchema_AllOf(Bindings docObj) {
        return JsonSchemaTransformer.getList(docObj.get(JSCH_ALL_OF));
    }

    private static List getJSchema_AnyOf(Bindings docObj) {
        return JsonSchemaTransformer.getList(docObj.get(JSCH_ANY_OF));
    }

    private static List getJSchema_OneOf(Bindings docObj) {
        return JsonSchemaTransformer.getList(docObj.get(JSCH_ONE_OF));
    }

    private static List getList(Object value) {
        if (value instanceof Pair) {
            value = ((Pair)value).getSecond();
        }
        return value instanceof List ? (List)value : null;
    }

    private List<IJsonType> transformDefinitions(JsonSchemaType parent, String nameQualifier, IFile enclosing, Bindings jsonObj) {
        return this.transformDefinitions(new JsonStructureType(parent, enclosing, nameQualifier, new TypeAttributes()), enclosing, jsonObj);
    }

    private List<IJsonType> transformDefinitions(JsonSchemaType parent, IFile enclosing, Bindings jsonObj) {
        Bindings definitions = JsonSchemaTransformer.getJSchema_Definitions(jsonObj);
        if (definitions == null) {
            return null;
        }
        JsonStructureType definitionsHolder = new JsonStructureType(parent, enclosing, JSCH_DEFINITIONS, new TypeAttributes());
        ArrayList<IJsonType> result = new ArrayList<IJsonType>();
        this.cacheByFqn(definitionsHolder);
        for (Map.Entry entry : definitions.entrySet()) {
            Token[] tokens = null;
            try {
                Bindings bindings;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Pair) {
                    bindings = (Bindings)((Pair)value).getSecond();
                    tokens = (Token[])((Pair)value).getFirst();
                } else {
                    bindings = (Bindings)value;
                }
                IJsonType type = this.transformType(definitionsHolder, enclosing, name, bindings, null);
                if (tokens != null && type instanceof JsonSchemaType) {
                    ((JsonSchemaType)type).setToken(tokens[0]);
                }
                result.add(type);
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, (Token)(tokens != null ? tokens[1] : null), e.getMessage() == null ? DebugLogUtil.getStackTrace(e) : e.getMessage()));
            }
        }
        return result;
    }

    private IJsonType findLocalRef(String ref, IFile enclosing) {
        IJsonType type1 = this.findById(ref);
        if (type1 != null) {
            return type1;
        }
        return this.findByLocationPath(ref, enclosing);
    }

    private IJsonType findByLocationPath(String ref, IFile enclosing) {
        Pair<IJsonType, JsonSchemaTransformer> cachedBaseType;
        String localRef = this.makeLocalRef(ref);
        if (localRef.isEmpty() && (cachedBaseType = JsonSchemaTransformerSession.instance().getCachedBaseType(enclosing)) != null) {
            return cachedBaseType.getFirst();
        }
        return this._typeByFqn.get(localRef);
    }

    private IJsonType findById(String ref) {
        IJsonType type = this._typeById.get(ref);
        if (type != null) {
            return type;
        }
        if (!ref.startsWith("#") && (type = this._typeById.get('#' + ref)) != null) {
            return type;
        }
        if (ref.startsWith("/") && (type = this._typeById.get(ref.substring(1))) != null) {
            return type;
        }
        return null;
    }

    private String makeLocalRef(String localRef) {
        if (localRef.isEmpty()) {
            return "";
        }
        char firstChar = localRef.charAt(0);
        if (firstChar == '/') {
            localRef = localRef.substring(1);
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(localRef, "/");
        while (tokenizer.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            String token = tokenizer.nextToken();
            if (sb.length() == 0) {
                this.prependPathToIdRef(token, sb);
                if (sb.length() > 0) continue;
            }
            token = ManIdentifierUtil.makeIdentifier(token);
            sb.append(token);
        }
        return sb.toString();
    }

    private void prependPathToIdRef(String id, StringBuilder sb) {
        IJsonType type = this.findById(id);
        if (type == null) {
            return;
        }
        while (type.getParent() != null) {
            if (sb.length() > 0) {
                sb.insert(0, '.');
            }
            if (type instanceof JsonSchemaType) {
                sb.insert(0, ManIdentifierUtil.makeIdentifier(((JsonSchemaType)type).getLabel()));
            } else {
                sb.insert(0, ManIdentifierUtil.makeIdentifier(type.getName()));
            }
            type = type.getParent();
        }
    }

    void cacheByFqn(JsonSchemaType type) {
        this._typeByFqn.add(type.getFqn(), type);
    }

    void cacheSimpleByFqn(JsonSchemaType parent, String name, IJsonType type) {
        this._typeByFqn.add(parent.getFqn() + '.' + name, type);
    }

    private void cacheType(IJsonParentType parent, String name, IJsonType type, Bindings jsonObj) {
        String id;
        if (type instanceof JsonSchemaType) {
            this.cacheByFqn((JsonSchemaType)type);
        } else if (type instanceof LazyRefJsonType) {
            this.cacheSimpleByFqn((JsonSchemaType)parent, name, type);
        }
        Object value = JsonSchemaTransformer.getJSchema_Id(jsonObj);
        if (value == null) {
            return;
        }
        Token[] tokens = null;
        if (value instanceof Pair) {
            id = (String)((Pair)value).getSecond();
            tokens = (Token[])((Pair)value).getFirst();
        } else {
            id = (String)value;
        }
        this.cacheTypeById(parent, type, id, tokens != null ? tokens[1] : null);
    }

    private void cacheTypeById(IJsonParentType parent, IJsonType type, String id, Token token) {
        if (id.isEmpty()) {
            (parent == null ? (IJsonParentType)type : parent).addIssue(new JsonIssue(IIssue.Kind.Error, token, "Relative 'id' is invalid: empty string"));
            return;
        }
        IJsonType existing = this._typeById.get(id);
        if (existing != null) {
            (parent == null ? (IJsonParentType)type : parent).addIssue(new JsonIssue(IIssue.Kind.Error, token, "Id '" + id + "' already assigned to type '" + existing.getName() + "'"));
        } else {
            this._typeById.put(id, type);
        }
    }

    IJsonType transformType(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean isNullable) {
        IJsonType result;
        JsonFormatType formatType;
        Object value = jsonObj.get(JSCH_TYPE);
        TypeResult tr = this.getTypeFromValue(value);
        String type = (String)tr.type;
        Token token = tr.token;
        Boolean nullable = this.isNullable(jsonObj, isNullable, tr);
        if (type == null && this.isPropertiesDefined(jsonObj)) {
            type = Type.Object.getName();
        }
        Runnable transform = null;
        JsonFormatType jsonFormatType = formatType = jsonObj.containsKey(JSCH_FORMAT) ? this.resolveFormatType(jsonObj) : null;
        if (formatType != null) {
            result = formatType.copyWithAttributes(new TypeAttributes(nullable, jsonObj));
            this.cacheSimpleByFqn(parent, name, result);
        } else {
            boolean bRef = jsonObj.containsKey(JSCH_REF);
            boolean bEnum = jsonObj.containsKey(JSCH_ENUM);
            boolean bConst = jsonObj.containsKey(JSCH_CONST);
            if (bEnum) {
                result = this.deriveTypeFromEnum(parent, enclosing, name, jsonObj, nullable);
                if (result != parent) {
                    JsonSchemaTransformer.copyIssuesFromErrantType(parent, result, jsonObj);
                }
            } else if (bConst) {
                result = this.deriveTypeFromConst(parent, enclosing, name, jsonObj, nullable);
                if (result != parent) {
                    JsonSchemaTransformer.copyIssuesFromErrantType(parent, result, jsonObj);
                }
            } else if (type == null || bRef || this.isCombination(jsonObj)) {
                JsonStructureType refParent = new JsonStructureType(parent, enclosing, name, new TypeAttributes());
                if (bRef && parent == null) {
                    Object refValue = jsonObj.get(JSCH_REF);
                    if (refValue instanceof Pair) {
                        token = ((Token[])((Pair)refValue).getFirst())[0];
                    }
                    refParent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "'$ref' not allowed at root level"));
                    result = refParent;
                } else {
                    List<IJsonType> definitions;
                    this.transformDefinitions(parent, enclosing, name, jsonObj, refParent);
                    result = this.findReferenceTypeOrCombinationType(parent, enclosing, name, jsonObj, nullable);
                    if (result != parent) {
                        JsonSchemaTransformer.copyIssuesFromErrantType(parent, result, jsonObj);
                    }
                    if (result != null && (definitions = refParent.getDefinitions()) != null) {
                        result.setDefinitions(definitions);
                    }
                }
            } else {
                Type t = Type.fromName(type);
                switch (t) {
                    case Object: {
                        result = new JsonStructureType(parent, enclosing, name, new TypeAttributes(nullable, jsonObj));
                        transform = () -> ObjectTransformer.transform(this, (JsonStructureType)result, jsonObj);
                        break;
                    }
                    case Array: {
                        result = new JsonListType(name, enclosing, parent, new TypeAttributes(nullable, jsonObj));
                        transform = () -> ArrayTransformer.transform(this, name, (JsonListType)result, jsonObj);
                        break;
                    }
                    case Dynamic: {
                        result = DynamicType.instance();
                        this.cacheSimpleByFqn(parent, name, result);
                        break;
                    }
                    case Invalid: {
                        throw new IllegalSchemaTypeName(type, token);
                    }
                    default: {
                        result = new JsonBasicType(t, new TypeAttributes(nullable, jsonObj));
                        this.cacheSimpleByFqn(parent, name, result);
                    }
                }
                this.transformDefinitions(parent, enclosing, name, jsonObj, result);
            }
        }
        this.cacheType(parent, name, result, jsonObj);
        if (parent == null && enclosing != null) {
            JsonSchemaTransformerSession.instance().cacheBaseType(enclosing, new Pair<IJsonType, JsonSchemaTransformer>(result, this));
        }
        if (transform != null) {
            transform.run();
        }
        if (result instanceof JsonSchemaType) {
            ((JsonSchemaType)result).setJsonSchema();
        }
        return result;
    }

    private Boolean isNullable(Bindings jsonObj, Boolean isNullable, TypeResult tr) {
        Boolean openApiNullable;
        Boolean nullable = isNullable;
        if (tr.nullable != null) {
            nullable = nullable == null ? tr.nullable : nullable != false || tr.nullable != false;
        }
        if ((openApiNullable = this.isNullable(jsonObj)) != null) {
            nullable = nullable == null ? openApiNullable : nullable != false || openApiNullable != false;
        }
        return nullable;
    }

    private Boolean isNullable(Bindings jsonObj) {
        Object nullable = jsonObj.get(JSCH_NULLABLE);
        if (!(nullable instanceof Boolean)) {
            return null;
        }
        return (Boolean)nullable;
    }

    private TypeResult getTypeFromValue(Object value) {
        TypeResult tr = new TypeResult();
        if (value instanceof Pair) {
            tr.type = ((Pair)value).getSecond();
            tr.token = ((Token[])((Pair)value).getFirst())[1];
        } else {
            tr.type = value;
        }
        if (tr.type instanceof List) {
            for (String name : (List)tr.type) {
                Type typeName = Type.fromName(name);
                if (typeName == Type.Null) {
                    tr.nullable = true;
                    continue;
                }
                tr.type = typeName.getName();
            }
        }
        return tr;
    }

    private JsonFormatType resolveFormatType(Bindings jsonObj) {
        JsonFormatType resolvedType = null;
        for (IJsonFormatTypeCoercer formatCoercer : IJsonFormatTypeCoercer.get()) {
            Object format = jsonObj.get(JSCH_FORMAT);
            Object object = format = format instanceof Pair ? ((Pair)format).getSecond() : format;
            Class<?> javaType = formatCoercer.getFormats().get((String)format);
            if (javaType == null) continue;
            resolvedType = JsonFormatType.getPrototype((String)format, javaType);
            break;
        }
        return resolvedType;
    }

    private boolean isCombination(Bindings jsonObj) {
        return (jsonObj.containsKey(JSCH_ALL_OF) || jsonObj.containsKey(JSCH_ONE_OF) || jsonObj.containsKey(JSCH_ANY_OF)) && !this.isPropertiesDefined(jsonObj);
    }

    private boolean isPropertiesDefined(Bindings jsonObj) {
        return jsonObj.get(JSCH_PROPERTIES) instanceof Bindings || jsonObj.get(JSCH_PROPERTIES) instanceof Pair && ((Pair)jsonObj.get(JSCH_PROPERTIES)).getSecond() instanceof Bindings;
    }

    private void transformDefinitions(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, IJsonType result) {
        List<IJsonType> definitions = result instanceof JsonSchemaType ? this.transformDefinitions((JsonSchemaType)result, enclosing, jsonObj) : this.transformDefinitions(parent, name, enclosing, jsonObj);
        result.setDefinitions(definitions);
    }

    private static void copyIssuesFromErrantType(JsonSchemaType parent, IJsonType type, Bindings jsonObj) {
        if (type instanceof ErrantType) {
            Object value = jsonObj.get(JSCH_REF);
            Token token = null;
            if (value instanceof Pair) {
                token = ((Token[])((Pair)value).getFirst())[1];
            }
            for (JsonIssue issue : ((ErrantType)type).getIssues()) {
                parent.addIssue(new JsonIssue(issue.getKind(), token, issue.getMessage()));
            }
        }
    }

    private static void moveIssuesFromErrantType(JsonSchemaType target, ErrantType errant) {
        for (JsonIssue issue : errant.getIssues()) {
            target.addIssue(issue);
        }
    }

    private IJsonType findReferenceTypeOrCombinationType(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean nullable) {
        IJsonType result = this.findReference(parent, enclosing, jsonObj);
        if (result != null) {
            result = result.copyWithAttributes(new TypeAttributes(nullable, jsonObj));
        } else {
            result = this.transformCombination(parent, enclosing, name, jsonObj, nullable);
            if (result == null && (result = this.deriveTypeFromEnum(parent, enclosing, name, jsonObj, nullable)) == null) {
                result = DynamicType.instance();
            }
        }
        return result;
    }

    private IJsonType deriveTypeFromEnum(JsonSchemaType parent, IFile enclosing, String name, Bindings bindings, Boolean nullable) {
        List list = JsonSchemaTransformer.getJSchema_Enum(bindings);
        return this.makeEnum(parent, enclosing, name, list, new TypeAttributes(nullable, bindings));
    }

    private IJsonType deriveTypeFromConst(JsonSchemaType parent, IFile enclosing, String name, Bindings bindings, Boolean nullable) {
        List list = JsonSchemaTransformer.getJSchema_Const(bindings);
        return this.makeEnum(parent, enclosing, name, list, new TypeAttributes(nullable, bindings));
    }

    private IJsonType makeEnum(JsonSchemaType parent, IFile enclosing, String name, List<?> list, TypeAttributes attr) {
        if (list == null) {
            return null;
        }
        JsonEnumType type = new JsonEnumType(parent, enclosing, name, list, attr);
        if (parent != null) {
            parent.addChild(type.getLabel(), type);
        }
        return type;
    }

    private IJsonType transformCombination(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean nullable) {
        IJsonType type = this.transformAllOf(parent, enclosing, name, jsonObj, nullable);
        if (type != null) {
            return type;
        }
        type = this.transformAnyOf(parent, enclosing, name, jsonObj, nullable);
        if (type != null) {
            return type;
        }
        return this.transformOneOf(parent, enclosing, name, jsonObj, nullable);
    }

    private JsonStructureType transformAllOf(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean nullable) {
        List list = JsonSchemaTransformer.getJSchema_AllOf(jsonObj);
        if (list == null) {
            return null;
        }
        return this.buildHierarchy(parent, enclosing, name, list, jsonObj, nullable);
    }

    private IJsonType transformAnyOf(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean nullable) {
        List list = JsonSchemaTransformer.getJSchema_AnyOf(jsonObj);
        if (list == null) {
            return null;
        }
        return this.buildUnion(parent, enclosing, name, list, jsonObj, nullable);
    }

    private IJsonType transformOneOf(JsonSchemaType parent, IFile enclosing, String name, Bindings jsonObj, Boolean nullable) {
        List list = JsonSchemaTransformer.getJSchema_OneOf(jsonObj);
        if (list == null) {
            return null;
        }
        return this.buildUnion(parent, enclosing, name, list, jsonObj, nullable);
    }

    private JsonStructureType buildHierarchy(JsonSchemaType parent, IFile enclosing, String name, List list, Bindings jsonObj, Boolean nullable) {
        JsonStructureType type = null;
        boolean hasType = false;
        int iInner = 0;
        for (Object elem : list) {
            IJsonType ref;
            if (elem instanceof Pair) {
                elem = ((Pair)elem).getSecond();
            }
            if (!(elem instanceof Bindings)) continue;
            Bindings elemBindings = (Bindings)elem;
            JsonStructureType jsonStructureType = type = type == null ? new JsonStructureType(parent, enclosing, name, new TypeAttributes(nullable, jsonObj)) : type;
            if (elemBindings.size() == 1 && elemBindings.containsKey(JSCH_REQUIRED)) {
                Object requiredValue = elemBindings.get(JSCH_REQUIRED);
                type.addRequiredWithTokens(requiredValue);
            }
            if ((ref = this.findReference(type, enclosing, elemBindings)) != null) {
                if (!hasType) {
                    ObjectTransformer.transform(this, type, elemBindings);
                    hasType = true;
                }
                type.addSuper(ref);
                continue;
            }
            if (elemBindings.containsKey(JSCH_ENUM)) {
                IJsonType enumType;
                if (!hasType) {
                    ObjectTransformer.transform(this, type, elemBindings);
                    hasType = true;
                }
                if ((enumType = this.deriveTypeFromEnum(type, enclosing, JSCH_ENUM + iInner++, elemBindings, nullable)) != parent) {
                    JsonSchemaTransformer.copyIssuesFromErrantType(parent, enumType, elemBindings);
                }
                type.addSuper(enumType);
                continue;
            }
            Bindings properties = JsonSchemaTransformer.getJSchema_Properties(elemBindings);
            if (properties != null) {
                ObjectTransformer.transform(this, type, elemBindings);
                hasType = true;
                type = (JsonStructureType)type.copyWithAttributes(new TypeAttributes(elemBindings));
                continue;
            }
            IJsonType comboType = this.transformCombination(type, enclosing, "Combo" + iInner++, elemBindings, nullable);
            if (comboType == parent) continue;
            JsonSchemaTransformer.copyIssuesFromErrantType(parent, comboType, elemBindings);
            type.addSuper(comboType);
        }
        return hasType ? type : null;
    }

    private IJsonType buildUnion(JsonSchemaType parent, IFile enclosing, String name, List list, Bindings jsonObj, Boolean nullable) {
        IJsonType singleNullable = this.maybeGetSingleNullable(parent, enclosing, name, list);
        if (singleNullable != null) {
            return singleNullable;
        }
        JsonUnionType type = new JsonUnionType(parent, enclosing, name, new TypeAttributes(nullable, jsonObj));
        int i = 0;
        Boolean isNullable = this.isNullable(list);
        nullable = nullable == null ? isNullable : (isNullable == null ? nullable : Boolean.valueOf(isNullable != false || nullable != false));
        for (Object elem : list) {
            String actualName;
            if (elem instanceof Pair) {
                elem = ((Pair)elem).getSecond();
            }
            if (!(elem instanceof Bindings) || ((Bindings)elem).size() == 1 && ((Bindings)elem).containsKey(JSCH_REQUIRED)) continue;
            String simpleName = "Option" + i++;
            IJsonType typePart = this.transformType(type, enclosing, simpleName, (Bindings)elem, nullable);
            String string = typePart == null ? null : (actualName = typePart instanceof LazyRefJsonType ? "Lazy" + System.identityHashCode(typePart) : typePart.getName());
            if (actualName == null || !actualName.equals(simpleName)) {
                --i;
            }
            if (typePart == null) continue;
            type.addConstituent(actualName, typePart);
        }
        if (!type.getConstituents().isEmpty()) {
            if (parent != null) {
                parent.addChild(type.getLabel(), type);
            }
            return type;
        }
        return null;
    }

    Boolean isNullable(List list) {
        for (Object elem : list) {
            if (elem instanceof Pair) {
                elem = ((Pair)elem).getSecond();
            }
            if (!"null".equals(((Bindings)elem).get(JSCH_TYPE))) continue;
            return true;
        }
        return null;
    }

    private IJsonType maybeGetSingleNullable(JsonSchemaType parent, IFile enclosing, String name, List list) {
        Object second;
        if (list.size() != 2) {
            return null;
        }
        Object first = list.get(0);
        if (first instanceof Pair) {
            first = ((Pair)first).getSecond();
        }
        if ((second = list.get(1)) instanceof Pair) {
            second = ((Pair)second).getSecond();
        }
        if (first instanceof Bindings) {
            boolean nullable;
            Object type = ((Bindings)first).get(JSCH_TYPE);
            if (type instanceof Pair) {
                type = ((Pair)type).getSecond();
            }
            if (!(nullable = "null".equals(type))) {
                if (second instanceof Bindings) {
                    type = ((Bindings)second).get(JSCH_TYPE);
                    if (type instanceof Pair) {
                        type = ((Pair)type).getSecond();
                    }
                    if (nullable = "null".equals(type)) {
                        return this.transformType(parent, enclosing, name, (Bindings)first, true);
                    }
                }
            } else {
                return this.transformType(parent, enclosing, name, (Bindings)second, true);
            }
        }
        return null;
    }

    private IJsonType findReference(JsonSchemaType parent, IFile enclosing, Bindings jsonObj) {
        URI uri;
        Token token;
        String ref;
        Object value = jsonObj.get(JSCH_REF);
        if (value instanceof Pair) {
            ref = (String)((Pair)value).getSecond();
            token = ((Token[])((Pair)value).getFirst())[1];
        } else {
            ref = (String)value;
            token = null;
        }
        if (ref == null) {
            return null;
        }
        try {
            ref = ref.replace("/properties/", "/").replace("/properties#", "/");
            uri = new URI(ref);
        }
        catch (URISyntaxException e) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Invalid URI syntax: " + e.getReason()));
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme != null && !scheme.isEmpty() && !scheme.equalsIgnoreCase("file")) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Unsupported URI scheme: '" + scheme + "'. A reference must be local to a resource file."));
            return null;
        }
        String filePart = uri.getRawSchemeSpecificPart();
        if (filePart != null && !filePart.isEmpty()) {
            IJsonType definition;
            Pair<IJsonType, JsonSchemaTransformer> pair = this.findBaseType(token, parent, enclosing, uri, filePart);
            IJsonType iJsonType = definition = pair == null ? null : this.findFragmentType(token, uri, pair);
            if (definition == null) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Invalid URI: " + uri));
            }
            return definition;
        }
        IJsonType fragment = this.findFragmentRef(parent, enclosing, token, uri);
        if (fragment != null) {
            return fragment;
        }
        throw new UnsupportedOperationException("Unhandled URI: " + ref);
    }

    private IJsonType findFragmentRef(JsonSchemaType parent, IFile enclosing, Token token, URI uri) {
        String uriFragment = uri.getFragment();
        if (uriFragment != null) {
            String fragment = uriFragment.replace(JSCH_DEFS, JSCH_DEFINITIONS);
            return new LazyRefJsonType(() -> {
                IJsonType localRef = this.findLocalRef(fragment, enclosing);
                if (localRef == null) {
                    parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Cannot resolve reference: " + fragment));
                    localRef = new ErrantType(enclosing, fragment);
                }
                return localRef;
            });
        }
        return null;
    }

    private IJsonType findFragmentType(Token token, URI uri, Pair<IJsonType, JsonSchemaTransformer> pair) {
        String fragment = uri.getFragment();
        IJsonType baseType = pair.getFirst();
        if (fragment == null || fragment.isEmpty()) {
            return baseType;
        }
        return pair.getSecond().findFragmentRef((JsonSchemaType)baseType, ((JsonSchemaType)baseType).getFile(), token, uri);
    }

    private Pair<IJsonType, JsonSchemaTransformer> findBaseType(Token token, JsonSchemaType parent, IFile enclosing, URI uri, String filePart) {
        IJsonType baseType;
        URL url;
        String scheme = uri.getScheme();
        try {
            url = scheme != null ? new URL(scheme + ':' + filePart) : new URL(enclosing.toURI().toURL(), filePart);
        }
        catch (MalformedURLException e) {
            parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Malformed URL: " + uri));
            return null;
        }
        IFile urlFile = this._host.getFileSystem().getIFile(url);
        Pair<IJsonType, JsonSchemaTransformer> pair = JsonSchemaTransformerSession.instance().getCachedBaseType(urlFile);
        IJsonType iJsonType = baseType = pair == null ? null : pair.getFirst();
        if (baseType == null) {
            Object jsonObject;
            String otherFileContent;
            try {
                String protocol = url.getProtocol();
                InputStream input = protocol != null && protocol.equals("file") ? urlFile.openInputStream() : url.openStream();
                try (InputStream sheeeeit = input;){
                    otherFileContent = StreamUtil.getContent(new InputStreamReader(sheeeeit, StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, e.getMessage()));
                return null;
            }
            try {
                jsonObject = Json.fromJson(otherFileContent);
            }
            catch (Exception e) {
                parent.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Error: " + e.getMessage()));
                return null;
            }
            String name = new File(uri.getPath()).getName();
            int iDot = name.lastIndexOf(46);
            if (iDot > 0) {
                name = name.substring(0, iDot);
            }
            JsonSchemaTransformer.transform(this._host, name, urlFile, jsonObject);
            pair = JsonSchemaTransformerSession.instance().getCachedBaseType(urlFile);
        }
        return pair;
    }

    static class TypeResult {
        Object type;
        Token token;
        Boolean nullable;

        TypeResult() {
        }
    }
}

