/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import manifold.api.gen.SrcAnnotated;
import manifold.api.gen.TypeNameParser;

public class SrcType
extends SrcAnnotated<SrcType> {
    private String _fqn;
    private SrcType _componentType;
    private SrcType _enclosingType;
    private String _superOrExtends;
    private List<SrcType> _bound;
    private List<SrcType> _typeParams;
    private int _arrayDims;
    private boolean _isPrimitive;
    private boolean _isDiamond;
    private boolean _isEnum;
    private boolean _isInterface;
    private boolean _isAnnotation;

    public SrcType(Class type) {
        this(new TypeNameParser(type.getName()).parse());
    }

    public SrcType(String fqn) {
        this(new TypeNameParser(fqn).parse());
    }

    private SrcType(TypeNameParser.Type simpleType) {
        this._fqn = simpleType._fqn;
        this._isDiamond = simpleType._diamond;
        this._arrayDims = simpleType._arrayDim;
        this._componentType = this._arrayDims > 0 ? new SrcType(simpleType.getComponentType()) : null;
        this._typeParams = new ArrayList<SrcType>();
        if (!simpleType._params.isEmpty()) {
            this._typeParams = new ArrayList<SrcType>();
            for (TypeNameParser.Type param : simpleType._params) {
                this.addTypeParam(new SrcType(param));
            }
        }
        if (simpleType._bound != null) {
            this._superOrExtends = simpleType._superOrExtends;
            this._bound = simpleType._bound.stream().map(SrcType::new).collect(Collectors.toList());
        } else {
            this._bound = Collections.emptyList();
        }
    }

    public SrcType getEnclosingType() {
        return this._enclosingType;
    }

    public void setEnclosingType(SrcType enclosingType) {
        this._enclosingType = enclosingType;
    }

    public SrcType addTypeParam(SrcType srcType) {
        this._typeParams.add(srcType);
        return this;
    }

    public SrcType addTypeParam(Class type) {
        SrcType srcType = new SrcType(type);
        this._typeParams.add(srcType);
        return this;
    }

    public SrcType addTypeParam(String type) {
        SrcType srcType = new SrcType(type);
        this._typeParams.add(srcType);
        return this;
    }

    public void setPrimitive(boolean primitive) {
        this._isPrimitive = primitive;
    }

    public void setInterface(boolean isInterface) {
        this._isInterface = isInterface;
    }

    public void setEnum(boolean isEnum) {
        this._isEnum = isEnum;
    }

    public void setAnnotation(boolean isAnno) {
        this._isAnnotation = isAnno;
    }

    public String getName() {
        return this._fqn;
    }

    public String getFqName() {
        return this._enclosingType != null ? this._enclosingType.getName() + '.' + this._fqn : this._fqn;
    }

    public SrcType diamond() {
        this._isDiamond = true;
        return this;
    }

    public int getArrayDims() {
        return this._arrayDims;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public boolean isArray() {
        return this._arrayDims > 0;
    }

    public List<SrcType> getTypeParams() {
        return this._typeParams;
    }

    public boolean isDiamond() {
        return this._isDiamond;
    }

    public List<SrcType> getBounds() {
        return this._bound;
    }

    public void addBound(SrcType bound) {
        if (this._bound.isEmpty()) {
            this._bound = new ArrayList<SrcType>(2);
        }
        this._bound.add(bound);
    }

    public String getSuperOrExtends() {
        return this._superOrExtends;
    }

    public void setSuperOrExtends(String superOrExtends) {
        this._superOrExtends = superOrExtends;
    }

    public SrcType getComponentType() {
        if (this._componentType != null) {
            return this._componentType;
        }
        if (this.isArray()) {
            String type = this._fqn.substring(0, this._fqn.lastIndexOf(91));
            this._componentType = new SrcType(type);
            return this._componentType;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SrcType srcType = (SrcType)o;
        if (this._arrayDims != srcType._arrayDims) {
            return false;
        }
        if (this._isPrimitive != srcType._isPrimitive) {
            return false;
        }
        if (this._isDiamond != srcType._isDiamond) {
            return false;
        }
        if (this._isEnum != srcType._isEnum) {
            return false;
        }
        if (this._isInterface != srcType._isInterface) {
            return false;
        }
        if (this._isAnnotation != srcType._isAnnotation) {
            return false;
        }
        if (!this._fqn.equals(srcType._fqn)) {
            return false;
        }
        if (this._componentType != null ? !this._componentType.equals(srcType._componentType) : srcType._componentType != null) {
            return false;
        }
        if (this._enclosingType != null ? !this._enclosingType.equals(srcType._enclosingType) : srcType._enclosingType != null) {
            return false;
        }
        if (this._superOrExtends != null ? !this._superOrExtends.equals(srcType._superOrExtends) : srcType._superOrExtends != null) {
            return false;
        }
        if (this._bound != null ? !this._bound.equals(srcType._bound) : srcType._bound != null) {
            return false;
        }
        return this._typeParams != null ? this._typeParams.equals(srcType._typeParams) : srcType._typeParams == null;
    }

    public int hashCode() {
        int result = this._fqn.hashCode();
        result = 31 * result + (this._componentType != null ? this._componentType.hashCode() : 0);
        result = 31 * result + (this._enclosingType != null ? this._enclosingType.hashCode() : 0);
        result = 31 * result + (this._superOrExtends != null ? this._superOrExtends.hashCode() : 0);
        result = 31 * result + (this._bound != null ? this._bound.hashCode() : 0);
        result = 31 * result + (this._typeParams != null ? this._typeParams.hashCode() : 0);
        result = 31 * result + this._arrayDims;
        result = 31 * result + (this._isPrimitive ? 1 : 0);
        result = 31 * result + (this._isDiamond ? 1 : 0);
        result = 31 * result + (this._isEnum ? 1 : 0);
        result = 31 * result + (this._isInterface ? 1 : 0);
        result = 31 * result + (this._isAnnotation ? 1 : 0);
        return result;
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        return this.render(sb, indent, true);
    }

    public StringBuilder render(StringBuilder sb, int indent, boolean withAnnos) {
        String fqn;
        if (this._enclosingType != null) {
            this._enclosingType.render(sb, indent);
            sb.append('.');
        }
        if (withAnnos && !this.getAnnotations().isEmpty()) {
            StringBuilder sbFqn = new StringBuilder();
            int iDot = this._fqn.lastIndexOf(46);
            if (iDot >= 0) {
                sbFqn.append(this._fqn, 0, iDot + 1);
            }
            this.renderAnnotations(sbFqn, 1, true);
            sbFqn.append(' ').append(this._fqn.substring(iDot + 1));
            fqn = sbFqn.toString();
        } else {
            fqn = this._fqn;
        }
        sb.append(fqn);
        if (this._isDiamond) {
            sb.append("<>");
        } else if (this._superOrExtends != null) {
            sb.append(' ').append(this._superOrExtends).append(' ');
            for (int i = 0; i < this._bound.size(); ++i) {
                if (i > 0) {
                    sb.append(" & ");
                }
                this._bound.get(i).render(sb, 0);
            }
        } else if (this._typeParams.size() > 0) {
            sb.append('<');
            for (int i = 0; i < this._typeParams.size(); ++i) {
                SrcType param = this._typeParams.get(i);
                if (i > 0) {
                    sb.append(", ");
                }
                param.render(sb, 0);
            }
            sb.append('>');
        }
        for (int i = 0; i < this._arrayDims; ++i) {
            sb.append("[]");
        }
        return sb;
    }

    public boolean isEnum() {
        return this._isEnum;
    }
}

