/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IDirectoryUtil;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.ResourcePath;
import manifold.api.fs.jar.IJarFileDirectory;
import manifold.api.fs.jar.JarEntryDirectoryImpl;
import manifold.api.fs.jar.JarEntryFileImpl;
import manifold.api.util.DynamicArray;

public class JarFileDirectoryImpl
implements IJarFileDirectory {
    private IFileSystem _fileSystem;
    private File _file;
    private JarFile _jarFile;
    private Map<String, IResource> _resources;
    private List<IDirectory> _childDirs;
    private List<IFile> _childFiles;
    private String _name;
    private IDirectory _parent;
    private URI _uri;
    private ResourcePath _path;

    public JarFileDirectoryImpl(IFileSystem fileSystem, File file) {
        this._fileSystem = fileSystem;
        this._resources = new HashMap<String, IResource>();
        this._childFiles = new ArrayList<IFile>();
        this._childDirs = new ArrayList<IDirectory>();
        this._file = file;
        if (file.exists()) {
            try {
                this._jarFile = new JarFile(file);
                Enumeration<JarEntry> entries = this._jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    this.processJarEntry(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public IFileSystem getFileSystem() {
        return this._fileSystem;
    }

    private void processJarEntry(JarEntry e) {
        DynamicArray<String> pathComponents = IDirectoryUtil.splitPath(e.getName());
        if (pathComponents.isEmpty()) {
            return;
        }
        if (pathComponents.size() == 1) {
            String name = (String)pathComponents.get(0);
            if (e.isDirectory()) {
                JarEntryDirectoryImpl resource = this.getOrCreateDirectory(name);
                resource.setEntry(e);
            } else {
                JarEntryFileImpl resource = this.getOrCreateFile(name);
                resource.setEntry(e);
            }
        } else {
            JarEntryDirectoryImpl parentDirectory = this.getOrCreateDirectory((String)pathComponents.get(0));
            for (int i = 1; i < pathComponents.size() - 1; ++i) {
                parentDirectory = parentDirectory.getOrCreateDirectory((String)pathComponents.get(i));
            }
            if (e.isDirectory()) {
                JarEntryDirectoryImpl leafDir = parentDirectory.getOrCreateDirectory((String)pathComponents.get(pathComponents.size() - 1));
                leafDir.setEntry(e);
            } else {
                JarEntryFileImpl leafFile = parentDirectory.getOrCreateFile((String)pathComponents.get(pathComponents.size() - 1));
                leafFile.setEntry(e);
            }
        }
    }

    public InputStream getInputStream(JarEntry entry) throws IOException {
        return this._jarFile.getInputStream(entry);
    }

    @Override
    public JarEntryDirectoryImpl getOrCreateDirectory(String relativeName) {
        IResource resource = this._resources.get(relativeName);
        if (resource instanceof IFile) {
            throw new UnsupportedOperationException("The requested resource " + relativeName + " is now being accessed as a directory, but was previously accessed as a file.");
        }
        JarEntryDirectoryImpl result = (JarEntryDirectoryImpl)resource;
        if (result == null) {
            result = new JarEntryDirectoryImpl(this.getFileSystem(), relativeName, this, this);
            this._resources.put(relativeName, result);
            this._childDirs.add(result);
        }
        return result;
    }

    @Override
    public JarEntryFileImpl getOrCreateFile(String relativeName) {
        IResource resource = this._resources.get(relativeName);
        if (resource instanceof IDirectory) {
            throw new UnsupportedOperationException("The requested resource " + relativeName + " is now being accessed as a file, but was previously accessed as a directory.");
        }
        JarEntryFileImpl result = (JarEntryFileImpl)resource;
        if (result == null) {
            result = new JarEntryFileImpl(this.getFileSystem(), relativeName, this, this);
            this._resources.put(relativeName, result);
            this._childFiles.add(result);
        }
        return result;
    }

    @Override
    public IDirectory dir(String relativePath) {
        return IDirectoryUtil.dir(this, relativePath);
    }

    @Override
    public IFile file(String path) {
        return IDirectoryUtil.file(this, path);
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<IDirectory> results = new ArrayList<IDirectory>();
        for (IDirectory child : this._childDirs) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<IFile> results = new ArrayList<IFile>();
        for (IFile child : this._childFiles) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public IDirectory getParent() {
        if (this._parent == null) {
            File parentFile = this._file.getParentFile();
            if (parentFile != null) {
                this._parent = this.getFileSystem().getIDirectory(parentFile);
            } else {
                return null;
            }
        }
        return this._parent;
    }

    @Override
    public String getName() {
        return this._name == null ? (this._name = this._file.getName()) : this._name;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public boolean delete() {
        return this._file.delete();
    }

    @Override
    public URI toURI() {
        return this._uri == null ? (this._uri = this._file.toURI()) : this._uri;
    }

    @Override
    public ResourcePath getPath() {
        return this._path == null ? (this._path = ResourcePath.parse(this._file.getAbsolutePath())) : this._path;
    }

    @Override
    public boolean isChildOf(IDirectory dir) {
        return dir.equals(this.getParent());
    }

    @Override
    public boolean isDescendantOf(IDirectory dir) {
        return dir.getPath().isDescendant(this.getPath());
    }

    @Override
    public File toJavaFile() {
        return this._file;
    }

    public JarFile getJarFile() {
        return this._jarFile;
    }

    @Override
    public boolean isJavaFile() {
        return true;
    }

    @Override
    public boolean isInJar() {
        return true;
    }

    @Override
    public boolean create() {
        return false;
    }

    public String toString() {
        return this.toJavaFile().getPath();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JarFileDirectoryImpl) {
            return this.getPath().equals(((JarFileDirectoryImpl)obj).getPath());
        }
        return false;
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

