/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileUtil;
import manifold.api.host.AbstractTypeSystemListener;
import manifold.api.host.IModule;
import manifold.api.host.RefreshRequest;
import manifold.api.util.ManIdentifierUtil;
import manifold.api.util.cache.FqnCache;
import manifold.rt.api.util.ManClassUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class PathCache {
    private CacheClearer _clearer;
    private final IModule _module;
    private final Supplier<Collection<IDirectory>> _pathSupplier;
    private final Runnable _clearHandler;
    private Map<IFile, Set<String>> _reverseMap;
    private Map<String, FqnCache<IFile>> _filesByExtension;

    public PathCache(IModule module, Supplier<Collection<IDirectory>> pathSupplier, Runnable clearHandler) {
        this._module = module;
        this._pathSupplier = pathSupplier;
        this._clearHandler = clearHandler;
        this._reverseMap = new ConcurrentHashMap<IFile, Set<String>>();
        this.init();
        this._clearer = new CacheClearer();
        this._module.getHost().addTypeSystemListenerAsWeakRef(module, this._clearer);
    }

    private void init() {
        ConcurrentHashMap<String, FqnCache<IFile>> filesByExtension = new ConcurrentHashMap<String, FqnCache<IFile>>();
        for (IDirectory sourceEntry : this._pathSupplier.get()) {
            if (!IFileUtil.hasSourceFiles(sourceEntry)) continue;
            this.addTypesForFiles("", sourceEntry, filesByExtension);
        }
        this._filesByExtension = filesByExtension;
    }

    public Set<IFile> findFiles(String fqn) {
        Set<IFile> result = Collections.emptySet();
        for (String ext : this._filesByExtension.keySet()) {
            IFile file = this._filesByExtension.get(ext).get(fqn);
            if (file == null) continue;
            if (result.isEmpty()) {
                result = new HashSet<IFile>(2);
            }
            result.add(file);
        }
        return result;
    }

    public FqnCache<IFile> getExtensionCache(String extension) {
        FqnCache<IFile> extCache = this._filesByExtension.get(extension.toLowerCase());
        if (extCache == null) {
            extCache = new FqnCache();
            this._filesByExtension.put(extension, extCache);
        }
        return extCache;
    }

    public Map<String, FqnCache<IFile>> getExtensionCaches() {
        return this._filesByExtension;
    }

    public Set<String> getFqnForFile(IFile file) {
        return this._reverseMap.get(file);
    }

    private void addTypesForFiles(String pkg, IDirectory dir, Map<String, FqnCache<IFile>> filesByExtension) {
        if (!this._module.getHost().isPathIgnored(pkg)) {
            String fqn;
            for (IFile iFile : dir.listFiles()) {
                fqn = PathCache.qualifyName(pkg, iFile.getName());
                this.addToExtension(fqn, iFile, filesByExtension);
                this.addToReverseMap(iFile, fqn);
            }
            for (IDirectory iDirectory : dir.listDirs()) {
                if (!this.isValidPackage(iDirectory)) continue;
                fqn = PathCache.qualifyName(pkg, iDirectory.getName());
                this.addTypesForFiles(fqn, iDirectory, filesByExtension);
            }
        }
    }

    private boolean isValidPackage(IDirectory subdir) {
        return ManClassUtil.isJavaIdentifier(subdir.getName());
    }

    private void addToExtension(String fqn, IFile file, Map<String, FqnCache<IFile>> filesByExtension) {
        String ext = file.getExtension().toLowerCase();
        FqnCache<IFile> cache = filesByExtension.get(ext);
        if (cache == null) {
            cache = new FqnCache();
            filesByExtension.put(ext, cache);
        }
        if (!cache.contains(fqn)) {
            cache.add(fqn, file);
        }
    }

    private void removeFromExtension(String fqn, IFile file, Map<String, FqnCache<IFile>> filesByExtension) {
        String ext = file.getExtension().toLowerCase();
        FqnCache<IFile> cache = filesByExtension.get(ext);
        if (cache != null) {
            cache.remove(fqn);
        }
    }

    public static String qualifyName(String pkg, String resourceName) {
        int iDot = resourceName.lastIndexOf(46);
        if (iDot > 0) {
            resourceName = resourceName.substring(0, iDot);
        }
        String fqn = pkg.length() > 0 ? pkg + '.' + ManIdentifierUtil.makeIdentifier(resourceName) : resourceName;
        return fqn;
    }

    private void removeFromReverseMap(IFile file, String fqn) {
        Set<String> fqns = this._reverseMap.get(file);
        if (fqns != null) {
            fqns.remove(fqn);
        }
    }

    private void addToReverseMap(IFile file, String fqn) {
        Set<String> fqns = this._reverseMap.get(file);
        if (fqns == null) {
            fqns = new ConcurrentHashSet<String>();
            this._reverseMap.put(file, fqns);
        }
        fqns.add(fqn);
    }

    public void clear() {
        this._filesByExtension.clear();
        this._reverseMap = new ConcurrentHashMap<IFile, Set<String>>();
    }

    private class CacheClearer
    extends AbstractTypeSystemListener {
        private CacheClearer() {
        }

        @Override
        public boolean notifyEarly() {
            return true;
        }

        @Override
        public void refreshed() {
            PathCache.this.clear();
            PathCache.this._clearHandler.run();
        }

        @Override
        public void refreshedTypes(RefreshRequest request) {
            IModule refreshModule = request.module;
            if (refreshModule != null && refreshModule != PathCache.this._module) {
                return;
            }
            switch (request.kind) {
                case CREATION: {
                    Arrays.stream(request.types).forEach(fqn -> {
                        PathCache.this.addToReverseMap(request.file, fqn);
                        PathCache.this.addToExtension(fqn, request.file, PathCache.this._filesByExtension);
                    });
                    break;
                }
                case DELETION: {
                    Arrays.stream(request.types).forEach(fqn -> {
                        PathCache.this.removeFromReverseMap(request.file, fqn);
                        PathCache.this.removeFromExtension(fqn, request.file, PathCache.this._filesByExtension);
                    });
                    break;
                }
            }
        }
    }
}

