/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Field;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class ScalarLeafs
extends AbstractRule {
    public ScalarLeafs(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        GraphQLOutputType type = this.getValidationContext().getOutputType();
        if (type == null) {
            return;
        }
        if (GraphQLTypeUtil.isLeaf(type)) {
            if (field.getSelectionSet() != null) {
                String message = String.format("Sub selection not allowed on leaf type %s of field %s", type.getName(), field.getName());
                this.addError(ValidationErrorType.SubSelectionNotAllowed, field.getSourceLocation(), message);
            }
        } else if (field.getSelectionSet() == null) {
            String message = String.format("Sub selection required for type %s of field %s", type.getName(), field.getName());
            this.addError(ValidationErrorType.SubSelectionRequired, field.getSourceLocation(), message);
        }
    }
}

