/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.OperationDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NoUnusedFragments
extends AbstractRule {
    private final List<FragmentDefinition> allDeclaredFragments = new ArrayList<FragmentDefinition>();
    private List<String> usedFragments = new ArrayList<String>();
    private final Map<String, List<String>> spreadsInDefinition = new LinkedHashMap<String, List<String>>();
    private final List<List<String>> fragmentsUsedDirectlyInOperation = new ArrayList<List<String>>();

    public NoUnusedFragments(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDefinition) {
        this.usedFragments = new ArrayList<String>();
        this.fragmentsUsedDirectlyInOperation.add(this.usedFragments);
    }

    @Override
    public void checkFragmentSpread(FragmentSpread fragmentSpread) {
        this.usedFragments.add(fragmentSpread.getName());
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        this.allDeclaredFragments.add(fragmentDefinition);
        this.usedFragments = new ArrayList<String>();
        this.spreadsInDefinition.put(fragmentDefinition.getName(), this.usedFragments);
    }

    @Override
    public void documentFinished(Document document) {
        ArrayList<String> allUsedFragments = new ArrayList<String>();
        for (List<String> fragmentsInOneOperation : this.fragmentsUsedDirectlyInOperation) {
            for (String fragment : fragmentsInOneOperation) {
                this.collectUsedFragmentsInDefinition(allUsedFragments, fragment);
            }
        }
        for (FragmentDefinition fragmentDefinition : this.allDeclaredFragments) {
            if (allUsedFragments.contains(fragmentDefinition.getName())) continue;
            String message = String.format("Unused fragment %s", fragmentDefinition.getName());
            this.addError(ValidationErrorType.UnusedFragment, fragmentDefinition.getSourceLocation(), message);
        }
    }

    private void collectUsedFragmentsInDefinition(List<String> result, String fragmentName) {
        if (result.contains(fragmentName)) {
            return;
        }
        result.add(fragmentName);
        List<String> spreadList = this.spreadsInDefinition.get(fragmentName);
        if (spreadList == null) {
            return;
        }
        for (String fragment : spreadList) {
            this.collectUsedFragmentsInDefinition(result, fragment);
        }
    }
}

