/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.PublicApi;
import graphql.util.NodeMultiZipper;
import graphql.util.NodeZipper;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;

@PublicApi
public class TreeTransformerUtil {
    public static <T> TraversalControl changeNode(TraverserContext<T> context, T changedNode) {
        NodeZipper<T> zipperWithChangedNode = context.getVar(NodeZipper.class).withNewNode(changedNode);
        NodeMultiZipper multiZipper = (NodeMultiZipper)context.getNewAccumulate();
        if (context.isChanged()) {
            context.setAccumulate(multiZipper.withReplacedZipperForNode(context.thisNode(), changedNode));
            context.changeNode(changedNode);
        } else {
            context.setAccumulate(multiZipper.withNewZipper(zipperWithChangedNode));
            context.changeNode(changedNode);
        }
        return TraversalControl.CONTINUE;
    }

    public static <T> TraversalControl deleteNode(TraverserContext<T> context) {
        NodeZipper deleteNodeZipper = context.getVar(NodeZipper.class).deleteNode();
        NodeMultiZipper multiZipper = (NodeMultiZipper)context.getNewAccumulate();
        context.setAccumulate(multiZipper.withNewZipper(deleteNodeZipper));
        context.deleteNode();
        return TraversalControl.CONTINUE;
    }

    public static <T> TraversalControl insertAfter(TraverserContext<T> context, T toInsertAfter) {
        NodeZipper<T> insertNodeZipper = context.getVar(NodeZipper.class).insertAfter(toInsertAfter);
        NodeMultiZipper multiZipper = (NodeMultiZipper)context.getNewAccumulate();
        context.setAccumulate(multiZipper.withNewZipper(insertNodeZipper));
        return TraversalControl.CONTINUE;
    }

    public static <T> TraversalControl insertBefore(TraverserContext<T> context, T toInsertBefore) {
        NodeZipper<T> insertNodeZipper = context.getVar(NodeZipper.class).insertBefore(toInsertBefore);
        NodeMultiZipper multiZipper = (NodeMultiZipper)context.getNewAccumulate();
        context.setAccumulate(multiZipper.withNewZipper(insertNodeZipper));
        return TraversalControl.CONTINUE;
    }
}

