/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.Breadcrumb;
import graphql.util.NodeLocation;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class DefaultTraverserContext<T>
implements TraverserContext<T> {
    private final T curNode;
    private T newNode;
    private boolean nodeDeleted;
    private final TraverserContext<T> parent;
    private final Set<T> visited;
    private final Map<Class<?>, Object> vars;
    private final Object sharedContextData;
    private Object newAccValue;
    private boolean hasNewAccValue;
    private Object curAccValue;
    private final NodeLocation location;
    private final boolean isRootContext;
    private Map<String, List<TraverserContext<T>>> children;
    private TraverserContext.Phase phase;

    public DefaultTraverserContext(T curNode, TraverserContext<T> parent, Set<T> visited, Map<Class<?>, Object> vars, Object sharedContextData, NodeLocation location, boolean isRootContext) {
        this.curNode = curNode;
        this.parent = parent;
        this.visited = visited;
        this.vars = vars;
        this.sharedContextData = sharedContextData;
        this.location = location;
        this.isRootContext = isRootContext;
    }

    public static <T> DefaultTraverserContext<T> dummy() {
        return new DefaultTraverserContext<Object>(null, null, null, null, null, null, true);
    }

    public static <T> DefaultTraverserContext<T> simple(T node) {
        return new DefaultTraverserContext<T>(node, null, null, null, null, null, true);
    }

    @Override
    public T thisNode() {
        Assert.assertFalse(this.nodeDeleted, "node is deleted", new Object[0]);
        if (this.newNode != null) {
            return this.newNode;
        }
        return this.curNode;
    }

    @Override
    public T originalThisNode() {
        return this.curNode;
    }

    @Override
    public void changeNode(T newNode) {
        Assert.assertNotNull(newNode);
        Assert.assertFalse(this.nodeDeleted, "node is deleted", new Object[0]);
        this.newNode = newNode;
    }

    @Override
    public void deleteNode() {
        Assert.assertNull(this.newNode, "node is already changed", new Object[0]);
        Assert.assertFalse(this.nodeDeleted, "node is already deleted", new Object[0]);
        this.nodeDeleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.nodeDeleted;
    }

    @Override
    public boolean isChanged() {
        return this.newNode != null;
    }

    @Override
    public TraverserContext<T> getParentContext() {
        return this.parent;
    }

    @Override
    public List<T> getParentNodes() {
        ArrayList<T> result = new ArrayList<T>();
        TraverserContext<T> curContext = this.parent;
        while (!curContext.isRootContext()) {
            result.add(curContext.thisNode());
            curContext = curContext.getParentContext();
        }
        return result;
    }

    @Override
    public List<Breadcrumb<T>> getBreadcrumbs() {
        ArrayList<Breadcrumb<T>> result = new ArrayList<Breadcrumb<T>>();
        TraverserContext<T> curContext = this.parent;
        NodeLocation childLocation = this.location;
        while (!curContext.isRootContext()) {
            result.add(new Breadcrumb<T>(curContext.thisNode(), childLocation));
            childLocation = curContext.getLocation();
            curContext = curContext.getParentContext();
        }
        return result;
    }

    @Override
    public T getParentNode() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.thisNode();
    }

    @Override
    public Set<T> visitedNodes() {
        return this.visited;
    }

    @Override
    public boolean isVisited() {
        return this.visited.contains(this.curNode);
    }

    @Override
    public <S> S getVar(Class<? super S> key) {
        return key.cast(this.vars.get(key));
    }

    @Override
    public <S> TraverserContext<T> setVar(Class<? super S> key, S value) {
        this.vars.put(key, value);
        return this;
    }

    @Override
    public void setAccumulate(Object accumulate) {
        this.hasNewAccValue = true;
        this.newAccValue = accumulate;
    }

    @Override
    public <U> U getNewAccumulate() {
        if (this.hasNewAccValue) {
            return (U)this.newAccValue;
        }
        return (U)this.curAccValue;
    }

    @Override
    public <U> U getCurrentAccumulate() {
        return (U)this.curAccValue;
    }

    @Override
    public Object getSharedContextData() {
        return this.sharedContextData;
    }

    void setCurAccValue(Object curAccValue) {
        this.hasNewAccValue = false;
        this.curAccValue = curAccValue;
    }

    @Override
    public NodeLocation getLocation() {
        return this.location;
    }

    @Override
    public boolean isRootContext() {
        return this.isRootContext;
    }

    @Override
    public <S> S getVarFromParents(Class<? super S> key) {
        for (TraverserContext<T> curContext = this.parent; curContext != null; curContext = curContext.getParentContext()) {
            S var = curContext.getVar(key);
            if (var == null) continue;
            return var;
        }
        return null;
    }

    void setChildrenContexts(Map<String, List<TraverserContext<T>>> children) {
        Assert.assertTrue(this.children == null, "children already set", new Object[0]);
        this.children = children;
    }

    @Override
    public Map<String, List<TraverserContext<T>>> getChildrenContexts() {
        Assert.assertNotNull(this.children, "children not available", new Object[0]);
        return this.children;
    }

    void setPhase(TraverserContext.Phase phase) {
        this.phase = phase;
    }

    @Override
    public TraverserContext.Phase getPhase() {
        return this.phase;
    }
}

