/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.ArgValueOfAllowedTypeChecker;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.DirectiveIllegalLocationError;
import graphql.schema.idl.errors.DirectiveMissingNonNullArgumentError;
import graphql.schema.idl.errors.DirectiveUndeclaredError;
import graphql.schema.idl.errors.DirectiveUnknownArgumentError;
import graphql.util.FpKit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
class SchemaTypeDirectivesChecker {
    private final TypeDefinitionRegistry typeRegistry;
    private final RuntimeWiring runtimeWiring;

    public SchemaTypeDirectivesChecker(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        this.typeRegistry = typeRegistry;
        this.runtimeWiring = runtimeWiring;
    }

    void checkTypeDirectives(List<GraphQLError> errors) {
        this.typeRegistry.objectTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.OBJECT, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.interfaceTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.INTERFACE, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.unionTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.UNION, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.enumTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.ENUM, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.scalarTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.SCALAR, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.inputObjectTypeExtensions().values().forEach(extDefinitions -> extDefinitions.forEach(ext -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_OBJECT, errors, (TypeDefinition<?>)ext)));
        this.typeRegistry.getTypes(ObjectTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.OBJECT, errors, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(InterfaceTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.INTERFACE, errors, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(UnionTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.UNION, errors, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(EnumTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.ENUM, errors, (TypeDefinition<?>)typeDef));
        this.typeRegistry.getTypes(InputObjectTypeDefinition.class).forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_OBJECT, errors, (TypeDefinition<?>)typeDef));
        this.typeRegistry.scalars().values().forEach(typeDef -> this.checkDirectives(Introspection.DirectiveLocation.SCALAR, errors, (TypeDefinition<?>)typeDef));
    }

    private void checkDirectives(Introspection.DirectiveLocation expectedLocation, List<GraphQLError> errors, TypeDefinition<?> typeDef) {
        List<FieldDefinition> fieldDefinitions;
        this.checkDirectives(expectedLocation, errors, this.typeRegistry, typeDef, typeDef.getName(), typeDef.getDirectives());
        if (typeDef instanceof ObjectTypeDefinition) {
            fieldDefinitions = ((ObjectTypeDefinition)typeDef).getFieldDefinitions();
            this.checkFieldsDirectives(errors, this.typeRegistry, fieldDefinitions);
        }
        if (typeDef instanceof InterfaceTypeDefinition) {
            fieldDefinitions = ((InterfaceTypeDefinition)typeDef).getFieldDefinitions();
            this.checkFieldsDirectives(errors, this.typeRegistry, fieldDefinitions);
        }
        if (typeDef instanceof EnumTypeDefinition) {
            List<EnumValueDefinition> enumValueDefinitions = ((EnumTypeDefinition)typeDef).getEnumValueDefinitions();
            enumValueDefinitions.forEach(definition -> this.checkDirectives(Introspection.DirectiveLocation.ENUM_VALUE, errors, this.typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives()));
        }
        if (typeDef instanceof InputObjectTypeDefinition) {
            List<InputValueDefinition> inputValueDefinitions = ((InputObjectTypeDefinition)typeDef).getInputValueDefinitions();
            inputValueDefinitions.forEach(definition -> this.checkDirectives(Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION, errors, this.typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives()));
        }
    }

    private void checkFieldsDirectives(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, List<FieldDefinition> fieldDefinitions) {
        fieldDefinitions.forEach(definition -> {
            this.checkDirectives(Introspection.DirectiveLocation.FIELD_DEFINITION, errors, typeRegistry, (Node<?>)definition, definition.getName(), definition.getDirectives());
            definition.getInputValueDefinitions().forEach(arg -> this.checkDirectives(Introspection.DirectiveLocation.ARGUMENT_DEFINITION, errors, typeRegistry, (Node<?>)arg, arg.getName(), arg.getDirectives()));
        });
    }

    private void checkDirectives(Introspection.DirectiveLocation expectedLocation, List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, Node<?> element, String elementName, List<Directive> directives) {
        directives.forEach(directive -> {
            Optional<DirectiveDefinition> directiveDefinition = typeRegistry.getDirectiveDefinition(directive.getName());
            if (!directiveDefinition.isPresent()) {
                errors.add(new DirectiveUndeclaredError(element, elementName, directive.getName()));
            } else {
                if (!this.inRightLocation(expectedLocation, directiveDefinition.get())) {
                    errors.add(new DirectiveIllegalLocationError(element, elementName, directive.getName(), expectedLocation.name()));
                }
                this.checkDirectiveArguments(errors, typeRegistry, element, elementName, (Directive)directive, directiveDefinition.get());
            }
        });
    }

    private boolean inRightLocation(Introspection.DirectiveLocation expectedLocation, DirectiveDefinition directiveDefinition) {
        List names = directiveDefinition.getDirectiveLocations().stream().map(DirectiveLocation::getName).map(String::toUpperCase).collect(Collectors.toList());
        return names.contains(expectedLocation.name().toUpperCase());
    }

    private void checkDirectiveArguments(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, Node element, String elementName, Directive directive, DirectiveDefinition directiveDefinition) {
        Map<String, InputValueDefinition> allowedArgs = FpKit.getByName(directiveDefinition.getInputValueDefinitions(), InputValueDefinition::getName, FpKit.mergeFirst());
        Map<String, Argument> providedArgs = FpKit.getByName(directive.getArguments(), Argument::getName, FpKit.mergeFirst());
        directive.getArguments().forEach(argument -> {
            InputValueDefinition allowedArg = (InputValueDefinition)allowedArgs.get(argument.getName());
            if (allowedArg == null) {
                errors.add(new DirectiveUnknownArgumentError(element, elementName, directive.getName(), argument.getName()));
            } else {
                ArgValueOfAllowedTypeChecker argValueOfAllowedTypeChecker = new ArgValueOfAllowedTypeChecker(directive, element, elementName, (Argument)argument, typeRegistry, this.runtimeWiring);
                argValueOfAllowedTypeChecker.checkArgValueMatchesAllowedType(errors, argument.getValue(), allowedArg.getType());
            }
        });
        allowedArgs.forEach((argName, definitionArgument) -> {
            if (this.isNoNullArgWithoutDefaultValue((InputValueDefinition)definitionArgument) && !providedArgs.containsKey(argName)) {
                errors.add(new DirectiveMissingNonNullArgumentError(element, elementName, directive.getName(), (String)argName));
            }
        });
    }

    private boolean isNoNullArgWithoutDefaultValue(InputValueDefinition definitionArgument) {
        return definitionArgument.getType() instanceof NonNullType && definitionArgument.getDefaultValue() == null;
    }
}

