/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.language.AstPrinter;
import graphql.language.AstValueHelper;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Document;
import graphql.language.Node;
import graphql.schema.DefaultGraphqlTypeComparatorRegistry;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparatorEnvironment;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public class SchemaPrinter {
    private final Map<Class, TypePrinter<?>> printers = new LinkedHashMap();
    private final Options options;

    public SchemaPrinter() {
        this(Options.defaultOptions());
    }

    public SchemaPrinter(Options options) {
        this.options = options;
        this.printers.put(GraphQLSchema.class, this.schemaPrinter());
        this.printers.put(GraphQLObjectType.class, this.objectPrinter());
        this.printers.put(GraphQLEnumType.class, this.enumPrinter());
        this.printers.put(GraphQLScalarType.class, this.scalarPrinter());
        this.printers.put(GraphQLInterfaceType.class, this.interfacePrinter());
        this.printers.put(GraphQLUnionType.class, this.unionPrinter());
        this.printers.put(GraphQLInputObjectType.class, this.inputObjectPrinter());
    }

    public String print(Document schemaIDL) {
        TypeDefinitionRegistry registry = new SchemaParser().buildRegistry(schemaIDL);
        return this.print(UnExecutableSchemaGenerator.makeUnExecutableSchema(registry));
    }

    public String print(GraphQLSchema schema) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        GraphqlFieldVisibility visibility = schema.getCodeRegistry().getFieldVisibility();
        this.printer(schema.getClass()).print(out, schema, visibility);
        List<GraphQLType> typesAsList = schema.getAllTypesAsList().stream().sorted(Comparator.comparing(GraphQLType::getName)).collect(Collectors.toList());
        this.printType(out, typesAsList, GraphQLInterfaceType.class, visibility);
        this.printType(out, typesAsList, GraphQLUnionType.class, visibility);
        this.printType(out, typesAsList, GraphQLObjectType.class, visibility);
        this.printType(out, typesAsList, GraphQLEnumType.class, visibility);
        this.printType(out, typesAsList, GraphQLScalarType.class, visibility);
        this.printType(out, typesAsList, GraphQLInputObjectType.class, visibility);
        String result = sw.toString();
        if (result.endsWith("\n\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private boolean isIntrospectionType(GraphQLType type) {
        return !this.options.isIncludeIntrospectionTypes() && type.getName().startsWith("__");
    }

    private TypePrinter<GraphQLScalarType> scalarPrinter() {
        return (out, type, visibility) -> {
            boolean printScalar;
            if (!this.options.isIncludeScalars()) {
                return;
            }
            if (ScalarInfo.isStandardScalar(type)) {
                printScalar = false;
                if (this.options.isIncludeExtendedScalars() && !ScalarInfo.isGraphqlSpecifiedScalar(type)) {
                    printScalar = true;
                }
            } else {
                printScalar = true;
            }
            if (printScalar) {
                this.printComments(out, type, "");
                out.format("scalar %s%s\n\n", type.getName(), this.directivesString(GraphQLScalarType.class, type.getDirectives()));
            }
        };
    }

    private TypePrinter<GraphQLEnumType> enumPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLEnumType.class).elementType(GraphQLEnumValueDefinition.class).build();
            Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
            this.printComments(out, type, "");
            out.format("enum %s%s {\n", type.getName(), this.directivesString(GraphQLEnumType.class, type.getDirectives()));
            List values = type.getValues().stream().sorted(comparator).collect(Collectors.toList());
            for (GraphQLEnumValueDefinition enumValueDefinition : values) {
                this.printComments(out, enumValueDefinition, "  ");
                out.format("  %s%s\n", enumValueDefinition.getName(), this.directivesString(GraphQLEnumValueDefinition.class, enumValueDefinition.getDirectives()));
            }
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInterfaceType> interfacePrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLInterfaceType.class).elementType(GraphQLFieldDefinition.class).build();
            Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
            this.printComments(out, type, "");
            out.format("interface %s%s {\n", type.getName(), this.directivesString(GraphQLInterfaceType.class, type.getDirectives()));
            visibility.getFieldDefinitions((GraphQLFieldsContainer)type).stream().sorted(comparator).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s%s: %s%s\n", fd.getName(), this.argsString(GraphQLFieldDefinition.class, fd.getArguments()), this.typeString(fd.getType()), this.directivesString(GraphQLFieldDefinition.class, fd.getDirectives()));
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLUnionType> unionPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLUnionType.class).elementType(GraphQLOutputType.class).build();
            Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
            this.printComments(out, type, "");
            out.format("union %s%s = ", type.getName(), this.directivesString(GraphQLUnionType.class, type.getDirectives()));
            List types = type.getTypes().stream().sorted(comparator).collect(Collectors.toList());
            for (int i = 0; i < types.size(); ++i) {
                GraphQLOutputType objectType = (GraphQLOutputType)types.get(i);
                if (i > 0) {
                    out.format(" | ", new Object[0]);
                }
                out.format("%s", objectType.getName());
            }
            out.format("\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLObjectType> objectPrinter() {
        return (out, type, visibility) -> {
            GraphqlTypeComparatorEnvironment environment;
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            if (type.getInterfaces().isEmpty()) {
                out.format("type %s%s {\n", type.getName(), this.directivesString(GraphQLObjectType.class, type.getDirectives()));
            } else {
                environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLObjectType.class).elementType(GraphQLOutputType.class).build();
                Comparator implementsComparator = this.options.comparatorRegistry.getComparator(environment);
                Stream<String> interfaceNames = type.getInterfaces().stream().sorted(implementsComparator).map(GraphQLType::getName);
                out.format("type %s implements %s%s {\n", type.getName(), interfaceNames.collect(Collectors.joining(" & ")), this.directivesString(GraphQLObjectType.class, type.getDirectives()));
            }
            environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLObjectType.class).elementType(GraphQLFieldDefinition.class).build();
            Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
            visibility.getFieldDefinitions((GraphQLFieldsContainer)type).stream().sorted(comparator).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s%s: %s%s\n", fd.getName(), this.argsString(GraphQLFieldDefinition.class, fd.getArguments()), this.typeString(fd.getType()), this.directivesString(GraphQLFieldDefinition.class, fd.getDirectives()));
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private TypePrinter<GraphQLInputObjectType> inputObjectPrinter() {
        return (out, type, visibility) -> {
            if (this.isIntrospectionType((GraphQLType)type)) {
                return;
            }
            this.printComments(out, type, "");
            GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLInputObjectType.class).elementType(GraphQLInputObjectField.class).build();
            Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
            out.format("input %s%s {\n", type.getName(), this.directivesString(GraphQLInputObjectType.class, type.getDirectives()));
            visibility.getFieldDefinitions((GraphQLInputFieldsContainer)type).stream().sorted(comparator).forEach(fd -> {
                this.printComments(out, fd, "  ");
                out.format("  %s: %s", fd.getName(), this.typeString(fd.getType()));
                Object defaultValue = fd.getDefaultValue();
                if (defaultValue != null) {
                    String astValue = SchemaPrinter.printAst(defaultValue, fd.getType());
                    out.format(" = %s", astValue);
                }
                out.format(this.directivesString(GraphQLInputObjectField.class, fd.getDirectives()), new Object[0]);
                out.format("\n", new Object[0]);
            });
            out.format("}\n\n", new Object[0]);
        };
    }

    private static String printAst(Object value, GraphQLInputType type) {
        return AstPrinter.printAst(AstValueHelper.astFromValue(value, type));
    }

    private TypePrinter<GraphQLSchema> schemaPrinter() {
        return (out, schema, visibility) -> {
            GraphQLObjectType queryType = schema.getQueryType();
            GraphQLObjectType mutationType = schema.getMutationType();
            GraphQLObjectType subscriptionType = schema.getSubscriptionType();
            boolean needsSchemaPrinted = this.options.includeSchemaDefinition;
            if (!needsSchemaPrinted) {
                if (queryType != null && !queryType.getName().equals("Query")) {
                    needsSchemaPrinted = true;
                }
                if (mutationType != null && !mutationType.getName().equals("Mutation")) {
                    needsSchemaPrinted = true;
                }
                if (subscriptionType != null && !subscriptionType.getName().equals("Subscription")) {
                    needsSchemaPrinted = true;
                }
            }
            if (needsSchemaPrinted) {
                out.format("schema {\n", new Object[0]);
                if (queryType != null) {
                    out.format("  query: %s\n", queryType.getName());
                }
                if (mutationType != null) {
                    out.format("  mutation: %s\n", mutationType.getName());
                }
                if (subscriptionType != null) {
                    out.format("  subscription: %s\n", subscriptionType.getName());
                }
                out.format("}\n\n", new Object[0]);
            }
            if (this.options.includeDirectives) {
                out.format("%s", this.directiveDefinitions(this.getDirectives((GraphQLSchema)schema)));
            }
        };
    }

    private List<GraphQLDirective> getDirectives(GraphQLSchema schema) {
        List<String> standardDirectives = Arrays.asList("skip", "include", "defer", "deprecated");
        Predicate<GraphQLDirective> standard = directive -> standardDirectives.contains(directive.getName());
        return schema.getDirectives().stream().filter(standard.negate()).collect(Collectors.toList());
    }

    String typeString(GraphQLType rawType) {
        return GraphQLTypeUtil.simplePrint(rawType);
    }

    String argsString(List<GraphQLArgument> arguments) {
        return this.argsString(null, arguments);
    }

    String argsString(Class<? extends GraphQLType> parent, List<GraphQLArgument> arguments) {
        boolean hasDescriptions = arguments.stream().anyMatch(arg -> !SchemaPrinter.isNullOrEmpty(arg.getDescription()));
        String halfPrefix = hasDescriptions ? "  " : "";
        String prefix = hasDescriptions ? "    " : "";
        int count = 0;
        StringBuilder sb = new StringBuilder();
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(parent).elementType(GraphQLArgument.class).build();
        Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
        arguments = arguments.stream().sorted(comparator).collect(Collectors.toList());
        for (GraphQLArgument argument : arguments) {
            String description;
            if (count == 0) {
                sb.append("(");
            } else {
                sb.append(", ");
            }
            if (hasDescriptions) {
                sb.append("\n");
            }
            if (!SchemaPrinter.isNullOrEmpty(description = argument.getDescription())) {
                String[] descriptionSplitByNewlines = description.split("\n");
                Stream<String> stream = Arrays.stream(descriptionSplitByNewlines);
                if (descriptionSplitByNewlines.length > 1) {
                    String multiLineComment = "\"\"\"";
                    stream = Stream.concat(Stream.of(multiLineComment), stream);
                    stream = Stream.concat(stream, Stream.of(multiLineComment));
                    stream.map(s -> prefix + s + "\n").forEach(sb::append);
                } else {
                    stream.map(s -> prefix + "#" + s + "\n").forEach(sb::append);
                }
            }
            sb.append(prefix).append(argument.getName()).append(": ").append(this.typeString(argument.getType()));
            Object defaultValue = argument.getDefaultValue();
            if (defaultValue != null) {
                sb.append(" = ");
                sb.append(SchemaPrinter.printAst(defaultValue, argument.getType()));
            }
            argument.getDirectives().stream().map(this::directiveString).filter(it -> !it.isEmpty()).forEach(directiveString -> sb.append(" ").append((String)directiveString));
            ++count;
        }
        if (count > 0) {
            if (hasDescriptions) {
                sb.append("\n");
            }
            sb.append(halfPrefix).append(")");
        }
        return sb.toString();
    }

    String directivesString(Class<? extends GraphQLType> parent, List<GraphQLDirective> directives) {
        if (!this.options.includeDirectives) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!directives.isEmpty()) {
            sb.append(" ");
        }
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(parent).elementType(GraphQLDirective.class).build();
        Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
        directives = directives.stream().sorted(comparator).collect(Collectors.toList());
        for (int i = 0; i < directives.size(); ++i) {
            GraphQLDirective directive = directives.get(i);
            sb.append(this.directiveString(directive));
            if (i >= directives.size() - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private String directiveString(GraphQLDirective directive) {
        if (!this.options.includeDirectives) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(directive.getName());
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLDirective.class).elementType(GraphQLArgument.class).build();
        Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
        List<GraphQLArgument> args = directive.getArguments();
        args = args.stream().sorted(comparator).collect(Collectors.toList());
        if (!args.isEmpty()) {
            sb.append("(");
            for (int i = 0; i < args.size(); ++i) {
                GraphQLArgument arg = args.get(i);
                sb.append(arg.getName());
                if (arg.getValue() != null) {
                    sb.append(" : ");
                    sb.append(SchemaPrinter.printAst(arg.getValue(), arg.getType()));
                } else if (arg.getDefaultValue() != null) {
                    sb.append(" : ");
                    sb.append(SchemaPrinter.printAst(arg.getDefaultValue(), arg.getType()));
                }
                if (i >= args.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private String directiveDefinitions(List<GraphQLDirective> directives) {
        StringBuilder sb = new StringBuilder();
        for (GraphQLDirective directive : directives) {
            sb.append(this.directiveDefinition(directive));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private String directiveDefinition(GraphQLDirective directive) {
        StringBuilder sb = new StringBuilder();
        StringWriter sw = new StringWriter();
        this.printComments(new PrintWriter(sw), directive, "");
        sb.append(sw.toString());
        sb.append("directive @").append(directive.getName());
        GraphqlTypeComparatorEnvironment environment = GraphqlTypeComparatorEnvironment.newEnvironment().parentType(GraphQLDirective.class).elementType(GraphQLArgument.class).build();
        Comparator comparator = this.options.comparatorRegistry.getComparator(environment);
        List<GraphQLArgument> args = directive.getArguments();
        args = args.stream().sorted(comparator).collect(Collectors.toList());
        sb.append(this.argsString(GraphQLDirective.class, args));
        sb.append(" on ");
        String locations = directive.validLocations().stream().map(Enum::name).collect(Collectors.joining(" | "));
        sb.append(locations);
        return sb.toString();
    }

    private <T> TypePrinter<T> printer(Class<?> clazz) {
        TypePrinter typePrinter = this.printers.computeIfAbsent(clazz, k -> {
            Class superClazz = clazz.getSuperclass();
            TypePrinter<Object> result = superClazz != Object.class ? this.printer(superClazz) : (out, type, visibility) -> out.println("Type not implemented : " + type);
            return result;
        });
        return typePrinter;
    }

    public String print(GraphQLType type) {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.printType(out, type, DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY);
        return sw.toString();
    }

    private void printType(PrintWriter out, List<GraphQLType> typesAsList, Class typeClazz, GraphqlFieldVisibility visibility) {
        typesAsList.stream().filter(type -> typeClazz.isAssignableFrom(type.getClass())).forEach(type -> this.printType(out, (GraphQLType)type, visibility));
    }

    private void printType(PrintWriter out, GraphQLType type, GraphqlFieldVisibility visibility) {
        TypePrinter<GraphQLType> printer = this.printer(type.getClass());
        printer.print(out, type, visibility);
    }

    private void printComments(PrintWriter out, Object graphQLType, String prefix) {
        AstDescriptionAndComments descriptionAndComments = this.getDescriptionAndComments(graphQLType);
        if (descriptionAndComments == null) {
            return;
        }
        Description astDescription = descriptionAndComments.descriptionAst;
        if (astDescription != null) {
            String quoteStr = "\"";
            if (astDescription.isMultiLine()) {
                quoteStr = "\"\"\"";
            }
            out.write(prefix);
            out.write(quoteStr);
            out.write(astDescription.getContent());
            out.write(quoteStr);
            out.write("\n");
            return;
        }
        if (descriptionAndComments.comments != null) {
            descriptionAndComments.comments.forEach(cmt -> {
                String commentText = cmt.getContent() == null ? "" : cmt.getContent();
                List<String> lines = Arrays.asList(commentText.split("\n"));
                lines.forEach(t -> {
                    out.write(prefix);
                    out.write("#");
                    out.write(commentText);
                    out.write("\n");
                });
            });
        } else {
            String runtimeDescription = descriptionAndComments.runtimeDescription;
            if (!SchemaPrinter.isNullOrEmpty(runtimeDescription)) {
                Stream<String> stream = Arrays.stream(runtimeDescription.split("\n"));
                stream.map(s -> prefix + "#" + s + "\n").forEach(out::write);
            }
        }
    }

    private AstDescriptionAndComments getDescriptionAndComments(Object descriptionHolder) {
        if (descriptionHolder instanceof GraphQLObjectType) {
            GraphQLObjectType type = (GraphQLObjectType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLEnumType) {
            GraphQLEnumType type = (GraphQLEnumType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLFieldDefinition) {
            GraphQLFieldDefinition type = (GraphQLFieldDefinition)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLEnumValueDefinition) {
            GraphQLEnumValueDefinition type = (GraphQLEnumValueDefinition)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, () -> null, () -> null);
        }
        if (descriptionHolder instanceof GraphQLUnionType) {
            GraphQLUnionType type = (GraphQLUnionType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType type = (GraphQLInputObjectType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLInputObjectField) {
            GraphQLInputObjectField type = (GraphQLInputObjectField)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLInterfaceType) {
            GraphQLInterfaceType type = (GraphQLInterfaceType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLScalarType) {
            GraphQLScalarType type = (GraphQLScalarType)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLArgument) {
            GraphQLArgument type = (GraphQLArgument)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, type::getDefinition, () -> type.getDefinition().getDescription());
        }
        if (descriptionHolder instanceof GraphQLDirective) {
            GraphQLDirective type = (GraphQLDirective)descriptionHolder;
            return this.descriptionAndComments(type::getDescription, () -> null, () -> null);
        }
        return (AstDescriptionAndComments)Assert.assertShouldNeverHappen();
    }

    AstDescriptionAndComments descriptionAndComments(Supplier<String> runtimeDescriptionSupplier, Supplier<Node> nodeSupplier, Supplier<Description> descriptionSupplier) {
        String runtimeDesc = runtimeDescriptionSupplier.get();
        Node node = nodeSupplier.get();
        Description description = null;
        List<Comment> comments = null;
        if (node != null) {
            comments = node.getComments();
            description = descriptionSupplier.get();
        }
        return new AstDescriptionAndComments(runtimeDesc, description, comments);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static class AstDescriptionAndComments {
        String runtimeDescription;
        Description descriptionAst;
        List<Comment> comments;

        public AstDescriptionAndComments(String runtimeDescription, Description descriptionAst, List<Comment> comments) {
            this.runtimeDescription = runtimeDescription;
            this.descriptionAst = descriptionAst;
            this.comments = comments;
        }
    }

    private static interface TypePrinter<T> {
        public void print(PrintWriter var1, T var2, GraphqlFieldVisibility var3);
    }

    public static class Options {
        private final boolean includeIntrospectionTypes;
        private final boolean includeScalars;
        private final boolean includeExtendedScalars;
        private final boolean includeSchemaDefinition;
        private final boolean includeDirectives;
        private final GraphqlTypeComparatorRegistry comparatorRegistry;

        private Options(boolean includeIntrospectionTypes, boolean includeScalars, boolean includeExtendedScalars, boolean includeSchemaDefinition, boolean includeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry) {
            this.includeIntrospectionTypes = includeIntrospectionTypes;
            this.includeScalars = includeScalars;
            this.includeExtendedScalars = includeExtendedScalars;
            this.includeSchemaDefinition = includeSchemaDefinition;
            this.includeDirectives = includeDirectives;
            this.comparatorRegistry = comparatorRegistry;
        }

        public boolean isIncludeIntrospectionTypes() {
            return this.includeIntrospectionTypes;
        }

        public boolean isIncludeScalars() {
            return this.includeScalars;
        }

        public boolean isIncludeExtendedScalars() {
            return this.includeExtendedScalars;
        }

        public boolean isIncludeSchemaDefinition() {
            return this.includeSchemaDefinition;
        }

        public boolean isIncludeDirectives() {
            return this.includeDirectives;
        }

        public static Options defaultOptions() {
            return new Options(false, false, false, false, true, DefaultGraphqlTypeComparatorRegistry.defaultComparators());
        }

        public Options includeIntrospectionTypes(boolean flag) {
            return new Options(flag, this.includeScalars, this.includeExtendedScalars, this.includeSchemaDefinition, this.includeDirectives, this.comparatorRegistry);
        }

        public Options includeScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, flag, this.includeExtendedScalars, this.includeSchemaDefinition, this.includeDirectives, this.comparatorRegistry);
        }

        public Options includeExtendedScalarTypes(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, flag, this.includeSchemaDefinition, this.includeDirectives, this.comparatorRegistry);
        }

        public Options includeSchemaDefintion(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeExtendedScalars, flag, this.includeDirectives, this.comparatorRegistry);
        }

        public Options includeDirectives(boolean flag) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeExtendedScalars, this.includeSchemaDefinition, flag, this.comparatorRegistry);
        }

        public Options setComparators(GraphqlTypeComparatorRegistry comparatorRegistry) {
            return new Options(this.includeIntrospectionTypes, this.includeScalars, this.includeExtendedScalars, this.includeSchemaDefinition, this.includeDirectives, comparatorRegistry);
        }

        public GraphqlTypeComparatorRegistry getComparatorRegistry() {
            return this.comparatorRegistry;
        }
    }
}

