/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLType;
import java.util.function.Consumer;

@PublicApi
public class GraphqlTypeComparatorEnvironment {
    private Class<? extends GraphQLType> parentType;
    private Class<? extends GraphQLType> elementType;

    private GraphqlTypeComparatorEnvironment(Class<? extends GraphQLType> parentType, Class<? extends GraphQLType> elementType) {
        Assert.assertNotNull(elementType, "elementType can't be null", new Object[0]);
        this.parentType = parentType;
        this.elementType = elementType;
    }

    public Class<? extends GraphQLType> getParentType() {
        return this.parentType;
    }

    public Class<? extends GraphQLType> getElementType() {
        return this.elementType;
    }

    public GraphqlTypeComparatorEnvironment transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphqlTypeComparatorEnvironment.newEnvironment(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphqlTypeComparatorEnvironment that = (GraphqlTypeComparatorEnvironment)o;
        if (this.parentType != null ? !this.parentType.equals(that.parentType) : that.parentType != null) {
            return false;
        }
        return this.elementType.equals(that.elementType);
    }

    public int hashCode() {
        int result = this.parentType != null ? this.parentType.hashCode() : 0;
        result = 31 * result + this.elementType.hashCode();
        return result;
    }

    public static Builder newEnvironment() {
        return new Builder();
    }

    public static Builder newEnvironment(GraphqlTypeComparatorEnvironment existing) {
        return new Builder(existing);
    }

    public static class Builder {
        private Class<? extends GraphQLType> parentType;
        private Class<? extends GraphQLType> elementType;

        public Builder() {
        }

        public Builder(GraphqlTypeComparatorEnvironment existing) {
            this.parentType = existing.parentType;
            this.elementType = existing.elementType;
        }

        public <T extends GraphQLType> Builder parentType(Class<T> parentType) {
            this.parentType = parentType;
            return this;
        }

        public <T extends GraphQLType> Builder elementType(Class<T> elementType) {
            this.elementType = elementType;
            return this;
        }

        public GraphqlTypeComparatorEnvironment build() {
            return new GraphqlTypeComparatorEnvironment(this.parentType, this.elementType);
        }
    }
}

