/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.UnionTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.TypeResolver;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLUnionType
implements GraphQLType,
GraphQLOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private List<GraphQLOutputType> types;
    private final TypeResolver typeResolver;
    private final UnionTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    @Deprecated
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver) {
        this(name, description, types, typeResolver, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver, List<GraphQLDirective> directives, UnionTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(types, "types can't be null", new Object[0]);
        Assert.assertNotEmpty(types, "A Union type must define one or more member types.", new Object[0]);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.types = types;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.directives = directives;
    }

    void replaceTypes(List<GraphQLOutputType> types) {
        this.types = types;
    }

    public List<GraphQLOutputType> getTypes() {
        return new ArrayList<GraphQLOutputType>(this.types);
    }

    TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UnionTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public GraphQLUnionType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLUnionType.newUnionType(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLType> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLUnionType(this, context);
    }

    @Override
    public List<GraphQLType> getChildren() {
        ArrayList<GraphQLType> children = new ArrayList<GraphQLType>(this.types);
        children.addAll(this.directives);
        return children;
    }

    public static Builder newUnionType() {
        return new Builder();
    }

    public static Builder newUnionType(GraphQLUnionType existing) {
        return new Builder(existing);
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private TypeResolver typeResolver;
        private UnionTypeDefinition definition;
        private final Map<String, GraphQLOutputType> types = new LinkedHashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLUnionType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.typeResolver = existing.getTypeResolver();
            this.definition = existing.getDefinition();
            this.types.putAll(FpKit.getByName(existing.getTypes(), GraphQLType::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(UnionTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Deprecated
        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder possibleType(GraphQLObjectType type) {
            Assert.assertNotNull(type, "possible type can't be null", new Object[0]);
            this.types.put(type.getName(), type);
            return this;
        }

        public Builder possibleType(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, "reference can't be null", new Object[0]);
            this.types.put(reference.getName(), reference);
            return this;
        }

        public Builder possibleTypes(GraphQLObjectType ... type) {
            for (GraphQLObjectType graphQLType : type) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public Builder possibleTypes(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.possibleType(reference);
            }
            return this;
        }

        public Builder clearPossibleTypes() {
            this.types.clear();
            return this;
        }

        public boolean containType(String name) {
            return this.types.containsKey(name);
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLUnionType build() {
            return new GraphQLUnionType(this.name, this.description, this.sort(this.types, GraphQLUnionType.class, GraphQLOutputType.class), this.typeResolver, this.sort(this.directives, GraphQLUnionType.class, GraphQLDirective.class), this.definition);
        }
    }
}

