/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.nextgen;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.FetchedValue;
import graphql.execution.MergedField;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@Internal
public class FetchedValueAnalysis {
    private final FetchedValueType valueType;
    private final List<GraphQLError> errors;
    private final Object completedValue;
    private final boolean nullValue;
    private final List<FetchedValueAnalysis> children;
    private final GraphQLObjectType resolvedType;
    private final ExecutionStepInfo executionStepInfo;
    private final FetchedValue fetchedValue;

    private FetchedValueAnalysis(Builder builder) {
        this.errors = new ArrayList<GraphQLError>(builder.errors);
        this.errors.addAll(builder.fetchedValue.getErrors());
        this.valueType = Assert.assertNotNull(builder.valueType);
        this.completedValue = builder.completedValue;
        this.nullValue = builder.nullValue;
        this.children = builder.children;
        this.resolvedType = builder.resolvedType;
        this.executionStepInfo = Assert.assertNotNull(builder.executionInfo);
        this.fetchedValue = Assert.assertNotNull(builder.fetchedValue);
    }

    public FetchedValueType getValueType() {
        return this.valueType;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public Object getCompletedValue() {
        return this.completedValue;
    }

    public List<FetchedValueAnalysis> getChildren() {
        return this.children;
    }

    public boolean isNullValue() {
        return this.nullValue;
    }

    public FetchedValue getFetchedValue() {
        return this.fetchedValue;
    }

    public FetchedValueAnalysis transfrom(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newFetchedValueAnalysis() {
        return new Builder();
    }

    public static Builder newFetchedValueAnalysis(FetchedValueType valueType) {
        return new Builder().valueType(valueType);
    }

    public static Builder newFetchedValueAnalysis(FetchedValueAnalysis existing) {
        return new Builder(existing);
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public GraphQLObjectType getResolvedType() {
        return this.resolvedType;
    }

    public MergedField getField() {
        return this.executionStepInfo.getField();
    }

    public String getResultKey() {
        return this.executionStepInfo.getResultKey();
    }

    public String toString() {
        return "{valueType=" + (Object)((Object)this.valueType) + ", completedValue=" + this.completedValue + ", errors=" + this.errors + ", children=" + this.children + ", stepInfo=" + this.executionStepInfo + ", nullValue=" + this.nullValue + ", resolvedType=" + this.resolvedType + ", fetchedValue=" + this.fetchedValue + '}';
    }

    public static final class Builder {
        private FetchedValueType valueType;
        private final List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private Object completedValue;
        private FetchedValue fetchedValue;
        private List<FetchedValueAnalysis> children;
        private GraphQLObjectType resolvedType;
        private boolean nullValue;
        private ExecutionStepInfo executionInfo;

        private Builder() {
        }

        private Builder(FetchedValueAnalysis existing) {
            this.valueType = existing.getValueType();
            this.errors.addAll(existing.getErrors());
            this.completedValue = existing.getCompletedValue();
            this.fetchedValue = existing.getFetchedValue();
            this.children = existing.getChildren();
            this.nullValue = existing.isNullValue();
            this.resolvedType = existing.getResolvedType();
            this.executionInfo = existing.getExecutionStepInfo();
        }

        public Builder valueType(FetchedValueType val) {
            this.valueType = val;
            return this;
        }

        public Builder errors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder error(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder completedValue(Object completedValue) {
            this.completedValue = completedValue;
            return this;
        }

        public Builder children(List<FetchedValueAnalysis> children) {
            this.children = children;
            return this;
        }

        public Builder nullValue() {
            this.nullValue = true;
            return this;
        }

        public Builder resolvedType(GraphQLObjectType resolvedType) {
            this.resolvedType = resolvedType;
            return this;
        }

        public Builder executionStepInfo(ExecutionStepInfo executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public Builder fetchedValue(FetchedValue fetchedValue) {
            this.fetchedValue = fetchedValue;
            return this;
        }

        public FetchedValueAnalysis build() {
            return new FetchedValueAnalysis(this);
        }
    }

    public static enum FetchedValueType {
        OBJECT,
        LIST,
        SCALAR,
        ENUM,
        DEFER;

    }
}

