/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.PublicApi;
import graphql.cachecontrol.CacheControl;
import graphql.execution.ExecutionId;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import manifold.shade.org.dataloader.DataLoaderRegistry;

@PublicApi
public class ExecutionInput {
    private final String query;
    private final String operationName;
    private final Object context;
    private final Object root;
    private final Map<String, Object> variables;
    private final DataLoaderRegistry dataLoaderRegistry;
    private final CacheControl cacheControl;
    private final ExecutionId executionId;

    public ExecutionInput(String query, String operationName, Object context, Object root, Map<String, Object> variables) {
        this(query, operationName, context, root, variables, new DataLoaderRegistry(), null, null);
    }

    @Internal
    private ExecutionInput(String query, String operationName, Object context, Object root, Map<String, Object> variables, DataLoaderRegistry dataLoaderRegistry, CacheControl cacheControl, ExecutionId executionId) {
        this.query = query;
        this.operationName = operationName;
        this.context = context;
        this.root = root;
        this.variables = variables;
        this.dataLoaderRegistry = dataLoaderRegistry;
        this.cacheControl = cacheControl;
        this.executionId = executionId;
    }

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRoot() {
        return this.root;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public ExecutionId getExecutionId() {
        return this.executionId;
    }

    public ExecutionInput transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().query(this.query).operationName(this.operationName).context(this.context).root(this.root).dataLoaderRegistry(this.dataLoaderRegistry).cacheControl(this.cacheControl).variables(this.variables).executionId(this.executionId);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return "ExecutionInput{query='" + this.query + '\'' + ", operationName='" + this.operationName + '\'' + ", context=" + this.context + ", root=" + this.root + ", variables=" + this.variables + ", dataLoaderRegistry=" + this.dataLoaderRegistry + ", executionId= " + this.executionId + '}';
    }

    public static Builder newExecutionInput() {
        return new Builder();
    }

    public static Builder newExecutionInput(String query) {
        return new Builder().query(query);
    }

    public static class Builder {
        private String query;
        private String operationName;
        private Object context = GraphQLContext.newContext().build();
        private Object root;
        private Map<String, Object> variables = Collections.emptyMap();
        private DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        private CacheControl cacheControl = CacheControl.newCacheControl();
        private ExecutionId executionId = null;

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder executionId(ExecutionId executionId) {
            this.executionId = executionId;
            return this;
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public Builder context(GraphQLContext.Builder contextBuilder) {
            this.context = contextBuilder.build();
            return this;
        }

        public Builder context(UnaryOperator<GraphQLContext.Builder> contextBuilderFunction) {
            GraphQLContext.Builder builder = GraphQLContext.newContext();
            builder = (GraphQLContext.Builder)contextBuilderFunction.apply(builder);
            return this.context(builder.build());
        }

        public Builder root(Object root) {
            this.root = root;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Builder dataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
            this.dataLoaderRegistry = Assert.assertNotNull(dataLoaderRegistry);
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            this.cacheControl = Assert.assertNotNull(cacheControl);
            return this;
        }

        public ExecutionInput build() {
            return new ExecutionInput(this.query, this.operationName, this.context, this.root, this.variables, this.dataLoaderRegistry, this.cacheControl, this.executionId);
        }
    }
}

