/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.util.List;
import javax.script.Bindings;
import manifold.util.ManEscapeUtil;
import manifold.util.ReservedWordMapping;

public class JsonUtil {
    public static String makeIdentifier(String name) {
        String identifier = ReservedWordMapping.getIdentifierForName(name);
        if (!identifier.equals(name)) {
            return identifier;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == '$' || (i == 0 ? Character.isLetter(c) : Character.isLetterOrDigit(c))) {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toJson(Bindings thisBindings) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.toJson(thisBindings, sb, 0);
        return sb.toString();
    }

    public static void toJson(Bindings thisBindings, StringBuilder sb, int indent) {
        int iKey = 0;
        if (JsonUtil.isNewLine(sb)) {
            JsonUtil.indent(sb, indent);
        }
        if (thisBindings.size() > 0) {
            sb.append("{\n");
            for (String key : thisBindings.keySet()) {
                JsonUtil.indent(sb, indent + 2);
                sb.append('\"').append(key).append('\"').append(": ");
                Object value = thisBindings.get(key);
                if (value instanceof Bindings) {
                    JsonUtil.toJson((Bindings)value, sb, indent + 2);
                } else if (value instanceof List) {
                    JsonUtil.listToJson(sb, indent, (List)value);
                } else {
                    JsonUtil.appendValue(sb, value);
                }
                JsonUtil.appendCommaNewLine(sb, iKey < thisBindings.size() - 1);
                ++iKey;
            }
        }
        JsonUtil.indent(sb, indent);
        sb.append("}");
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder sb, int indent, List value) {
        sb.append('[');
        if (value.size() > 0) {
            sb.append("\n");
            int iSize = value.size();
            for (int i = 0; i < iSize; ++i) {
                Object comp = value.get(i);
                if (comp instanceof Bindings) {
                    JsonUtil.toJson((Bindings)comp, sb, indent + 4);
                } else if (comp instanceof List) {
                    JsonUtil.listToJson(sb, indent + 4, (List)comp);
                } else {
                    JsonUtil.indent(sb, indent + 4);
                    JsonUtil.appendValue(sb, comp);
                }
                JsonUtil.appendCommaNewLine(sb, i < iSize - 1);
            }
        }
        JsonUtil.indent(sb, indent + 2);
        sb.append("]");
    }

    public static String listToJson(List list) {
        StringBuilder sb = new StringBuilder();
        JsonUtil.listToJson(sb, 0, list);
        return sb.toString();
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public static StringBuilder appendValue(StringBuilder sb, Object comp) {
        if (comp instanceof String) {
            sb.append('\"');
            sb.append(ManEscapeUtil.escapeForGosuStringLiteral((String)comp));
            sb.append('\"');
        } else if (comp instanceof Integer || comp instanceof Long || comp instanceof Double || comp instanceof Float || comp instanceof Short || comp instanceof Character || comp instanceof Byte) {
            sb.append(comp);
        } else if (comp == null) {
            sb.append("null");
        } else {
            throw new IllegalStateException("Unsupported expando type: " + comp.getClass());
        }
        return sb;
    }
}

