/*
 * Decompiled with CFR 0.152.
 */
package manifold.templates.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import manifold.internal.javac.IIssue;
import manifold.templates.manifold.TemplateIssue;
import manifold.templates.manifold.TemplateIssueContainer;
import manifold.templates.tokenizer.Token;
import manifold.templates.tokenizer.Tokenizer;

public class TemplateGen {
    private static final String BASE_CLASS_NAME = "BaseTemplate";
    private static final String LAYOUT_INTERFACE = "ILayout";
    private List<TemplateIssue> _issues = new ArrayList<TemplateIssue>();

    public String generateCode(String fullyQualifiedName, String source, String fileName) {
        FileGenerator generator = new FileGenerator(fullyQualifiedName, fileName, source);
        return generator.getFileContents();
    }

    private void addError(String message, int line) {
        TemplateIssue error = new TemplateIssue(IIssue.Kind.Error, 0, line, 0, message);
        this._issues.add(error);
    }

    public TemplateIssueContainer getIssues() {
        return new TemplateIssueContainer(this._issues);
    }

    class FileGenerator {
        private TemplateStringBuilder sb = new TemplateStringBuilder();
        private ClassInfo currClass;
        private List<Token> tokens;
        private Map<Integer, Directive> dirMap;

        FileGenerator(String fullyQualifiedName, String fileName, String source) {
            String[] parts = fullyQualifiedName.split("\\.");
            String className = parts[parts.length - 1];
            StringBuilder packageName = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length - 1; ++i) {
                packageName.append(".").append(parts[i]);
            }
            Tokenizer tokenizer = new Tokenizer();
            this.tokens = tokenizer.tokenize(source);
            List<Directive> dirList = this.getDirectivesList(this.tokens);
            this.dirMap = this.getDirectivesMap(dirList);
            this.currClass = new ClassInfo(dirList.iterator(), className, fileName, this.tokens.size() - 1, true);
            this.buildFile(packageName.toString(), dirList);
        }

        String getFileContents() {
            return this.sb.toString();
        }

        private void buildFile(String packageName, List<Directive> dirList) {
            this.sb.append("package ").append(packageName + ";\n").newLine("import java.io.IOException;").newLine("import manifold.templates.ManifoldTemplates;").newLine("import manifold.templates.runtime.*;\n");
            this.addImports(dirList);
            this.makeClassContent();
        }

        private boolean containsStringContentOrExpr(List<Token> tokens, Integer start, Integer end) {
            if (end == null) {
                end = tokens.size() - 1;
            }
            for (int i = start.intValue(); i <= end; ++i) {
                Token token = tokens.get(i);
                Token.TokenType tokenType = token.getType();
                if (tokenType != Token.TokenType.CONTENT && tokenType != Token.TokenType.EXPR) continue;
                return true;
            }
            return false;
        }

        private void addRenderImpl() {
            boolean needsToCatchIO;
            this.sb.newLine("    public void renderImpl(Appendable buffer, ILayout overrideLayout").append(this.safeTrailingString(this.currClass.params)).append(") {");
            boolean bl = needsToCatchIO = this.currClass.depth == 0;
            if (!needsToCatchIO) {
                needsToCatchIO = this.containsStringContentOrExpr(this.tokens, this.currClass.startTokenPos - 1, this.currClass.endTokenPos);
            }
            if (needsToCatchIO) {
                this.sb.newLine("        try {");
            }
            if (this.currClass.isLayout) {
                this.sb.newLine("            header(buffer);").newLine("            footer(buffer);");
            } else {
                String isOuterTemplate = String.valueOf(this.currClass.depth == 0);
                this.sb.newLine("            beforeRender(buffer, overrideLayout, ").append(isOuterTemplate).append(");\n");
                this.sb.newLine("            long startTime = System.nanoTime();\n");
                this.makeFuncContent(this.currClass.startTokenPos, this.currClass.endTokenPos);
                this.sb.newLine("            long endTime = System.nanoTime();\n");
                this.sb.newLine("            long duration = (endTime - startTime)/1000000;\n");
                this.sb.newLine("            afterRender(buffer, overrideLayout, ").append(isOuterTemplate).append(", duration);\n");
            }
            if (needsToCatchIO) {
                this.sb.newLine("        } catch (IOException e) {\n").newLine("            throw new RuntimeException(e);\n").newLine("        }\n");
            }
            this.sb.newLine("    }\n\n");
        }

        private void addRender() {
            this.sb.newLine("").newLine("    public static String render(").append(this.safeString(this.currClass.params)).append(") {").newLine("      StringBuilder sb = new StringBuilder();").newLine("      renderInto(sb");
            for (String[] param : this.safeParamsList()) {
                this.sb.append(", ").append(param[1]);
            }
            this.sb.append(");").newLine("        return sb.toString();").newLine("    }\n");
        }

        private void addRenderInto() {
            this.sb.newLine("    public static void renderInto(Appendable buffer").append(this.safeTrailingString(this.currClass.params)).append(") {\n").newLine("      " + this.currClass.name + " instance = new " + this.currClass.name + "();").newLine("      instance.renderImpl(buffer, null");
            for (String[] param : this.safeParamsList()) {
                this.sb.append(", ").append(param[1]);
            }
            this.sb.append(");\n").newLine("    }\n\n");
        }

        private void addWithoutLayout() {
            this.sb.newLine("    public static LayoutOverride withoutLayout() {").newLine("        return withLayout(ILayout.EMPTY);").newLine("    }\n\n");
        }

        private void addWithLayout() {
            this.sb.newLine("    public static LayoutOverride withLayout(ILayout layout) {").newLine("      " + this.currClass.name + " instance = new " + this.currClass.name + "();").newLine("        return instance.new LayoutOverride(layout);").newLine("    }\n\n");
        }

        private void addLayoutOverrideClass() {
            this.sb.newLine("    public class LayoutOverride extends BaseLayoutOverride {").newLine("       public LayoutOverride(ILayout override) {").newLine("         super(override);").newLine("       }\n").newLine("").newLine("    public String render(").append(this.safeString(this.currClass.params)).append(") {").newLine("      StringBuilder sb = new StringBuilder();").newLine("      renderImpl(sb, getOverride()");
            for (String[] param : this.safeParamsList()) {
                this.sb.append(", ").append(param[1]);
            }
            this.sb.append(");").newLine("        return sb.toString();").newLine("    }\n").newLine("    public void renderInto(Appendable sb").append(this.safeTrailingString(this.currClass.params)).append(") {").newLine("      renderImpl(sb, getOverride()");
            for (String[] param : this.safeParamsList()) {
                this.sb.append(", ").append(param[1]);
            }
            this.sb.append(");").newLine("    }\n").newLine("    }\n");
        }

        private String safeTrailingString(String string) {
            if (string != null && string.length() > 0) {
                return ", " + string;
            }
            return "";
        }

        private String safeString(String string) {
            if (string != null && string.length() > 0) {
                return string;
            }
            return "";
        }

        private String[][] safeParamsList() {
            String[][] paramsList = this.currClass.paramsList;
            if (paramsList == null) {
                paramsList = new String[0][0];
            }
            return paramsList;
        }

        private void addFileHeader() {
            this.sb.newLine("\n");
            if (this.currClass.depth == 0) {
                if (this.currClass.isLayout) {
                    this.sb.newLine("public class ").append(this.currClass.name).append(" extends ").append(this.currClass.superClass).append(" implements ").append(TemplateGen.LAYOUT_INTERFACE).append(" {");
                } else {
                    this.sb.newLine("public class ").append(this.currClass.name).append(" extends ").append(this.currClass.superClass).append(" {");
                }
            } else {
                this.sb.newLine("public static class ").append(this.currClass.name).append(" extends ").append(this.currClass.superClass).append(" {");
            }
            this.sb.newLine("    private ").append(this.currClass.name).append("(){");
            if (this.currClass.hasLayout) {
                this.sb.newLine("        setLayout(").append(this.currClass.layoutDir.className).append(".asLayout());");
            }
            this.sb.newLine("    }\n");
        }

        private void makeClassContent() {
            this.addFileHeader();
            this.addRender();
            this.addLayoutOverrideClass();
            this.addWithoutLayout();
            this.addWithLayout();
            this.addRenderInto();
            this.addRenderImpl();
            if (this.currClass.isLayout) {
                this.addHeaderAndFooter();
            }
            Iterator<ClassInfo> iterator = this.currClass.nestedClasses.values().iterator();
            while (iterator.hasNext()) {
                ClassInfo nested;
                this.currClass = nested = iterator.next();
                this.makeClassContent();
            }
            this.sb.newLine("}\n");
        }

        private void addHeaderAndFooter() {
            this.sb.newLine("    public static ").append(TemplateGen.LAYOUT_INTERFACE).append(" asLayout() {").newLine("        return new " + this.currClass.name + "();").newLine("    }\n").newLine("    @Override").newLine("    public void header(Appendable buffer) throws IOException {").newLine("        if (getExplicitLayout() != null) {").newLine("            getExplicitLayout().header(buffer);").newLine("        }");
            assert (this.currClass.depth == 0);
            this.makeFuncContent(this.currClass.startTokenPos, this.currClass.contentPos);
            this.sb.newLine("    }").newLine("    @Override").newLine("    public void footer(Appendable buffer) throws IOException {");
            this.makeFuncContent(this.currClass.contentPos, this.currClass.endTokenPos);
            this.sb.newLine("        if (getExplicitLayout() != null) {").newLine("            getExplicitLayout().footer(buffer);").newLine("    }\n}");
        }

        private List<Directive> getDirectivesList(List<Token> tokens) {
            ArrayList<Directive> dirList = new ArrayList<Directive>();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getType() != Token.TokenType.DIRECTIVE) continue;
                dirList.add(new Directive(i, token, tokens));
            }
            return dirList;
        }

        private Map<Integer, Directive> getDirectivesMap(List<Directive> dirList) {
            HashMap<Integer, Directive> dirMap = new HashMap<Integer, Directive>();
            for (Directive dir : dirList) {
                dirMap.put(dir.tokenPos, dir);
            }
            return dirMap;
        }

        private void addImports(List<Directive> dirList) {
            for (Directive dir : dirList) {
                if (dir._dirType != DirType.IMPORT) continue;
                this.sb.newLine("import " + dir.className + ";");
            }
        }

        private void makeFuncContent(Integer startPos, Integer endPos) {
            ArrayList<Integer> bbLineNumbers = new ArrayList<Integer>();
            if (endPos == null) {
                endPos = this.tokens.size() - 1;
            }
            this.sb.newLine("            int lineStart = Thread.currentThread().getStackTrace()[1].getLineNumber() + 1;");
            this.sb.newLine("            try {");
            Token.TokenType lastTokenType = null;
            block7: for (int i = startPos.intValue(); i <= endPos; ++i) {
                Token token = this.tokens.get(i);
                switch (token.getType()) {
                    case CONTENT: {
                        String text = this.makeText(lastTokenType, this.nextTokenType(i + 1, endPos), token.getText());
                        if (text.length() <= 0) break;
                        this.sb.newLine("                buffer.append(\"").append(text.replaceAll("\"", "\\\\\"").replaceAll("\r", "").replaceAll("\n", "\\\\n") + "\");");
                        bbLineNumbers.add(token.getLine());
                        break;
                    }
                    case STMT: {
                        String[] statementList = token.getText().split("\n");
                        for (int j = 0; j < statementList.length; ++j) {
                            String statement = statementList[j].trim().replaceAll("\r", "");
                            this.sb.append("                ").append(statement).append("\n");
                            bbLineNumbers.add(token.getLine() + j);
                        }
                        break;
                    }
                    case EXPR: {
                        this.sb.newLine("                buffer.append(toS(").append(token.getText()).append("));");
                        bbLineNumbers.add(token.getLine());
                        break;
                    }
                    case COMMENT: {
                        break;
                    }
                    case DIRECTIVE: {
                        Directive dir = this.dirMap.get(i);
                        if (dir._dirType == DirType.SECTION) {
                            ClassInfo classToSkipOver = this.currClass.nestedClasses.get(i + 1);
                            i = classToSkipOver.endTokenPos == null ? endPos.intValue() : classToSkipOver.endTokenPos.intValue();
                            this.addSection(dir);
                            break;
                        }
                        if (dir._dirType == DirType.END_SECTION) break block7;
                        if (dir._dirType == DirType.INCLUDE) {
                            this.addInclude(dir);
                            break;
                        }
                        if (dir._dirType != DirType.CONTENT) break;
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                lastTokenType = token.getType();
            }
            String nums = bbLineNumbers.toString().substring(1, bbLineNumbers.toString().length() - 1);
            this.sb.newLine("            } catch (RuntimeException e) {");
            this.sb.newLine("                int[] bbLineNumbers = new int[]{").append(nums).append("};");
            this.sb.newLine("                handleException(e, \"").append(this.currClass.fileName).append("\", lineStart, bbLineNumbers);\n            }");
        }

        private Token.TokenType nextTokenType(int index, Integer endPos) {
            if (index <= endPos) {
                return this.tokens.get(index).getType();
            }
            return null;
        }

        private String makeText(Token.TokenType lastTokenType, Token.TokenType nextTokenType, String text) {
            if (text != null && text.length() > 0) {
                if (lastTokenType != Token.TokenType.CONTENT && lastTokenType != Token.TokenType.EXPR) {
                    if (text.charAt(0) == '\n') {
                        text = text.substring(1);
                    } else if (text.length() > 1 && text.charAt(0) == '\r' && text.charAt(1) == '\n') {
                        text = text.substring(2);
                    }
                }
                text = this.removeTrailingIndentation(text, nextTokenType);
            }
            return text;
        }

        private String removeTrailingIndentation(String text, Token.TokenType nextTokenType) {
            int iEol;
            if (text.length() > 0 && nextTokenType != Token.TokenType.CONTENT && nextTokenType != Token.TokenType.EXPR_ANGLE_BEGIN && nextTokenType != Token.TokenType.EXPR_BRACE_BEGIN && (iEol = text.lastIndexOf(10)) >= 0) {
                for (int i = text.length() - 1; i >= iEol; --i) {
                    char c = text.charAt(i);
                    if (c == ' ' || c == '\t') continue;
                    text = text.substring(0, i + 1);
                    break;
                }
            }
            return text;
        }

        private void addInclude(Directive dir) {
            assert (dir._dirType == DirType.INCLUDE);
            if (dir.conditional != null) {
                this.sb.newLine("            if(").append(dir.conditional).append("){");
            }
            this.sb.newLine("            ").append(dir.className).append(".withoutLayout().renderInto(buffer").append(this.safeTrailingString(dir.params)).append(");");
            if (dir.conditional != null) {
                this.sb.newLine("            ").append("}");
            }
        }

        private void addSection(Directive dir) {
            assert (dir._dirType == DirType.SECTION);
            if (dir.params != null) {
                String paramsWithoutTypes = dir.makeParamsStringWithoutTypes(dir.paramsList);
                this.sb.newLine("            ").append(dir.className).append(".renderInto(buffer, ").append(paramsWithoutTypes).append(");");
            } else {
                this.sb.newLine("            ").append(dir.className).append(".renderInto(buffer);");
            }
        }

        private class TemplateStringBuilder {
            private final String INDENT = "    ";
            private StringBuilder sb = new StringBuilder();

            private TemplateStringBuilder() {
            }

            TemplateStringBuilder newLine(String content) {
                this.sb.append("\n");
                for (int i = 0; i < ((FileGenerator)FileGenerator.this).currClass.depth; ++i) {
                    this.sb.append("    ");
                }
                this.sb.append(content);
                return this;
            }

            TemplateStringBuilder append(String content) {
                this.sb.append(content);
                return this;
            }

            public String toString() {
                return this.sb.toString();
            }
        }
    }

    class Directive {
        int tokenPos;
        Token token;
        DirType _dirType;
        String className;
        String params;
        String[][] paramsList;
        String conditional;

        Directive(int tokenPos, Token token, List<Token> tokens) {
            assert (token.getType() == Token.TokenType.DIRECTIVE);
            this.tokenPos = tokenPos;
            this.token = token;
            this.identifyType();
            this.fillVars(tokens);
        }

        private void identifyType() {
            String text = this.token.getText().trim();
            Optional<DirType> dirType = Arrays.stream(DirType.values()).filter(dt -> text.startsWith(dt.keyword())).findFirst();
            this._dirType = dirType.orElse(DirType.ERRANT);
            if (this._dirType == DirType.ERRANT) {
                TemplateGen.this.addError("Unsupported Directive Type", this.token.getLine());
            }
        }

        private void fillVars(List<Token> tokens) {
            String text = this.token.getText();
            text = text.trim();
            switch (this._dirType) {
                case IMPORT: {
                    this.className = text.substring(DirType.IMPORT.keyword().length()).trim();
                    break;
                }
                case EXTENDS: {
                    this.className = text.substring(DirType.EXTENDS.keyword().length()).trim();
                    break;
                }
                case PARAMS: {
                    String content = text.substring(DirType.PARAMS.keyword().length()).trim();
                    if (content.length() <= 1) break;
                    this.params = content.substring(1, content.length() - 1);
                    this.paramsList = this.splitParamsList(this.params);
                    break;
                }
                case INCLUDE: {
                    this.fillIncludeVars();
                    break;
                }
                case SECTION: {
                    String[] temp = text.substring(DirType.SECTION.keyword().length()).trim().split("\\(", 2);
                    this.className = temp[0].trim();
                    if (temp.length != 2 || temp[1].equals(")")) break;
                    this.params = temp[1].substring(0, temp[1].length() - 1).trim();
                    this.paramsList = this.splitParamsList(this.params);
                    this.findParamTypes(this.paramsList, this.tokenPos, tokens);
                    this.params = this.makeParamsString(this.paramsList);
                    break;
                }
                case END_SECTION: {
                    break;
                }
                case CONTENT: {
                    break;
                }
                case LAYOUT: {
                    this.className = text.substring(DirType.LAYOUT.keyword().length()).trim();
                    break;
                }
            }
        }

        private void fillIncludeVars() {
            String text = this.token.getText();
            text = text.trim();
            String content = text.substring(DirType.INCLUDE.keyword().length()).trim();
            for (int index = 0; index < content.length(); ++index) {
                if (content.charAt(index) == '(') {
                    this.className = content.substring(0, index).trim();
                    this.params = content.substring(index + 1, content.indexOf(41));
                    this.fillConditional(content.substring(content.indexOf(41) + 1).trim());
                    return;
                }
                if (index >= content.length() - 2 || content.charAt(index) != ' ' || content.charAt(index + 1) != 'i' || content.charAt(index + 2) != 'f') continue;
                this.className = content.substring(0, index).trim();
                this.params = null;
                this.fillConditional(content.substring(index + 1).trim());
                return;
            }
            this.className = content;
        }

        private void fillConditional(String conditional) {
            if (conditional.length() < 2) {
                return;
            }
            String conditionalWithoutIf = conditional.substring(2);
            this.conditional = conditionalWithoutIf.charAt(0) == '(' ? conditionalWithoutIf.substring(1, conditionalWithoutIf.length() - 1) : conditionalWithoutIf;
        }

        private String[][] splitParamsList(String params) {
            params = params.trim();
            params = params.replaceAll(" ,", ",").replace(", ", ",");
            String[] parameters = params.split(",");
            String[][] paramsList = new String[parameters.length][2];
            for (int i = 0; i < parameters.length; ++i) {
                paramsList[i] = parameters[i].split(" ", 2);
            }
            return paramsList;
        }

        private String makeParamsString(String[][] paramsList) {
            StringBuilder params = new StringBuilder().append(paramsList[0][0]).append(" ").append(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][0]).append(" ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private void findParamTypes(String[][] params, int tokenPos, List<Token> tokens) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].length != 1) continue;
                String name = params[i][0];
                params[i] = new String[2];
                params[i][0] = this.inferSingleArgumentType(name, tokenPos, tokens);
                params[i][1] = name;
            }
        }

        private String makeParamsStringWithoutTypes(String[][] paramsList) {
            StringBuilder params = new StringBuilder(paramsList[0][1]);
            for (int i = 1; i < paramsList.length; ++i) {
                params.append(", ").append(paramsList[i][1]);
            }
            return params.toString();
        }

        private String inferSingleArgumentType(String name, int tokenPos, List<Token> tokens) {
            String pattern = "([a-zA-Z_$][a-zA-Z_$0-9]* " + name + ")|(\".*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*\")|('.*[a-zA-Z_$][a-zA-Z_$0-9]* " + name + ".*')";
            Pattern argumentRegex = Pattern.compile(pattern);
            for (int i = tokenPos - 1; i >= 0; --i) {
                String[][] outerClassParameters;
                Token currentToken = tokens.get(i);
                if (currentToken.getType() == Token.TokenType.STMT) {
                    String text = currentToken.getText();
                    text = text.trim();
                    Matcher argumentMatcher = argumentRegex.matcher(text);
                    String toReturn = null;
                    while (argumentMatcher.find()) {
                        if (argumentMatcher.group(1) == null) continue;
                        toReturn = argumentMatcher.group(1);
                    }
                    if (toReturn == null) continue;
                    return toReturn.split(" ")[0];
                }
                if (currentToken.getType() != Token.TokenType.DIRECTIVE) continue;
                Directive cur = new Directive(i, currentToken, tokens);
                if (cur._dirType != DirType.PARAMS) continue;
                for (String[] currentParams : outerClassParameters = cur.paramsList) {
                    String parameter = currentParams[1];
                    if (!name.equals(parameter)) continue;
                    return currentParams[0];
                }
            }
            TemplateGen.this.addError("Type for argument can not be inferred: " + name, this.token.getLine());
            return "";
        }
    }

    protected static enum DirType {
        IMPORT("import"),
        EXTENDS("extends"),
        PARAMS("params"),
        INCLUDE("include"),
        SECTION("section"),
        END_SECTION("end"),
        CONTENT("content"),
        LAYOUT("layout"),
        ERRANT("#errant");

        private String _keyword;

        private DirType(String keyword) {
            this._keyword = keyword;
        }

        public String keyword() {
            return this._keyword;
        }
    }

    class ClassInfo {
        Map<Integer, ClassInfo> nestedClasses = new HashMap<Integer, ClassInfo>();
        String params = null;
        String[][] paramsList = null;
        String name;
        String fileName;
        String superClass = "BaseTemplate";
        int startTokenPos;
        Integer endTokenPos;
        int depth;
        boolean isLayout = false;
        boolean hasLayout = false;
        Directive layoutDir;
        int contentPos;

        ClassInfo(Iterator<Directive> dirIterator, String name, String fileName, Integer endTokenPos, boolean outermost) {
            assert (outermost);
            this.name = name;
            this.fileName = fileName;
            this.startTokenPos = 0;
            this.endTokenPos = endTokenPos;
            this.depth = 0;
            this.fillClassInfo(dirIterator);
        }

        ClassInfo(Iterator<Directive> dirIterator, String name, String fileName, String params, String[][] paramList, int startTokenPos, int depth, String superClass) {
            this.name = name;
            this.fileName = fileName;
            this.params = params;
            this.paramsList = paramList;
            this.startTokenPos = startTokenPos;
            this.depth = depth;
            this.superClass = superClass;
            this.fillClassInfo(dirIterator);
        }

        /*
         * Enabled aggressive block sorting
         */
        void fillClassInfo(Iterator<Directive> dirIterator) {
            boolean endSec = false;
            while (dirIterator.hasNext()) {
                Directive dir = dirIterator.next();
                switch (dir._dirType) {
                    case IMPORT: {
                        break;
                    }
                    case INCLUDE: {
                        break;
                    }
                    case EXTENDS: {
                        if (this.depth == 0) {
                            if (this.superClass.equals(TemplateGen.BASE_CLASS_NAME)) {
                                this.superClass = dir.className;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Extends Directive: class cannot extend 2 classes", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Extends Directive: class cannot extend within section", dir.token.getLine());
                        break;
                    }
                    case PARAMS: {
                        if (this.depth == 0) {
                            if (this.params == null) {
                                this.params = dir.params;
                                this.paramsList = dir.paramsList;
                                break;
                            }
                            TemplateGen.this.addError("Invalid Params Directive: class cannot have 2 params directives", dir.token.getLine());
                            break;
                        }
                        TemplateGen.this.addError("Invalid Params Directive: class cannot have param directive within section", dir.token.getLine());
                        break;
                    }
                    case SECTION: {
                        this.addNestedClass(new ClassInfo(dirIterator, dir.className, this.fileName, dir.params, dir.paramsList, dir.tokenPos + 1, this.depth + 1, this.superClass));
                        break;
                    }
                    case END_SECTION: {
                        if (this.endTokenPos == null) {
                            this.endTokenPos = dir.tokenPos;
                            return;
                        } else {
                            TemplateGen.this.addError("Invalid End Section Directive: section declaration does not exist", dir.token.getLine());
                        }
                        return;
                    }
                    case CONTENT: {
                        if (this.isLayout) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot have two layout instantiations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Instantiation: cannot instantiate layout within section", dir.token.getLine());
                            break;
                        }
                        this.isLayout = true;
                        this.contentPos = dir.tokenPos;
                        break;
                    }
                    case LAYOUT: {
                        if (this.hasLayout) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot have two layout declarations", dir.token.getLine());
                            break;
                        }
                        if (this.depth > 0) {
                            TemplateGen.this.addError("Invalid Layout Declaration: cannot declare layout within section", dir.token.getLine());
                            break;
                        }
                        this.hasLayout = true;
                        this.layoutDir = dir;
                    }
                }
            }
            if (endSec) return;
            if (this.depth == 0) {
                if ($assertionsDisabled) return;
                if (this.startTokenPos == 0) return;
                throw new AssertionError();
            }
            TemplateGen.this.addError("Reached end of file before parsing section: " + this.name, 0);
        }

        void addNestedClass(ClassInfo nestedClass) {
            this.nestedClasses.put(nestedClass.startTokenPos, nestedClass);
        }
    }
}

