/*
 * Decompiled with CFR 0.152.
 */
package manifold.io.extensions.java.io.Reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import manifold.ext.api.Extension;
import manifold.ext.api.This;
import manifold.io.extensions.java.io.BufferedReader.ManBufferedReaderExt;

@Extension
public class ManReaderExt {
    public static BufferedReader buffered(@This Reader thiz) {
        return ManReaderExt.buffered(thiz, 8192);
    }

    public static BufferedReader buffered(@This Reader thiz, int bufferSize) {
        if (thiz instanceof BufferedReader) {
            return (BufferedReader)thiz;
        }
        return new BufferedReader(thiz, bufferSize);
    }

    public static void forEachLine(@This Reader thiz, Consumer<String> action) {
        ManReaderExt.useLines(thiz, it -> {
            it.forEach(action);
            return null;
        });
    }

    public static List<String> readLines(@This Reader thiz) {
        ArrayList<String> result = new ArrayList<String>();
        ManReaderExt.forEachLine(thiz, it -> result.add((String)it));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T useLines(@This Reader thiz, Function<Iterable<String>, T> block) {
        try (BufferedReader reader = ManReaderExt.buffered(thiz);){
            Iterable<String> iterable = block.apply(ManBufferedReaderExt.lineSequence(reader));
            return (T)iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

