/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.api.BasicJavacTask;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import manifold.api.host.IManifoldHost;
import manifold.api.type.ICompilerComponent;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.internal.javac.CompiledTypeProcessor;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.templ.StringLiteralTemplateProcessor;
import manifold.util.ServiceUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class TypeProcessor
extends CompiledTypeProcessor {
    private Map<File, Set<String>> _typesCompiledByFile = new ConcurrentHashMap<File, Set<String>>();
    private Set<Object> _drivers = new ConcurrentHashSet<Object>();

    TypeProcessor(IManifoldHost host, BasicJavacTask javacTask) {
        super(host, javacTask);
        this.loadCompilerComponents(javacTask);
    }

    public Map<File, Set<String>> getTypesCompiledByFile() {
        return this._typesCompiledByFile;
    }

    private void loadCompilerComponents(BasicJavacTask javacTask) {
        TreeSet<ICompilerComponent> compilerComponents = new TreeSet<ICompilerComponent>(Comparator.comparing(c -> c.getClass().getTypeName()));
        this.loadBuiltin(compilerComponents);
        ServiceUtil.loadRegisteredServices(compilerComponents, ICompilerComponent.class, this.getClass().getClassLoader());
        compilerComponents.forEach(cc -> cc.init(javacTask));
    }

    private void loadBuiltin(SortedSet<ICompilerComponent> compilerComponents) {
        if (JavacPlugin.instance() == null || JavacPlugin.instance().isStringTemplatesEnabled()) {
            compilerComponents.add(new StringLiteralTemplateProcessor(this));
        }
    }

    @Override
    public void process(TypeElement element, IssueReporter<JavaFileObject> issueReporter) {
        if (IDynamicJdk.isInitializing()) {
            return;
        }
        for (ITypeManifold sp : this.getHost().getSingleModule().getTypeManifolds()) {
            if (!(sp instanceof ITypeProcessor)) continue;
            try {
                ((ITypeProcessor)((Object)sp)).process(element, this, issueReporter);
            }
            catch (Throwable e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                issueReporter.reportError("Fatal error processing with Manifold type processor: " + sp.getClass().getName() + "\non type: " + element.getQualifiedName() + "\nPlease report the error with the accompanying stack trace.\n" + stackTrace);
                throw e;
            }
        }
    }

    public void addDrivers(Set<Object> drivers) {
        this._drivers.addAll(drivers);
    }

    public Set<Object> getDrivers() {
        return this._drivers;
    }
}

