/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import manifold.util.StreamUtil;

public class ManDiagnosticHandler
extends Log.DiagnosticHandler {
    private Set<Integer> _escapedPos;
    private String _source;

    public ManDiagnosticHandler(Context ctx) {
        this.install(Log.instance(ctx));
        this._escapedPos = new HashSet<Integer>();
    }

    public boolean isEscapedPos(int pos) {
        return this._escapedPos.contains(pos);
    }

    @Override
    public void report(JCDiagnostic jcDiagnostic) {
        int pos;
        String source;
        char escaped;
        if (jcDiagnostic.getCode().equals("compiler.err.illegal.esc.char") && (escaped = (source = this.getSource(jcDiagnostic)).charAt(pos = (int)jcDiagnostic.getPosition())) == '$') {
            this._escapedPos.add(pos);
            return;
        }
        this.prev.report(jcDiagnostic);
    }

    private String getSource(JCDiagnostic jcDiagnostic) {
        if (this._source == null) {
            try {
                Reader reader = jcDiagnostic.getSource().openReader(true);
                this._source = StreamUtil.getContent(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this._source;
    }
}

