/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.Set;
import javax.tools.JavaFileObject;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.ManResolve;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class ManClassFinder
extends ClassFinder {
    private final Context _ctx;
    private final ModuleFinder _moduleFinder;
    private final Symtab _symtab;

    public static ManClassFinder instance(Context ctx) {
        ClassFinder finder = (ClassFinder)ctx.get(classFinderKey);
        if (!(finder instanceof ManClassFinder)) {
            ctx.put(classFinderKey, (ClassFinder)null);
            finder = new ManClassFinder(ctx);
        }
        return (ManClassFinder)finder;
    }

    private ManClassFinder(Context context) {
        super(context);
        this._ctx = context;
        this._symtab = Symtab.instance(this._ctx);
        this._moduleFinder = ModuleFinder.instance(this._ctx);
        JavaCompiler compiler = JavaCompiler.instance(context);
        ReflectUtil.field(compiler, "finder").set(this);
        this.sourceCompleter = (Symbol.Completer)ReflectUtil.field(compiler, "sourceCompleter").get();
        ReflectUtil.field(Symtab.instance(context), "initialCompleter").set(this.getCompleter());
        ReflectUtil.field(ManResolve.instance(context), "finder").set(this);
    }

    @Override
    public Symbol.ClassSymbol loadClass(Symbol.ModuleSymbol msym, Name flatname) throws Symbol.CompletionFailure {
        try {
            return super.loadClass(msym, flatname);
        }
        catch (Symbol.CompletionFailure ex) {
            Symbol.ClassSymbol extClassSym = this.loadWhileInExtensionClass(msym, flatname);
            if (extClassSym != null) {
                return extClassSym;
            }
            throw ex;
        }
    }

    private Symbol.ClassSymbol loadWhileInExtensionClass(Symbol.ModuleSymbol msym, Name flatname) {
        Env env = (Env)ReflectUtil.field(Attr.instance(this._ctx), "env").get();
        if (env == null) {
            return null;
        }
        JavaFileObject sourceFile = env.toplevel.getSourceFile();
        if (!(sourceFile instanceof GeneratedJavaStubFileObject)) {
            return null;
        }
        Modules modules = Modules.instance(this._ctx);
        HashSet<Symbol.ModuleSymbol> recoverableModules = new HashSet<Symbol.ModuleSymbol>(modules.allModules());
        recoverableModules.remove(msym);
        recoverableModules.add(this._symtab.unnamedModule);
        Symtab symtab = Symtab.instance(this._ctx);
        for (Symbol.ModuleSymbol ms : recoverableModules) {
            if (ms.classLocation == null) {
                ms = this._moduleFinder.findModule(ms);
            }
            if (ms.kind == Kinds.Kind.ERR) continue;
            Symbol.ClassSymbol maybe = null;
            try {
                maybe = super.loadClass(ms, flatname);
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
            if (maybe == null || !maybe.exists()) continue;
            return maybe;
        }
        return null;
    }

    private void addJavaSeModule(Set<Symbol.ModuleSymbol> recoverableModules) {
        if (JreUtil.isJava9Modular_compiler(this._ctx)) {
            Symbol.ModuleSymbol javaSeModule = ModuleFinder.instance(this._ctx).findModule(Names.instance(this._ctx).fromString("java.se"));
            javaSeModule.complete();
            if (javaSeModule != null && javaSeModule.requires != null) {
                for (Directive.RequiresDirective directive : javaSeModule.requires) {
                    recoverableModules.add(directive.getDependency());
                }
            }
        }
    }
}

